/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) StringArrayConverter.java 1.12 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.util.Vector;
import java.util.StringTokenizer;

/**
 * Converts array of strings to a single string and back again.  The
 * string representation is a string of comma-separated strings.
 * Commas are not (currently) allowed in the strings.
 *
 * @version 1.12, 07/18/96
 */
public class StringArrayConverter extends Converter {

  public String convertToString(Object obj) {
    if (obj != null) {
      String[] a = (String[]) obj;

      StringBuffer retval = new StringBuffer();
      for (int i=0; i < a.length; i++) {
	retval.append(a[i]);
	if (i != (a.length-1))
	  retval.append(",");
      }

      return(retval.toString());
    }
    else {
      return("");
    }
  }

  public Object convertFromString(String s) {
    if (s != null) {
      Vector strbuf = new Vector();

      StringTokenizer st = new StringTokenizer(s, ",");
      for ( ; st.hasMoreTokens(); )
	strbuf.addElement(st.nextToken());

      if (strbuf.size() > 0) {
	String retval[] = new String[strbuf.size()];
	for (int i = 0; i < strbuf.size(); i++)
	  retval[i] = (String) strbuf.elementAt(i);
	return(retval);
      }
    }
    return(null);
  }

  public String convertToCode(Object obj) {
    StringBuffer buf = new StringBuffer();

    buf.append("convert(\"[Ljava.lang.String;\", ");
    ListParser.quote(convertToString(obj), buf, true);
    buf.append(")");

    return buf.toString();
  }
}
