/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) SubFieldTokenizer.java 1.3 - last change made 04/25/96
 */

package sunsoft.jws.visual.rt.type;

import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * Separates a string into sub-field (key-value pairs.)  The syntax of the
 * string needs to be something like this:
 * <pre>
 *     name=Helvetica;style=italic;size=12;
 * </pre>
 * A hashtable of the keys->values is created, which the caller can then
 * run through to determine what values were set.  Case of field names
 * is always ignored.
 *
 * @version 	1.3, 04/25/96
 */
public class SubFieldTokenizer {
  private Hashtable table;

  public SubFieldTokenizer(String s) {
    table = new Hashtable();
    
    StringTokenizer st = new StringTokenizer(s, ";");
    while (st.hasMoreTokens()) {
      String spec = st.nextToken();
      if (spec.length() > 0) {
	int index = spec.indexOf('=');
	if (index != -1) {
	  String key = spec.substring(0, index).trim().toLowerCase();
	  String value = spec.substring(index + 1).trim();
	  if (key.length() > 0) {
	    table.put(key, value);
	  }
	}
      }
    }
  }

  public Hashtable getHashtable() {
    return(table);
  }
}
