/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) UnknownTypeConverter.java 1.8 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Color;

/**
 * Handles conversion of objects of unknown type to string and back again.
 *
 * @version 	1.8, 07/18/96
 */
public class UnknownTypeConverter extends Converter {
  /**
   * Handles conversion of an unknown object type.
   *
   * @exception Error when called
   */
  public String convertToString(Object obj) {
    throw new Error("Warning: no type converter for type: " +
		    ((obj == null) ? "null" : obj.getClass().getName()));
  }

  /**
   * Handles conversion of an string type representation.
   *
   * @exception Error when called
   */
  public Object convertFromString(String s) {
    throw new Error("Warning: don't know what type to convert this to: \""
		    + s + "\"");
  }
}
