/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import sdoc.SimpleStyle;
import sdoc.SyntaxDocument;
import sdoc.SyntaxEditorKit;
import sdoc.SyntaxEditorPaneUI;
import sdoc.SyntaxTextUI;
import sdoc.lexers.JavaLexer;
import sdoc.lexers.Lexer;
import sdoc.lexers.SqlLexer;
import sdoc.lexers.XmlLexer;

public class SyntaxSupport {
    public static final int JAVA_LEXER = 1001;
    public static final int XML_LEXER = 1002;
    public static final int SQL_LEXER = 1003;
    public static final Integer FORCE_AA_ALWAYS_ON = new Integer(1);
    public static final Integer FORCE_AA_ALWAYS_OFF = new Integer(2);
    public static final Integer FORCE_AA_DEFAULT = new Integer(3);
    static final String FORCE_AA_TEXTAREA = "force_aa_textarea";
    static final String FORCE_AA_ITALICS = "force_aa_italics";
    static final String DRAW_PRINT_MARGIN = "draw_print_margin";
    static final String PRINT_MARGIN_WIDTH = "print_margin_width";
    static final String USE_DEFAULT_UNDO_MANAGER = "use_default_undo_manager";
    static final String HIGHLIGHT_CURRENT_LINE = "highlight_curent_line";
    static final String CURRENT_LINE_FILL_COLOR = "current_line_fill_color";
    static final String CURRENT_LINE_BORDER_COLOR = "current_line_border_color";
    static final String DRAW_CURRENT_LINE_FILL = "draw_current_line_fill";
    static final String DRAW_CURRENT_LINE_BORDER = "draw_Current_line_border";
    private final Map lexers = new HashMap();
    private final Map config = new HashMap();
    private static SyntaxSupport me;

    public static SyntaxSupport getInstance() {
        if (me == null) {
            me = new SyntaxSupport();
        }
        return me;
    }

    private SyntaxSupport() {
        this.config.put(FORCE_AA_TEXTAREA, FORCE_AA_DEFAULT);
        this.config.put(FORCE_AA_ITALICS, FORCE_AA_ALWAYS_ON);
        this.config.put(DRAW_PRINT_MARGIN, Boolean.TRUE);
        this.config.put(PRINT_MARGIN_WIDTH, new Integer(80));
        this.config.put(HIGHLIGHT_CURRENT_LINE, Boolean.TRUE);
        this.config.put(CURRENT_LINE_FILL_COLOR, new Color(232, 244, 248));
        this.config.put(CURRENT_LINE_BORDER_COLOR, new Color(186, 222, 233));
        this.config.put(DRAW_CURRENT_LINE_FILL, Boolean.TRUE);
        this.config.put(DRAW_CURRENT_LINE_BORDER, Boolean.TRUE);
        this.config.put(USE_DEFAULT_UNDO_MANAGER, Boolean.TRUE);
        SimpleStyle keyword = new SimpleStyle();
        keyword.fg = new Color(127, 0, 85);
        keyword.bg = Color.WHITE;
        keyword.bold = true;
        SimpleStyle plain = new SimpleStyle();
        plain.fg = Color.BLACK;
        plain.bg = Color.white;
        SimpleStyle plainbold = new SimpleStyle();
        plainbold.fg = Color.GRAY.darker().darker();
        plainbold.bg = Color.white;
        SimpleStyle green = new SimpleStyle();
        green.fg = new Color(63, 127, 95);
        green.italic = true;
        green.bg = Color.WHITE;
        SimpleStyle blue = new SimpleStyle();
        blue.fg = new Color(63, 95, 191);
        blue.italic = true;
        blue.bg = Color.WHITE;
        SimpleStyle literal = new SimpleStyle();
        literal.fg = new Color(0, 0, 128);
        literal.bg = Color.WHITE;
        HashMap<Integer, SimpleStyle> xmlMap = new HashMap<Integer, SimpleStyle>();
        xmlMap.put(new Integer(15), keyword);
        xmlMap.put(new Integer(19), plain);
        xmlMap.put(new Integer(-1), plain);
        xmlMap.put(new Integer(0), plain);
        xmlMap.put(new Integer(17), plain);
        xmlMap.put(new Integer(18), plain);
        xmlMap.put(new Integer(6), green);
        xmlMap.put(new Integer(21), literal);
        xmlMap.put(new Integer(3), green);
        xmlMap.put(new Integer(5), keyword);
        xmlMap.put(new Integer(12), literal);
        xmlMap.put(new Integer(13), literal);
        xmlMap.put(new Integer(26), green);
        xmlMap.put(new Integer(25), blue);
        xmlMap.put(new Integer(16), green);
        xmlMap.put(new Integer(20), green);
        HashMap<Integer, SimpleStyle> javaMap = new HashMap<Integer, SimpleStyle>();
        javaMap.put(new Integer(5), keyword);
        javaMap.put(new Integer(15), keyword);
        javaMap.put(new Integer(8), literal);
        javaMap.put(new Integer(9), literal);
        javaMap.put(new Integer(11), literal);
        javaMap.put(new Integer(10), literal);
        javaMap.put(new Integer(6), plainbold);
        javaMap.put(new Integer(0), plain);
        javaMap.put(new Integer(17), plain);
        javaMap.put(new Integer(21), blue);
        javaMap.put(new Integer(18), plain);
        javaMap.put(new Integer(13), literal);
        javaMap.put(new Integer(26), green);
        javaMap.put(new Integer(25), green);
        javaMap.put(new Integer(12), literal);
        javaMap.put(new Integer(1), green);
        javaMap.put(new Integer(3), green);
        javaMap.put(new Integer(4), blue);
        javaMap.put(new Integer(2), green);
        javaMap.put(new Integer(16), plain);
        javaMap.put(new Integer(20), plain);
        javaMap.put(new Integer(19), plain);
        javaMap.put(new Integer(24), blue);
        javaMap.put(new Integer(23), blue);
        HashMap<Integer, SimpleStyle> sqlMap = new HashMap<Integer, SimpleStyle>();
        sqlMap.put(new Integer(0), plain);
        sqlMap.put(new Integer(17), plain);
        sqlMap.put(new Integer(5), keyword);
        sqlMap.put(new Integer(2), green);
        sqlMap.put(new Integer(18), plain);
        sqlMap.put(new Integer(20), plain);
        sqlMap.put(new Integer(19), plain);
        sqlMap.put(new Integer(9), literal);
        sqlMap.put(new Integer(10), literal);
        sqlMap.put(new Integer(12), literal);
        sqlMap.put(new Integer(13), literal);
        sqlMap.put(new Integer(21), plain);
        sqlMap.put(new Integer(23), green);
        this.lexers.put(new Integer(1001), new Object[]{new JavaLexer(), javaMap});
        this.lexers.put(new Integer(1002), new Object[]{new XmlLexer(), xmlMap});
        this.lexers.put(new Integer(1003), new Object[]{new SqlLexer(), sqlMap});
    }

    public void addSupport(int syntaxType, JTextComponent comp) {
        Object[] objs = (Object[])this.lexers.get(new Integer(syntaxType));
        if (objs == null) {
            throw new IllegalArgumentException("No lexer for type " + syntaxType);
        }
        Map styleMap = (Map)objs[1];
        this.addSupport(syntaxType, comp, styleMap);
    }

    public void addSupport(int syntaxType, JTextComponent comp, Map styleMap) {
        SyntaxDocument doc = new SyntaxDocument(syntaxType, styleMap, comp);
        if (comp instanceof JTextArea) {
            comp.setUI(new SyntaxTextUI());
        } else {
            ((JEditorPane)comp).setEditorKit(new SyntaxEditorKit());
            ((JEditorPane)comp).setUI(new SyntaxEditorPaneUI());
        }
        comp.setDocument(doc);
        comp.setFont(new Font("dialoginput", 0, 12));
        this.loadUndoManager(doc, comp);
    }

    public void addSyntax(int syntaxType, Lexer lexer, Map styleMap) {
        this.lexers.put(new Integer(syntaxType), new Object[]{lexer, styleMap});
    }

    public boolean removeSyntax(int type) {
        return this.lexers.remove(new Integer(type)) == null;
    }

    public Lexer getLexerForType(int type) {
        Object[] objs = (Object[])this.lexers.get(new Integer(type));
        if (objs != null) {
            return (Lexer)objs[0];
        }
        return null;
    }

    public Map getStyleMapForType(int type) {
        Object[] objs = (Object[])this.lexers.get(new Integer(type));
        if (objs != null) {
            return (Map)objs[1];
        }
        return new HashMap();
    }

    public SyntaxSupport forceAA(Integer aaState) {
        if (!(aaState.equals(FORCE_AA_ALWAYS_OFF) || aaState.equals(FORCE_AA_ALWAYS_ON) || aaState.equals(FORCE_AA_DEFAULT))) {
            throw new IllegalStateException("State must be SyntaxSupport.FORCE_AA_ALWAYS_ON, SyntaxSupport.FORCE_AA_ALWAYS_OFF, or SyntaxSupport.FORCE_AA_ALWAYS_DEFAULT");
        }
        this.config.put(FORCE_AA_TEXTAREA, aaState);
        return this;
    }

    public SyntaxSupport forceAAItalics(Integer aaState) {
        if (!(aaState.equals(FORCE_AA_ALWAYS_OFF) || aaState.equals(FORCE_AA_ALWAYS_ON) || aaState.equals(FORCE_AA_DEFAULT))) {
            throw new IllegalStateException("State must be SyntaxSupport.FORCE_AA_ALWAYS_ON, SyntaxSupport.FORCE_AA_ALWAYS_OFF, or SyntaxSupport.FORCE_AA_ALWAYS_DEFAULT");
        }
        this.config.put(FORCE_AA_ITALICS, aaState);
        return this;
    }

    public SyntaxSupport showPrintMargin(boolean show) {
        this.config.put(DRAW_PRINT_MARGIN, new Boolean(show));
        return this;
    }

    public SyntaxSupport setPrintMarginWidth(int chars) {
        this.config.put(PRINT_MARGIN_WIDTH, new Integer(chars));
        return this;
    }

    public SyntaxSupport highlightCurrent(boolean doHighlight) {
        this.config.put(HIGHLIGHT_CURRENT_LINE, new Boolean(doHighlight));
        return this;
    }

    public SyntaxSupport setCurrentLineHighlighFillColor(Color color) {
        this.config.put(CURRENT_LINE_FILL_COLOR, color);
        return this;
    }

    public SyntaxSupport setCurrentLineHighlightBorderColor(Color color) {
        this.config.put(CURRENT_LINE_BORDER_COLOR, color);
        return this;
    }

    public SyntaxSupport setDrawCurrentlineBorder(boolean draw) {
        this.config.put(DRAW_CURRENT_LINE_BORDER, new Boolean(draw));
        return this;
    }

    public SyntaxSupport setDrawCurrentLineFill(boolean draw) {
        this.config.put(DRAW_CURRENT_LINE_FILL, new Boolean(draw));
        return this;
    }

    public SyntaxSupport setUseDefaultUndoManager(boolean use) {
        this.config.put(USE_DEFAULT_UNDO_MANAGER, new Boolean(use));
        return this;
    }

    public Color getCurrentLineBorderColor() {
        return this.getColor(CURRENT_LINE_BORDER_COLOR);
    }

    public Color getCurrentLineFillColor() {
        return this.getColor(CURRENT_LINE_FILL_COLOR);
    }

    public boolean getShouldDrawCurrentLineBorder() {
        return this.getBoolean(DRAW_CURRENT_LINE_BORDER);
    }

    public boolean getShouldDrawCurrentLineFill() {
        return this.getBoolean(DRAW_CURRENT_LINE_FILL);
    }

    public boolean getShouldDrawPrintMargin() {
        return this.getBoolean(DRAW_PRINT_MARGIN);
    }

    public int getForceAAItalics() {
        return this.getInt(FORCE_AA_ITALICS);
    }

    public int getForceAATextArea() {
        return this.getInt(FORCE_AA_TEXTAREA);
    }

    public boolean getShouldHighlightCurrentLine() {
        return this.getBoolean(HIGHLIGHT_CURRENT_LINE);
    }

    public int getPringMarginWidth() {
        return this.getInt(PRINT_MARGIN_WIDTH);
    }

    public boolean useDefaultUndoManager(boolean b) {
        return this.getBoolean(USE_DEFAULT_UNDO_MANAGER);
    }

    private void loadUndoManager(SyntaxDocument doc, JTextComponent comp) {
        if (this.getBoolean(USE_DEFAULT_UNDO_MANAGER)) {
            final UndoManager manager = new UndoManager();
            doc.addUndoableEditListener(manager);
            comp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "redo");
            comp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "undo");
            comp.getActionMap().put("redo", new TextAction("redo"){

                public void actionPerformed(ActionEvent e) {
                    if (manager.canRedo()) {
                        manager.redo();
                    }
                }
            });
            comp.getActionMap().put("undo", new TextAction("undo"){

                public void actionPerformed(ActionEvent e) {
                    if (manager.canUndo()) {
                        manager.undo();
                    }
                }
            });
        }
    }

    boolean getBoolean(String key) {
        return Boolean.TRUE.equals(this.config.get(key));
    }

    int getInt(String key) {
        Object o;
        if (this.config.containsKey(key) && (o = this.config.get(key)) instanceof Integer) {
            return (Integer)o;
        }
        return -1;
    }

    Color getColor(String key) {
        Object o;
        if (this.config.containsKey(key) && (o = this.config.get(key)) instanceof Color) {
            return (Color)o;
        }
        return Color.BLACK;
    }
}

