/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.tree.GuiManager;
import jarxplorer.gui.tree.LifeCycle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class MainMenu
implements LifeCycle {
    private JMenuBar menuBar;
    private JMenu file;
    private JMenuItem open;
    private JMenuItem close;
    private JMenuItem exit;
    private JCheckBoxMenuItem onTop;
    private GuiManager uiManager;

    public MainMenu(GuiManager guiManager) {
        this.uiManager = guiManager;
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.open = new JMenuItem("Open");
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.uiManager.preLoading();
            }
        });
        this.close = new JMenuItem("Close");
        this.close.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.uiManager.closed();
            }
        });
        this.exit = new JMenuItem("Exit");
        this.exit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.file.add(this.open);
        this.file.add(this.close);
        this.file.add(new JSeparator());
        this.file.add(this.exit);
        JMenu jMenu = new JMenu("Window");
        this.onTop = new JCheckBoxMenuItem("Always On top");
        this.onTop.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.onTop.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    MainMenu.this.uiManager.setAlwaysOnTop(false);
                } else {
                    MainMenu.this.uiManager.setAlwaysOnTop(true);
                }
            }
        });
        jMenu.add(this.onTop);
        JMenu jMenu2 = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("About");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.uiManager.showAboutPanel();
            }
        });
        jMenu2.add(jMenuItem);
        this.menuBar.add(this.file);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void init() {
        this.open.setEnabled(true);
        this.close.setEnabled(false);
        this.exit.setEnabled(true);
    }

    public void init(boolean bl) {
        this.open.setEnabled(true);
        this.close.setEnabled(false);
        this.exit.setEnabled(true);
        if (bl) {
            this.onTop.setSelected(true);
        }
    }

    public void preLoading() {
    }

    public void loading() {
        this.open.setEnabled(false);
        this.close.setEnabled(false);
        this.exit.setEnabled(true);
    }

    public void loaded() {
        this.open.setEnabled(false);
        this.close.setEnabled(true);
        this.exit.setEnabled(true);
    }

    public void closed() {
        this.init();
    }
}

