/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.decompiler.SingletonCodePanel;
import jarxplorer.gui.tree.PropertiesPanel;
import jarxplorer.helpers.Utilities;
import jarxplorer.model.ClassNode;
import jarxplorer.model.FileNode;
import jarxplorer.model.MyTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MyPopupMenu
extends MouseAdapter {
    private JTree tree;
    private JPopupMenu menu;
    private JMenuItem open;
    private JMenuItem decompile;
    private JMenuItem properties;
    private int x;
    private int y;

    public MyPopupMenu(final JTree jTree) {
        this.tree = jTree;
        this.menu = new JPopupMenu();
        this.open = new JMenuItem("Open");
        this.open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = jTree.getPathForLocation(MyPopupMenu.this.x, MyPopupMenu.this.y);
                FileNode fileNode = (FileNode)treePath.getLastPathComponent();
                String string = fileNode.getFile().getAbsolutePath();
                Utilities.launchFile(fileNode, string);
            }
        });
        this.decompile = new JMenuItem("Decompile");
        this.decompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = jTree.getPathForLocation(MyPopupMenu.this.x, MyPopupMenu.this.y);
                TreePath[] treePathArray = jTree.getSelectionPaths();
                SingletonCodePanel singletonCodePanel = SingletonCodePanel.getSingletonCodePanel();
                for (TreePath treePath2 : treePathArray) {
                    MyTreeNode myTreeNode = (MyTreeNode)treePath2.getLastPathComponent();
                    if (!myTreeNode.getType().equalsIgnoreCase("ClassNode")) continue;
                    ClassNode classNode = (ClassNode)myTreeNode;
                    singletonCodePanel.addTabWorker(classNode, singletonCodePanel);
                }
                jTree.setSelectionPath(null);
            }
        });
        this.properties = new JMenuItem("Properties");
        this.properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = jTree.getPathForLocation(MyPopupMenu.this.x, MyPopupMenu.this.y);
                MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
                if (myTreeNode.getType().equalsIgnoreCase("ClassNode")) {
                    new PropertiesPanel(myTreeNode).setVisible(true);
                }
            }
        });
        this.menu.add(this.open);
        this.menu.addSeparator();
        this.menu.add(this.properties);
        this.menu.add(this.decompile);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isNodeValid(mouseEvent)) {
            this.displayMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isNodeValid(mouseEvent)) {
            this.displayMenu(mouseEvent);
        }
    }

    private void displayMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private boolean isNodeValid(MouseEvent mouseEvent) {
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
            String string = myTreeNode.getType();
            if (string.equalsIgnoreCase("ClassNode")) {
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 1) {
                    this.tree.setSelectionPath(treePath);
                }
                this.showClassMenu();
                return true;
            }
            if (string.equalsIgnoreCase("FileNode") && myTreeNode.isLeaf(myTreeNode) && Utilities.isWindows()) {
                this.showFileMenu();
                return true;
            }
            return false;
        }
        return false;
    }

    private void showFileMenu() {
        this.open.setEnabled(true);
        this.properties.setEnabled(false);
        this.decompile.setEnabled(false);
    }

    private void showClassMenu() {
        this.open.setEnabled(false);
        this.properties.setEnabled(true);
        this.decompile.setEnabled(true);
    }
}

