/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.tree.MainUI;
import jarxplorer.gui.tree.MyPopupMenu;
import jarxplorer.gui.tree.PropertiesPanel;
import jarxplorer.gui.tree.TreeEventListener;
import jarxplorer.gui.tree.TreeRenderer;
import jarxplorer.helpers.Utilities;
import jarxplorer.model.FileNode;
import jarxplorer.model.JarTreeModel;
import jarxplorer.model.MyTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreePanel
extends JPanel {
    JTree tree;
    private TreeModel jarTreeModel = null;
    private JScrollPane scrollPane;
    private boolean visible;
    private MouseMotionListener mm;
    private MouseListener ml;

    public TreePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 2));
        this.setLayout(new BorderLayout());
    }

    public void addToFrame(JFrame jFrame) {
        jFrame.add((Component)this, "Center");
        this.repaint();
        this.revalidate();
    }

    public void removeFromFrame(JFrame jFrame) {
        this.remove(this.scrollPane);
        this.tree = null;
        this.jarTreeModel = null;
        this.scrollPane = null;
        this.visible = false;
        jFrame.remove(this);
        this.repaint();
        this.revalidate();
    }

    public JTree buildTree(String string) {
        this.jarTreeModel = new JarTreeModel(string);
        this.tree = new JTree(this.jarTreeModel);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.ml = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = TreePanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = TreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1) {
                        TreePanel.this.mySingleClick(n, treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        TreePanel.this.myDoubleClick(n, treePath);
                    }
                }
            }
        };
        this.tree.addMouseListener(this.ml);
        this.mm = new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TreePanel.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = TreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    TreePanel.this.onMouseMoved(n, treePath);
                } else {
                    TreePanel.this.getParent().setCursor(new Cursor(0));
                }
            }
        };
        this.tree.addMouseMotionListener(this.mm);
        this.tree.addMouseListener(new MyPopupMenu(this.tree));
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setBorder(null);
        this.visible = true;
        this.add((Component)this.scrollPane, "Center");
        return this.tree;
    }

    private void onMouseMoved(int n, TreePath treePath) {
        MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
        String string = myTreeNode.getType();
        String[] stringArray = new String[]{"FieldNode", "MethodNode", "ConstructorNode"};
        List<String> list = Arrays.asList(stringArray);
        Cursor cursor = list.contains(string) ? new Cursor(12) : new Cursor(0);
        this.getParent().setCursor(cursor);
    }

    private void mySingleClick(int n, TreePath treePath) {
        MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
        String string = myTreeNode.getType();
        String[] stringArray = new String[]{"FieldNode", "MethodNode", "ConstructorNode"};
        List<String> list = Arrays.asList(stringArray);
        if (list.contains(string)) {
            new PropertiesPanel(myTreeNode).setVisible(true);
        }
    }

    private void myDoubleClick(int n, TreePath treePath) {
        MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
        String string = myTreeNode.getType();
        if (string.equalsIgnoreCase("FileNode") && myTreeNode.isLeaf(myTreeNode) && Utilities.isWindows()) {
            FileNode fileNode = (FileNode)myTreeNode;
            Utilities.launchFile(fileNode, fileNode.getFile().getAbsolutePath());
        }
    }

    void addListeners(MainUI mainUI) {
        this.tree.addTreeExpansionListener(new TreeEventListener(mainUI));
        this.tree.addTreeWillExpandListener(new TreeEventListener(mainUI));
    }

    public boolean isVisible() {
        return this.visible;
    }
}

