/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.model;

import jarxplorer.parser.MyClass;
import jarxplorer.parser.MyField;
import jarxplorer.parser.MyMethod;
import java.util.LinkedHashMap;
import javax.swing.table.AbstractTableModel;

public class PropertiesTableModel
extends AbstractTableModel {
    private LinkedHashMap<String, String> table = new LinkedHashMap();
    private int tableSize;

    public PropertiesTableModel(MyField myField) {
        this.table.put("Modifiers", myField.getModifiers());
        this.table.put("Name", myField.getName());
        this.table.put("Type", myField.getSignature());
        this.table.put("Initial Value", myField.getValue());
        this.tableSize = this.table.size();
    }

    public PropertiesTableModel(MyMethod myMethod, boolean bl) {
        this.table.put("Modifiers", myMethod.getModifiers());
        this.table.put("Name", myMethod.getName());
        String string = myMethod.getSignature().replace("(", "").replace(")", "");
        this.table.put("Parameters", string);
        if (!bl) {
            this.table.put("Return Type", myMethod.getReturnType());
        }
        this.table.put("Exceptions", myMethod.getExceptions());
        this.tableSize = this.table.size();
    }

    public PropertiesTableModel(MyClass myClass) {
        this.table.put("Name", myClass.getName());
        this.table.put("All Files", myClass.getPath());
        this.table.put("File Size", myClass.getFileSize());
        this.table.put("Modification Time", myClass.getModificationTime());
        this.table.put("Class Name", myClass.getClassName());
        this.table.put("Modifiers", myClass.getAccess());
        this.table.put("Superclass", myClass.getSuperClass());
        this.tableSize = this.table.size();
    }

    public int getRowCount() {
        return this.tableSize;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = this.table.keySet().toArray();
        Object[] objectArray2 = this.table.values().toArray();
        if (n2 == 0) {
            return objectArray[n];
        }
        return objectArray2[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

