/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.parser;

import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;

public class MyMethod {
    private String name = "";
    private String modifiers = "";
    private String returnType = "";
    private String signature = "";
    private String exceptions = "";
    private boolean constructor = false;

    public MyMethod(String string, Method method) {
        this.name = method.getName();
        if (this.name.equals("<init>")) {
            this.name = string.indexOf(".") != -1 ? string.substring(string.lastIndexOf(".") + 1) : string;
            this.constructor = true;
        }
        this.modifiers = Utility.accessToString(method.getAccessFlags());
        this.returnType = method.getReturnType().toString();
        this.setSignature(method);
        this.setExceptions(method);
    }

    public String getName() {
        return this.name;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getSignature() {
        return this.signature;
    }

    private void setSignature(Method method) {
        String string = method.toString();
        this.signature = string.substring(string.indexOf(40), string.lastIndexOf(41) + 1);
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    private void setExceptions(Method method) {
        ExceptionTable exceptionTable = method.getExceptionTable();
        if (exceptionTable != null) {
            this.exceptions = exceptionTable.toString();
        }
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: " + this.getName() + "\n");
        stringBuffer.append("Modifiers: " + this.getModifiers() + "\n");
        stringBuffer.append("Signature: " + this.getSignature() + "\n");
        stringBuffer.append("Exceptions: " + this.getExceptions() + "\n");
        return stringBuffer.toString();
    }
}

