/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileConstants;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import java.io.CharConversionException;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;

final class ArchiveFileSystem
implements FileConstants {
    static final String ROOT = "/";
    private static final Comparator REVERSE_ENTRIES_COMPARATOR;
    private final ArchiveController controller;
    private final boolean readOnly;
    private Map master;
    private final ArchiveEntry root;
    private long modCount;
    private final String[] split = new String[2];
    static final /* synthetic */ boolean $assertionsDisabled;

    static String[] split(String string, String[] stringArray) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stringArray.length < 2) {
            throw new AssertionError();
        }
        int n = string.length();
        if (--n >= 0 && string.charAt(n) == '/') {
            --n;
        }
        int n2 = string.lastIndexOf(47, n);
        ++n;
        if (n2 != -1) {
            stringArray[0] = string.substring(0, ++n2);
            stringArray[1] = string.substring(n2, n);
        } else {
            stringArray[0] = n > 0 ? ROOT : null;
            stringArray[1] = string.substring(0, n);
        }
        return stringArray;
    }

    ArchiveFileSystem(ArchiveController archiveController) throws IOException {
        this.controller = archiveController;
        this.touch();
        this.master = new CompoundMap(REVERSE_ENTRIES_COMPARATOR, 64);
        this.root = this.createEntry(ROOT, null);
        this.root.setTime(System.currentTimeMillis());
        this.master.put(ROOT, this.root);
        this.readOnly = false;
        if (!$assertionsDisabled && !this.isTouched()) {
            throw new AssertionError();
        }
    }

    ArchiveFileSystem(ArchiveController archiveController, InputArchive inputArchive, long l, boolean bl) {
        this.controller = archiveController;
        int n = (int)((float)inputArchive.getNumArchiveEntries() / 0.75f);
        this.master = new CompoundMap(REVERSE_ENTRIES_COMPARATOR, n);
        try {
            ArchiveEntry archiveEntry;
            this.root = this.createEntry(ROOT, null);
            this.root.setTime(l);
            this.master.put(ROOT, this.root);
            Enumeration enumeration = inputArchive.getArchiveEntries();
            while (enumeration.hasMoreElements()) {
                archiveEntry = (ArchiveEntry)enumeration.nextElement();
                String string = archiveEntry.getName();
                if (ROOT.equals(string) || "./".equals(string)) continue;
                archiveEntry.setMetaData(new ArchiveEntryMetaData(archiveEntry));
                this.master.put(string, archiveEntry);
            }
            enumeration = inputArchive.getArchiveEntries();
            while (enumeration.hasMoreElements()) {
                archiveEntry = (ArchiveEntry)enumeration.nextElement();
                if (!ArchiveFileSystem.isLegalEntryName(archiveEntry.getName())) continue;
                this.fixParents(archiveEntry);
            }
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionError((Object)charConversionException);
        }
        this.readOnly = bl;
        if (bl) {
            this.master = Collections.unmodifiableMap(this.master);
        }
        if (!$assertionsDisabled && this.isTouched()) {
            throw new AssertionError();
        }
    }

    private static boolean isLegalEntryName(String string) {
        int n = string.length();
        if (n <= 0) {
            return false;
        }
        block0 : switch (string.charAt(0)) {
            case '/': {
                return false;
            }
            case '.': {
                if (n >= 2) {
                    switch (string.charAt(1)) {
                        case '.': {
                            if (n >= 3) {
                                if (string.charAt(2) != '/') break block0;
                                if (!$assertionsDisabled && !string.startsWith("../")) {
                                    throw new AssertionError();
                                }
                                return false;
                            }
                            if (!$assertionsDisabled && !"..".equals(string)) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                        case '/': {
                            if (!$assertionsDisabled && !string.startsWith("./")) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                    }
                    break;
                }
                if (!$assertionsDisabled && !".".equals(string)) {
                    throw new AssertionError();
                }
                return false;
            }
        }
        return true;
    }

    private void fixParents(ArchiveEntry archiveEntry) throws CharConversionException {
        String string = archiveEntry.getName();
        if (string.length() <= 0 || string.charAt(0) == '/') {
            return;
        }
        if (!$assertionsDisabled && !ArchiveFileSystem.isLegalEntryName(string)) {
            throw new AssertionError();
        }
        String[] stringArray = ArchiveFileSystem.split(string, this.split);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ArchiveEntry archiveEntry2 = (ArchiveEntry)this.master.get(string2);
        if (archiveEntry2 == null) {
            archiveEntry2 = this.createEntry(string2, null);
            this.master.put(string2, archiveEntry2);
        }
        this.fixParents(archiveEntry2);
        archiveEntry2.getMetaData().children.add(string3);
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    private void touch() throws IOException {
        if (this.isReadOnly()) {
            throw new ArchiveReadOnlyException();
        }
        if (this.modCount == 0L) {
            this.controller.onFileSystemTouch();
        }
        ++this.modCount;
    }

    boolean isTouched() {
        return this.modCount != 0L;
    }

    private void resetTouched() {
        this.modCount = 0L;
    }

    Enumeration getReversedEntries() {
        return Collections.enumeration(this.master.values());
    }

    private ArchiveEntry getRoot() {
        return this.root;
    }

    ArchiveEntry get(String string) {
        return (ArchiveEntry)this.master.get(string);
    }

    Delta beginCreateAndLink(String string, boolean bl) throws CharConversionException, ArchiveIllegalOperationException {
        return new CreateAndLinkDelta(string, bl, null);
    }

    Delta beginCreateAndLink(String string, boolean bl, ArchiveEntry archiveEntry) throws CharConversionException, ArchiveIllegalOperationException {
        return new CreateAndLinkDelta(string, bl, archiveEntry);
    }

    private ArchiveEntry createEntry(String string, ArchiveEntry archiveEntry) throws CharConversionException {
        ArchiveEntry archiveEntry2 = this.controller.getDriver().createArchiveEntry(this.controller, string, archiveEntry);
        archiveEntry2.setMetaData(new ArchiveEntryMetaData(archiveEntry2));
        return archiveEntry2;
    }

    private void unlink(String string) throws IOException {
        if (!$assertionsDisabled && string.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.charAt(0) == '/') {
            throw new AssertionError();
        }
        try {
            ArchiveEntry archiveEntry = (ArchiveEntry)this.master.remove(string);
            if (archiveEntry == null) {
                throw new ArchiveIllegalOperationException(string, "Entry does not exist!");
            }
            if (archiveEntry == this.root || archiveEntry.isDirectory() && archiveEntry.getMetaData().children.size() != 0) {
                this.master.put(string, archiveEntry);
                throw new ArchiveIllegalOperationException(string, "Directory is not empty!");
            }
            String[] stringArray = ArchiveFileSystem.split(string, this.split);
            String string2 = stringArray[0];
            ArchiveEntry archiveEntry2 = (ArchiveEntry)this.master.get(string2);
            if (!$assertionsDisabled && archiveEntry2 == null) {
                throw new AssertionError((Object)("The parent directory of \"" + string + "\" is missing - archive file system is corrupted!"));
            }
            boolean bl = archiveEntry2.getMetaData().children.remove(stringArray[1]);
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError((Object)("The parent directory of \"" + string + "\" does not contain this entry - archive file system is corrupted!"));
            }
            this.touch();
            archiveEntry2.setTime(System.currentTimeMillis());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ArchiveReadOnlyException();
        }
    }

    boolean exists(String string) {
        return this.get(string) != null || this.get(string + ROOT) != null;
    }

    boolean isFile(String string) {
        return this.get(string) != null;
    }

    boolean isDirectory(String string) {
        return this.get(string + ROOT) != null;
    }

    Icon getOpenIcon(String string) {
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + '/');
        }
        return archiveEntry != null ? archiveEntry.getOpenIcon() : null;
    }

    Icon getClosedIcon(String string) {
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + '/');
        }
        return archiveEntry != null ? archiveEntry.getClosedIcon() : null;
    }

    boolean canWrite(String string) {
        return !this.isReadOnly() && this.exists(string);
    }

    boolean setReadOnly(String string) {
        return this.isReadOnly() && this.exists(string);
    }

    long length(String string) {
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry != null) {
            long l = archiveEntry.getSize();
            return l != -1L ? l : 0L;
        }
        return 0L;
    }

    long lastModified(String string) {
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null) {
            archiveEntry = this.get(string + ROOT);
        }
        if (archiveEntry != null) {
            long l = archiveEntry.getTime();
            return l >= 0L ? l : 0L;
        }
        return 0L;
    }

    boolean setLastModified(String string, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException(string + ": Negative entry modification time!");
        }
        if (this.isReadOnly()) {
            return false;
        }
        ArchiveEntry archiveEntry = this.get(string);
        if (archiveEntry == null && (archiveEntry = this.get(string + ROOT)) == null) {
            return false;
        }
        this.touch();
        archiveEntry.setTime(l);
        return true;
    }

    String[] list(String string) {
        ArchiveEntry archiveEntry = this.get(string + ROOT);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().list();
        }
        return null;
    }

    String[] list(String string, FilenameFilter filenameFilter, File file) {
        ArchiveEntry archiveEntry = this.get(string + ROOT);
        if (archiveEntry != null) {
            if (filenameFilter != null) {
                return archiveEntry.getMetaData().list(filenameFilter, file);
            }
            return archiveEntry.getMetaData().list();
        }
        return null;
    }

    java.io.File[] listFiles(String string, FilenameFilter filenameFilter, File file, FileFactory fileFactory) {
        ArchiveEntry archiveEntry = this.get(string + ROOT);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().listFiles(filenameFilter, file, fileFactory);
        }
        return null;
    }

    java.io.File[] listFiles(String string, FileFilter fileFilter, File file, FileFactory fileFactory) {
        ArchiveEntry archiveEntry = this.get(string + ROOT);
        if (archiveEntry != null) {
            return archiveEntry.getMetaData().listFiles(fileFilter, file, fileFactory);
        }
        return null;
    }

    boolean mkdir(String string, boolean bl) throws IOException {
        try {
            this.beginCreateAndLink(string + ROOT, bl).commit();
            return true;
        }
        catch (ArchiveIllegalOperationException archiveIllegalOperationException) {
            return false;
        }
    }

    boolean delete(String string) throws IOException {
        try {
            if (this.get(string) != null) {
                this.unlink(string);
                return true;
            }
            String string2 = string + ROOT;
            if (this.get(string2) != null) {
                this.unlink(string2);
                return true;
            }
        }
        catch (ArchiveIllegalOperationException archiveIllegalOperationException) {
            // empty catch block
        }
        return false;
    }

    static {
        $assertionsDisabled = !ArchiveFileSystem.class.desiredAssertionStatus();
        REVERSE_ENTRIES_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object2).compareTo((String)object);
            }
        };
    }

    private static class CompoundMap
    extends HashMap {
        static final LinkedList events = new LinkedList();
        static final Updater mapper = new Updater();
        static boolean done;
        final TreeMap tree;

        CompoundMap(Comparator comparator, int n) {
            super(n);
            this.tree = new TreeMap(comparator);
            int n2 = Thread.currentThread().getPriority();
            if (mapper.getPriority() < n2) {
                mapper.setPriority(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                events.addLast(new Event(object));
                done = false;
                events.notifyAll();
            }
            return super.remove(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                events.addLast(new Event(object, object2));
                done = false;
                events.notifyAll();
            }
            return super.put(object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            LinkedList linkedList = events;
            synchronized (linkedList) {
                while (!done) {
                    try {
                        events.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.tree.values();
            }
        }

        static {
            mapper.start();
        }

        static class Updater
        extends Thread {
            Updater() {
                super("TrueZIP CompoundMap Updater");
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Event event;
                    LinkedList linkedList = events;
                    synchronized (linkedList) {
                        done = events.isEmpty();
                        if (done) {
                            events.notifyAll();
                            try {
                                events.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        event = (Event)events.removeFirst();
                    }
                    if (event.put) {
                        event.map().put(event.key, event.value);
                        continue;
                    }
                    event.map().remove(event.key);
                }
            }
        }

        class Event {
            final boolean put;
            final Object key;
            Object value;

            Event(Object object, Object object2) {
                this.put = true;
                this.key = object;
                this.value = object2;
            }

            Event(Object object) {
                this.put = false;
                this.key = object;
            }

            final Map map() {
                return CompoundMap.this.tree;
            }
        }
    }

    private static class ArchiveReadOnlyException
    extends ArchiveIllegalOperationException {
        private ArchiveReadOnlyException() {
            super("This archive is read-only!");
        }
    }

    private static class ArchiveIllegalOperationException
    extends IOException {
        private final String entryName;

        private ArchiveIllegalOperationException(String string) {
            super(string);
            this.entryName = null;
        }

        private ArchiveIllegalOperationException(String string, String string2) {
            super(string2);
            this.entryName = string;
        }

        public String getMessage() {
            if (this.entryName != null) {
                return this.entryName + ": " + super.getMessage();
            }
            return super.getMessage();
        }
    }

    static interface Delta {
        public void commit() throws IOException;

        public ArchiveEntry getEntry();
    }

    private static abstract class AbstractDelta
    implements Delta {
        private AbstractDelta() {
        }

        protected static class Element {
            protected final String baseName;
            protected final ArchiveEntry entry;
            static final /* synthetic */ boolean $assertionsDisabled;

            protected Element(String string, ArchiveEntry archiveEntry) {
                this.baseName = string;
                if (!$assertionsDisabled && archiveEntry == null) {
                    throw new AssertionError();
                }
                this.entry = archiveEntry;
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
            }
        }
    }

    private class CreateAndLinkDelta
    extends AbstractDelta {
        private final long time = System.currentTimeMillis();
        private final AbstractDelta.Element[] elements;
        static final /* synthetic */ boolean $assertionsDisabled;

        private CreateAndLinkDelta(String string, boolean bl, ArchiveEntry archiveEntry) throws ArchiveIllegalOperationException, CharConversionException {
            if (!$assertionsDisabled && string.length() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && string.charAt(0) == '/') {
                throw new AssertionError();
            }
            if (ArchiveFileSystem.this.isReadOnly()) {
                throw new ArchiveReadOnlyException();
            }
            this.elements = this.createElements(string, bl, archiveEntry, 1);
        }

        private AbstractDelta.Element[] createElements(String string, boolean bl, ArchiveEntry archiveEntry, int n) throws ArchiveIllegalOperationException, CharConversionException {
            ArchiveEntry archiveEntry2;
            AbstractDelta.Element[] elementArray;
            String[] stringArray = ArchiveFileSystem.split(string, ArchiveFileSystem.this.split);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            ArchiveEntry archiveEntry3 = (ArchiveEntry)ArchiveFileSystem.this.master.get(string2);
            if (archiveEntry3 != null) {
                ArchiveEntry archiveEntry4 = (ArchiveEntry)ArchiveFileSystem.this.master.get(string);
                this.ensureMayBeReplaced(string, archiveEntry4);
                elementArray = new AbstractDelta.Element[n + 1];
                elementArray[0] = new AbstractDelta.Element("", archiveEntry3);
                archiveEntry2 = ArchiveFileSystem.this.createEntry(string, n == 1 ? archiveEntry : null);
                elementArray[1] = new AbstractDelta.Element(string3, archiveEntry2);
            } else if (bl) {
                elementArray = this.createElements(string2, bl, archiveEntry, n + 1);
                archiveEntry2 = ArchiveFileSystem.this.createEntry(string, n == 1 ? archiveEntry : null);
                elementArray[elementArray.length - n] = new AbstractDelta.Element(string3, archiveEntry2);
            } else {
                throw new ArchiveIllegalOperationException(string, "Missing parent directory!");
            }
            if (archiveEntry != null && n == 1) {
                archiveEntry2.setTime(archiveEntry.getTime());
            } else {
                archiveEntry2.setTime(this.time);
            }
            return elementArray;
        }

        private void ensureMayBeReplaced(String string, ArchiveEntry archiveEntry) throws ArchiveIllegalOperationException {
            int n = string.length() - 1;
            if (string.charAt(n) == '/') {
                if (archiveEntry != null) {
                    throw new ArchiveIllegalOperationException(string, "Directories cannot be replaced!");
                }
                if (ArchiveFileSystem.this.master.get(string.substring(0, n)) != null) {
                    throw new ArchiveIllegalOperationException(string, "Directories cannot replace files!");
                }
            } else if (ArchiveFileSystem.this.master.get(string + ArchiveFileSystem.ROOT) != null) {
                throw new ArchiveIllegalOperationException(string, "Files cannot replace directories!");
            }
        }

        public void commit() throws IOException {
            ArchiveFileSystem.this.touch();
            ArchiveEntry archiveEntry = this.elements[0].entry;
            int n = this.elements.length;
            for (int i = 1; i < n; ++i) {
                AbstractDelta.Element element = this.elements[i];
                String string = element.baseName;
                ArchiveEntry archiveEntry2 = element.entry;
                if (archiveEntry.getMetaData().children.add(string) && archiveEntry.getTime() >= 0L) {
                    archiveEntry.setTime(System.currentTimeMillis());
                }
                ArchiveFileSystem.this.master.put(archiveEntry2.getName(), archiveEntry2);
                archiveEntry = archiveEntry2;
            }
        }

        public ArchiveEntry getEntry() {
            return this.elements[this.elements.length - 1].entry;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
        }
    }
}

