/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ChannelReadOnlyFile
implements ReadOnlyFile {
    protected final FileChannel channel;
    private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);

    public ChannelReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new RandomAccessFile(file, "r").getChannel();
    }

    public long length() throws IOException {
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        return this.channel.position();
    }

    public void seek(long l) throws IOException {
        this.channel.position(l);
    }

    public int read() throws IOException {
        if (this.channel.read(this.singleByteBuffer) == 1) {
            return this.singleByteBuffer.array()[0] & 0xFF;
        }
        return -1;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.channel.read(ByteBuffer.wrap(byArray, n, n2));
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.channel.position();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.channel.size())) {
            l3 = l;
        }
        this.channel.position(l3);
        return (int)(l3 - l2);
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

