/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FastReadOnlyFile
extends RandomAccessFile
implements ReadOnlyFile {
    private long fp;
    private boolean closed;

    public FastReadOnlyFile(File file) throws FileNotFoundException {
        super(file, "r");
    }

    public void seek(long l) throws IOException {
        if (l == this.fp) {
            if (this.closed) {
                throw new IOException("File has been closed!");
            }
            return;
        }
        super.seek(l);
        this.fp = l;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.fp;
        }
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.fp += (long)n3;
        }
        return n3;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = super.skipBytes(n);
        this.fp += (long)n2;
        return n2;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

