/*
 * Decompiled with CFR 0.152.
 */
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.archive.tar.TarBZip2Driver;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarGZipDriver;
import de.schlichtherle.io.archive.zip.CheckedReadOnlySfxDriver;
import de.schlichtherle.io.archive.zip.CheckedZip32Driver;
import de.schlichtherle.io.swing.tree.FileTreeModel;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;

public class nzip {
    private static final NumberFormat numberFormat;
    private static final DateFormat dateFormat;
    private static final FieldPosition fpos;
    private static final Thread progressMonitor;
    private static final ArchiveStatistics liveStats;
    private static boolean showProgress;
    private static final Long[] args;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void usage() {
        System.err.println("Usage: nzip COMMAND ...\n\nwhere COMMAND is one of (case is ignored):\n\n\tls [PATH] ...\t\t\t\tSimilar to GNU \"ls\"\n\tll [PATH] ...\t\t\t\tSimilar to GNU \"ls -l\"\n\tllR [PATH] ...\t\t\t\tSimilar to GNU \"ls -lR\"\n\tcat FILE ...\t\t\t\tLike GNU \"cat\"\n\tcp [-unzip|-cp437in|-utf8in|-cp437out|-utf8out] SRC ... DST\tSimilar to GNU \"cp -a\"\n\tmv SRC ... DST\t\t\t\tLike GNU \"mv\"\n\ttouch PATH ...\t\t\t\tLike GNU \"touch\"\n\tmkdir PATH ...\t\t\t\tLike GNU \"mkdir\"\n\tmkdirs PATH ...\t\t\t\tSimilar to GNU \"mkdir -p\"\n\trm PATH ...\t\t\t\tLike GNU \"rm\"\n\trmR PATH ...\t\t\t\tLike GNU \"rm -r\"\n\tisFile PATH\t\t\t\tTests if PATH is a file\n\tisDirectory PATH\t\t\tTests if PATH is a directory\n\texists PATH\t\t\t\tTests if PATH exists\n\nFor more information please refer to the respective man pages (on Linux).\n\nOptions (case is ignored):\n\n\t-unzip\t\tTreat any ZIP like pathnames in DST as plain\n\t\t\tdirectories.\n\t-cp437(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in CP437.\n\t-utf8(in|out)\tForce any ZIP entry names in SRC/DST to be encoded in UTF-8.\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            nzip.usage();
        }
        de.schlichtherle.io.File.setDefaultArchiveDetector(new DefaultArchiveDetector(ArchiveDetector.ALL, "zip", new CheckedZip32Driver()));
        System.setProperty("de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback", System.getProperty("de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback", "de.schlichtherle.key.passwd.swing.QuakingWindowFeedback"));
        String string = stringArray[0].toLowerCase();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if ("ls".equals(string) || (bl2 = "ll".equals(string)) || (bl3 = "llr".equals(string))) {
                bl2 |= bl3;
                for (int i = 1; i < stringArray.length || i == 1; ++i) {
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(i < stringArray.length ? stringArray[i] : ".");
                    if (stringArray.length > 2) {
                        System.out.println(stringArray[i] + ":");
                    }
                    if (file.isDirectory()) {
                        bl &= nzip.list(file, "", bl2, bl3);
                        continue;
                    }
                    bl &= nzip.list(file, file.getPath(), bl2, bl3);
                }
            } else if ("cat".equals(string)) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                    boolean bl4 = file.catTo(System.out);
                    if (bl4) continue;
                    System.err.println(file.getPath() + ": Cannot read file!");
                    bl = false;
                }
            } else if ("cp".equals(string) || (bl2 = "mv".equals(string))) {
                int n;
                if (stringArray.length < 3) {
                    nzip.usage();
                }
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                int n2 = 0;
                int n3 = 0;
                for (n = 1; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
                    if (bl2) {
                        nzip.usage();
                    }
                    if ("-unzip".equals(stringArray[n].toLowerCase())) {
                        bl5 = true;
                        ++n3;
                        continue;
                    }
                    if ("-cp437out".equals(stringArray[n].toLowerCase())) {
                        bl6 = true;
                        ++n3;
                        continue;
                    }
                    if ("-utf8out".equals(stringArray[n].toLowerCase())) {
                        bl7 = true;
                        ++n3;
                        continue;
                    }
                    if ("-cp437in".equals(stringArray[n].toLowerCase())) {
                        bl8 = true;
                        ++n2;
                        continue;
                    }
                    if ("-utf8in".equals(stringArray[n].toLowerCase())) {
                        bl9 = true;
                        ++n2;
                        continue;
                    }
                    nzip.usage();
                }
                if (n2 > 1 || n3 > 1) {
                    nzip.usage();
                }
                boolean bl10 = bl5;
                boolean bl11 = bl6;
                boolean bl12 = bl7;
                boolean bl13 = bl8;
                boolean bl14 = bl9;
                ArchiveDetector archiveDetector = bl13 ? nzip.createArchiveDetector("CP437") : (bl14 ? nzip.createArchiveDetector("UTF-8") : de.schlichtherle.io.File.getDefaultArchiveDetector());
                ArchiveDetector archiveDetector2 = bl10 ? ArchiveDetector.NULL : (bl11 ? nzip.createArchiveDetector("CP437") : (bl12 ? nzip.createArchiveDetector("UTF-8") : de.schlichtherle.io.File.getDefaultArchiveDetector()));
                int n4 = stringArray.length - 1;
                de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[n4], archiveDetector2);
                if (n4 - n < 1 || n4 - n > 1 && !file.isArchive() && !file.isDirectory()) {
                    nzip.usage();
                }
                if (file.isArchive() || file.isEntry()) {
                    nzip.startProgressMonitor();
                }
                for (int i = n; i < n4; ++i) {
                    boolean bl15;
                    de.schlichtherle.io.File file2 = new de.schlichtherle.io.File(stringArray[i], archiveDetector);
                    de.schlichtherle.io.File file3 = n4 - n > 1 || file.isDirectory() ? new de.schlichtherle.io.File((File)file, file2.getName(), archiveDetector2) : file;
                    if (bl2) {
                        boolean bl16 = bl15 = !file2.contains(file3) && (!file3.isFile() || file3.delete()) && file2.renameTo(file3);
                        if (!bl15) {
                            System.err.println(file2 + ": Cannot move to " + file3 + "!");
                        }
                    } else {
                        bl15 = file2.archiveCopyAllTo(file3, archiveDetector, archiveDetector2);
                        if (!bl15) {
                            System.err.println(file2 + ": Copying to " + file3 + " has failed. Check output!");
                        }
                    }
                    bl &= bl15;
                }
            } else if ("touch".equals(string)) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                    boolean bl17 = !file.exists() ? file.createNewFile() : file.setLastModified(System.currentTimeMillis());
                    if (bl17) continue;
                    String string2 = !file.exists() ? "Cannot create file!" : (file.isDirectory() ? "Cannot update directory last modification time!" : (file.isFile() ? "Cannot update file last modification time!" : "Cannot update special file or directory last modification time!"));
                    System.err.println(file.getPath() + ": " + string2);
                    bl = false;
                }
            } else if ("mkdir".equals(string) || (bl2 = "mkdirs".equals(string))) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    boolean bl18;
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                    boolean bl19 = bl18 = bl2 ? file.mkdirs() : file.mkdir();
                    if (bl18) continue;
                    String string3 = !file.exists() ? "Cannot create directory!" : (file.isDirectory() ? "Directory exists already!" : (file.isFile() ? "File exists already!" : "Special file or directory exists already!"));
                    System.err.println(file.getPath() + ": " + string3);
                    bl = false;
                }
            } else if ("rm".equals(string) || (bl2 = "rmr".equals(string))) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    boolean bl20;
                    de.schlichtherle.io.File file = new de.schlichtherle.io.File(stringArray[i]);
                    boolean bl21 = bl20 = bl2 ? file.deleteAll() : file.delete();
                    if (bl20) continue;
                    String string4 = !file.exists() ? "No such file or directory!" : (file.isDirectory() ? (file.list().length > 0 ? "Directory not empty!" : "Cannot remove directory!") : (file.isFile() ? "Cannot remove file!" : "Cannot remove special file or directory!"));
                    System.err.println(file.getPath() + ": " + string4);
                    bl = false;
                }
            } else if ("isfile".equals(string)) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                bl = new de.schlichtherle.io.File(stringArray[1]).isFile();
                System.out.println(bl);
            } else if ("isdirectory".equals(string)) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                bl = new de.schlichtherle.io.File(stringArray[1]).isDirectory();
                System.out.println(bl);
            } else if ("exists".equals(string)) {
                if (stringArray.length < 2) {
                    nzip.usage();
                }
                bl = new de.schlichtherle.io.File(stringArray[1]).exists();
                System.out.println(bl);
            } else {
                nzip.usage();
                bl = false;
            }
        }
        finally {
            de.schlichtherle.io.File.update();
            nzip.showProgress();
        }
        if (!bl) {
            System.exit(1);
        }
    }

    private static ArchiveDetector createArchiveDetector(String string) throws UnsupportedEncodingException, IllegalAccessException, InstantiationException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        return new DefaultArchiveDetector(ArchiveDetector.ALL, new Object[]{"zip", new CheckedZip32Driver(string), "exe", new CheckedReadOnlySfxDriver(string), "tar", new TarDriver(string), "tgz|tar.gz", new TarGZipDriver(string), "tbz|tar.bz2", new TarBZip2Driver(string)});
    }

    public static boolean list(File file, String string, boolean bl, boolean bl2) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                System.err.println(file.getPath() + ": Directory is inaccessible!");
                return false;
            }
            Arrays.sort(fileArray, FileTreeModel.FILE_NAME_COMPARATOR);
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string2 = string.length() > 0 ? string + de.schlichtherle.io.File.separator + file2.getName() : file2.getName();
                nzip.list(file2, string2, bl);
                if (!bl2 || !file2.isDirectory()) continue;
                nzip.list(fileArray[i], string2, bl, true);
            }
            return true;
        }
        if (file.exists()) {
            nzip.list(file, string, bl);
            return true;
        }
        System.err.println(file.getPath() + ": No such file or directory!");
        return false;
    }

    private static void list(File file, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            nzip.align(stringBuffer, file.length(), 11);
            stringBuffer.append(' ');
            stringBuffer.append(dateFormat.format(new Date(file.lastModified())));
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(file.isDirectory() ? de.schlichtherle.io.File.separator : (file.isFile() ? "" : "?"));
        }
        System.out.println(stringBuffer.toString());
    }

    private static void align(StringBuffer stringBuffer, long l, int n) {
        int n2 = stringBuffer.length();
        numberFormat.format(l, stringBuffer, fpos);
        int n3 = n - fpos.getEndIndex();
        while (--n3 >= 0) {
            stringBuffer.insert(n2, ' ');
        }
    }

    public static void startProgressMonitor() {
        showProgress = true;
        if (!progressMonitor.isAlive()) {
            progressMonitor.start();
        }
    }

    public static void showProgress() {
        if (!showProgress) {
            return;
        }
        nzip.args[0] = new Long((liveStats.getUpdateTotalByteCountRead() + 1023L) / 1024L);
        nzip.args[1] = new Long((liveStats.getUpdateTotalByteCountWritten() + 1023L) / 1024L);
        System.out.print(MessageFormat.format("Top level ZIP update: In {0} / Out {1} KB \r", args));
    }

    static {
        $assertionsDisabled = !nzip.class.desiredAssertionStatus();
        numberFormat = NumberFormat.getNumberInstance();
        dateFormat = DateFormat.getDateTimeInstance();
        fpos = new FieldPosition(0);
        progressMonitor = new Thread(){
            {
                this.setPriority(10);
                this.setDaemon(true);
            }

            public void run() {
                long l = 333L;
                while (true) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    nzip.showProgress();
                    l = 333L;
                }
            }
        };
        liveStats = de.schlichtherle.io.File.getLiveArchiveStatistics();
        args = new Long[2];
    }
}

