/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.GlobalOptions;
import jode.expr.CombineableOperator;
import jode.expr.Expression;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.SequentialBlock;
import jode.flow.StructuredBlock;

public class CreateExpression {
    public static boolean transform(InstructionContainer instructionContainer, StructuredBlock structuredBlock) {
        Expression expression;
        int n = instructionContainer.getInstruction().getFreeOperandCount();
        if (n == 0) {
            return false;
        }
        if (!(structuredBlock.outer instanceof SequentialBlock)) {
            return false;
        }
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
        Expression expression2 = instructionContainer.getInstruction();
        while (true) {
            if (!(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
                return false;
            }
            expression = ((InstructionBlock)sequentialBlock.subBlocks[0]).getInstruction();
            if (!expression.isVoid()) break;
            if (expression.getFreeOperandCount() > 0 || !(expression instanceof CombineableOperator) || expression2.canCombine((CombineableOperator)((Object)expression)) <= 0) {
                return false;
            }
            SequentialBlock sequentialBlock2 = sequentialBlock;
            while (sequentialBlock2 != structuredBlock.outer) {
                sequentialBlock2 = (SequentialBlock)sequentialBlock2.subBlocks[1];
                if (!((InstructionBlock)sequentialBlock2.subBlocks[0]).getInstruction().hasSideEffects(expression)) continue;
                return false;
            }
            if (!(sequentialBlock.outer instanceof SequentialBlock)) {
                return false;
            }
            sequentialBlock = (SequentialBlock)sequentialBlock.outer;
        }
        sequentialBlock = (SequentialBlock)structuredBlock.outer;
        expression2 = instructionContainer.getInstruction();
        while (true) {
            if (!(expression = ((InstructionBlock)sequentialBlock.subBlocks[0]).getInstruction()).isVoid()) break;
            expression2 = expression2.combine((CombineableOperator)((Object)expression));
            sequentialBlock = (SequentialBlock)sequentialBlock.outer;
        }
        expression2 = expression2.addOperand(expression);
        if (GlobalOptions.verboseLevel > 0 && expression2.getFreeOperandCount() == 0) {
            GlobalOptions.err.print('x');
        }
        instructionContainer.setInstruction(expression2);
        instructionContainer.moveDefinitions(sequentialBlock, structuredBlock);
        structuredBlock.replace(sequentialBlock);
        return true;
    }
}

