/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import jode.obfuscator.OptionHandler;
import jode.obfuscator.ParseException;

public class ScriptParser {
    static int NO_TOKEN = -2;
    static int EOF_TOKEN = -1;
    static int STRING_TOKEN = 0;
    static int NEW_TOKEN = 1;
    static int EQUALS_TOKEN = 2;
    static int COMMA_TOKEN = 3;
    static int OPENBRACE_TOKEN = 4;
    static int CLOSEBRACE_TOKEN = 5;
    static int IDENTIFIER_TOKEN = 6;
    static int NUMBER_TOKEN = 7;
    Scanner scanner;

    public Object parseClass() throws ParseException, IOException {
        Object obj;
        int n = this.scanner.getLineNr();
        int n2 = this.scanner.getToken();
        if (n2 != IDENTIFIER_TOKEN) {
            throw new ParseException(n, "Class name expected");
        }
        try {
            Class<?> clazz = Class.forName("jode.obfuscator.modules." + this.scanner.getValue());
            obj = clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException(this.scanner.getLineNr(), "Class `" + this.scanner.getValue() + "' not found");
        }
        catch (Exception exception) {
            throw new ParseException(this.scanner.getLineNr(), "Class `" + this.scanner.getValue() + "' not valid: " + exception.getMessage());
        }
        n2 = this.scanner.getToken();
        if (n2 == OPENBRACE_TOKEN) {
            if (!(obj instanceof OptionHandler)) {
                throw new ParseException(this.scanner.getLineNr(), "Class `" + obj.getClass().getName() + "' doesn't handle options.");
            }
            this.parseOptions((OptionHandler)obj);
            if (this.scanner.getToken() != CLOSEBRACE_TOKEN) {
                throw new ParseException(this.scanner.getLineNr(), "`}' expected");
            }
        } else {
            this.scanner.pushbackToken(n2);
        }
        return obj;
    }

    public void parseOptions(OptionHandler optionHandler) throws ParseException, IOException {
        int n = this.scanner.getToken();
        while (true) {
            if (n == EOF_TOKEN || n == CLOSEBRACE_TOKEN) {
                this.scanner.pushbackToken(n);
                return;
            }
            if (n != IDENTIFIER_TOKEN) {
                throw new ParseException(this.scanner.getLineNr(), "identifier expected");
            }
            String string = this.scanner.getValue();
            if (this.scanner.getToken() != EQUALS_TOKEN) {
                throw new ParseException(this.scanner.getLineNr(), "equal sign expected");
            }
            int n2 = this.scanner.getLineNr();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            do {
                if ((n = this.scanner.getToken()) == NEW_TOKEN) {
                    linkedList.add(this.parseClass());
                    continue;
                }
                if (n == STRING_TOKEN) {
                    linkedList.add(this.scanner.getValue());
                    continue;
                }
                if (n != NUMBER_TOKEN) continue;
                linkedList.add(new Integer(this.scanner.getValue()));
            } while ((n = this.scanner.getToken()) == COMMA_TOKEN);
            try {
                optionHandler.setOption(string, linkedList);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(n2, optionHandler.getClass().getName() + ": " + illegalArgumentException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(n2, optionHandler.getClass().getName() + ": Illegal value: " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
            }
        }
    }

    public ScriptParser(Reader reader) {
        ScriptParser scriptParser = this;
        if (scriptParser == null) {
            throw null;
        }
        this.scanner = scriptParser.new Scanner(reader);
    }

    class Scanner {
        BufferedReader input;
        String value;
        String line;
        int column;
        int linenr;
        int pushback = NO_TOKEN;

        public void readString() throws ParseException {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.column < this.line.length()) {
                char c;
                if ((c = this.line.charAt(this.column++)) == '\"') {
                    this.value = stringBuffer.toString();
                    return;
                }
                if (c == '\\') {
                    c = this.line.charAt(this.column++);
                    switch (c) {
                        case 'n': {
                            stringBuffer.append('\n');
                            break;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break;
                        }
                        case 'u': {
                            if (this.column + 4 <= this.line.length()) {
                                try {
                                    char c2 = (char)Integer.parseInt(this.line.substring(this.column, this.column + 4), 16);
                                    this.column += 4;
                                    stringBuffer.append(c2);
                                    break;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ParseException(this.linenr, "Invalid unicode escape character");
                                }
                            }
                            throw new ParseException(this.linenr, "Invalid unicode escape character");
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                    continue;
                }
                stringBuffer.append(c);
            }
            throw new ParseException(this.linenr, "String spans over multiple lines");
        }

        public void readIdentifier() {
            int n = this.column - 1;
            while (this.column < this.line.length() && Character.isUnicodeIdentifierPart(this.line.charAt(this.column))) {
                ++this.column;
            }
            this.value = this.line.substring(n, this.column);
        }

        public void readNumber() {
            boolean bl = false;
            int n = this.column - 1;
            if (this.line.charAt(n) == '0' && this.line.charAt(this.column) == 'x') {
                ++this.column;
                bl = true;
            }
            while (this.column < this.line.length()) {
                char c = this.line.charAt(this.column);
                if (!(Character.isDigit(c) || bl && (c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f'))) break;
                ++this.column;
            }
            this.value = this.line.substring(n, this.column);
        }

        public void pushbackToken(int n) {
            if (this.pushback != NO_TOKEN) {
                throw new IllegalStateException("Can only handle one pushback");
            }
            this.pushback = n;
        }

        public int getToken() throws ParseException, IOException {
            if (this.pushback != NO_TOKEN) {
                int n = this.pushback;
                this.pushback = NO_TOKEN;
                return n;
            }
            this.value = null;
            while (true) {
                if (this.line == null) {
                    this.line = this.input.readLine();
                    if (this.line == null) {
                        return EOF_TOKEN;
                    }
                    ++this.linenr;
                    this.column = 0;
                }
                while (this.column < this.line.length()) {
                    char c;
                    if (Character.isWhitespace(c = this.line.charAt(this.column++))) continue;
                    if (c == '#') break;
                    if (c == '=') {
                        return EQUALS_TOKEN;
                    }
                    if (c == ',') {
                        return COMMA_TOKEN;
                    }
                    if (c == '{') {
                        return OPENBRACE_TOKEN;
                    }
                    if (c == '}') {
                        return CLOSEBRACE_TOKEN;
                    }
                    if (c == '\"') {
                        this.readString();
                        return STRING_TOKEN;
                    }
                    if (Character.isDigit(c) || c == '+' || c == '-') {
                        this.readNumber();
                        return NUMBER_TOKEN;
                    }
                    if (Character.isUnicodeIdentifierStart(c)) {
                        this.readIdentifier();
                        if (this.value.equals("new")) {
                            return NEW_TOKEN;
                        }
                        return IDENTIFIER_TOKEN;
                    }
                    throw new ParseException(this.linenr, "Illegal character `" + c + "'");
                }
                this.line = null;
            }
        }

        public String getValue() {
            return this.value;
        }

        public int getLineNr() {
            return this.linenr;
        }

        public Scanner(Reader reader) {
            this.input = new BufferedReader(reader);
        }
    }
}

