/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator.modules;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.MethodInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.jvm.InterpreterException;
import jode.obfuscator.CodeAnalyzer;
import jode.obfuscator.ConstantRuntimeEnvironment;
import jode.obfuscator.FieldIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.Main;
import jode.obfuscator.MethodIdentifier;
import jode.obfuscator.modules.SimpleAnalyzer;

public class ConstantAnalyzer
extends SimpleAnalyzer
implements Opcodes,
CodeAnalyzer {
    private static ConstantRuntimeEnvironment runtime = new ConstantRuntimeEnvironment();
    private static final int CMP_EQ = 0;
    private static final int CMP_NE = 1;
    private static final int CMP_LT = 2;
    private static final int CMP_GE = 3;
    private static final int CMP_GT = 4;
    private static final int CMP_LE = 5;
    private static final int CMP_GREATER_MASK = 26;
    private static final int CMP_LESS_MASK = 38;
    private static final int CMP_EQUAL_MASK = 41;
    static final int CONSTANT = 2;
    static final int CONSTANTFLOW = 4;
    static final int RETASTORE = 8;
    static final int RETURNINGJSR = 16;
    private static ConstValue[] unknownValue = new ConstValue[]{new ConstValue(1), new ConstValue(2)};
    private static ConstantInfo unknownConstInfo = new ConstantInfo();
    BytecodeInfo bytecode;

    public void mergeInfo(Instruction instruction, StackLocalInfo stackLocalInfo) {
        if (instruction.getTmpInfo() == null) {
            instruction.setTmpInfo(stackLocalInfo);
            stackLocalInfo.instr = instruction;
            stackLocalInfo.enqueue();
        } else {
            ((StackLocalInfo)instruction.getTmpInfo()).merge(stackLocalInfo);
        }
    }

    public void handleReference(Reference reference, boolean bl) {
        Main.getClassBundle().reachableReference(reference, bl);
    }

    public void handleClass(String string) {
        int n = 0;
        while (n < string.length() && string.charAt(n) == '[') {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == 'L') {
            string = string.substring(n + 1, string.length() - 1);
            Main.getClassBundle().reachableClass(string);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void handleOpcode(StackLocalInfo var1_1, Identifier var2_2) {
        var3_3 = var1_1.instr;
        var1_1.constInfo = ConstantAnalyzer.unknownConstInfo;
        var4_4 = var3_3.getOpcode();
        var5_5 = this.bytecode.getExceptionHandlers();
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            if (var5_5[var6_6].start.getAddr() <= var3_3.getAddr() && var5_5[var6_6].end.getAddr() >= var3_3.getAddr()) {
                this.mergeInfo(var5_5[var6_6].catcher, var1_1.poppush(var1_1.stack.length, ConstantAnalyzer.unknownValue[0]));
            }
            ++var6_6;
        }
        switch (var4_4) {
            case 0: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(0));
                break;
            }
            case 18: 
            case 20: {
                var6_7 = new ConstValue(var3_3.getConstant());
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(0, var6_7));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                var6_8 = var1_1.getLocal(var3_3.getLocalSlot());
                if (var6_8 == null) {
                    this.dumpStackLocalInfo();
                    System.err.println(var1_1);
                    System.err.println(var3_3);
                }
                if (var6_8.value != ConstValue.VOLATILE) {
                    var1_1.constInfo = new ConstantInfo(2, var6_8.value);
                    var6_8.addConstantListener(var1_1.constInfo);
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(0, var6_8).setLocal(var3_3.getLocalSlot(), var6_8.copy()));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                var6_9 = ConstantAnalyzer.unknownValue[var4_4 == 47 || var4_4 == 49 ? 1 : 0];
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(2, var6_9));
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                var6_10 = var1_1.getStack(1);
                if (var6_10.value instanceof JSRTargetInfo) {
                    var1_1.constInfo.flags |= 8;
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(1).setLocal(var3_3.getLocalSlot(), var6_10));
                break;
            }
            case 55: 
            case 57: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(2).setLocal(var3_3.getLocalSlot(), var1_1.getStack(2)));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                var7_24 = var4_4 == 80 || var4_4 == 82 ? 2 : 1;
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(2 + var7_24));
                break;
            }
            case 87: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(1));
                break;
            }
            case 88: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(2));
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.dup((var4_4 - 86) / 3, (var4_4 - 86) % 3));
                break;
            }
            case 95: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.swap());
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                var7_25 = 1 + (var4_4 - 96 & 1);
                var8_37 = var1_1.getStack(2 * var7_25);
                var9_52 = var1_1.getStack(1 * var7_25);
                v0 = var10_66 = var8_37.value != ConstValue.VOLATILE && var9_52.value != ConstValue.VOLATILE;
                if (var10_66 && ((var4_4 == 108 || var4_4 == 112) && (Integer)var9_52.value == 0 || (var4_4 == 109 || var4_4 == 113) && (Long)var9_52.value == 0L)) {
                    var10_66 = false;
                }
                if (var10_66) {
                    switch (var4_4) {
                        case 96: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value + (Integer)var9_52.value);
                            break;
                        }
                        case 100: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value - (Integer)var9_52.value);
                            break;
                        }
                        case 104: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value * (Integer)var9_52.value);
                            break;
                        }
                        case 108: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value / (Integer)var9_52.value);
                            break;
                        }
                        case 112: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value % (Integer)var9_52.value);
                            break;
                        }
                        case 126: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value & (Integer)var9_52.value);
                            break;
                        }
                        case 128: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value | (Integer)var9_52.value);
                            break;
                        }
                        case 130: {
                            var11_75 /* !! */  = new Integer((Integer)var8_37.value ^ (Integer)var9_52.value);
                            break;
                        }
                        case 97: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value + (Long)var9_52.value);
                            break;
                        }
                        case 101: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value - (Long)var9_52.value);
                            break;
                        }
                        case 105: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value * (Long)var9_52.value);
                            break;
                        }
                        case 109: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value / (Long)var9_52.value);
                            break;
                        }
                        case 113: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value % (Long)var9_52.value);
                            break;
                        }
                        case 127: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value & (Long)var9_52.value);
                            break;
                        }
                        case 129: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value | (Long)var9_52.value);
                            break;
                        }
                        case 131: {
                            var11_75 /* !! */  = new Long((Long)var8_37.value ^ (Long)var9_52.value);
                            break;
                        }
                        case 98: {
                            var11_75 /* !! */  = new Float(((Float)var8_37.value).floatValue() + ((Float)var9_52.value).floatValue());
                            break;
                        }
                        case 102: {
                            var11_75 /* !! */  = new Float(((Float)var8_37.value).floatValue() - ((Float)var9_52.value).floatValue());
                            break;
                        }
                        case 106: {
                            var11_75 /* !! */  = new Float(((Float)var8_37.value).floatValue() * ((Float)var9_52.value).floatValue());
                            break;
                        }
                        case 110: {
                            var11_75 /* !! */  = new Float(((Float)var8_37.value).floatValue() / ((Float)var9_52.value).floatValue());
                            break;
                        }
                        case 114: {
                            var11_75 /* !! */  = new Float(((Float)var8_37.value).floatValue() % ((Float)var9_52.value).floatValue());
                            break;
                        }
                        case 99: {
                            var11_75 /* !! */  = new Double((Double)var8_37.value + (Double)var9_52.value);
                            break;
                        }
                        case 103: {
                            var11_75 /* !! */  = new Double((Double)var8_37.value - (Double)var9_52.value);
                            break;
                        }
                        case 107: {
                            var11_75 /* !! */  = new Double((Double)var8_37.value * (Double)var9_52.value);
                            break;
                        }
                        case 111: {
                            var11_75 /* !! */  = new Double((Double)var8_37.value / (Double)var9_52.value);
                            break;
                        }
                        case 115: {
                            var11_75 /* !! */  = new Double((Double)var8_37.value % (Double)var9_52.value);
                            break;
                        }
                        default: {
                            throw new AssertError("Can't happen.");
                        }
                    }
                    var1_1.constInfo = new ConstantInfo(2, var11_75 /* !! */ );
                    var6_11 = new ConstValue(var11_75 /* !! */ );
                    var6_11.addConstantListener(var1_1.constInfo);
                    var8_37.addConstantListener(var6_11);
                    var9_52.addConstantListener(var6_11);
                } else {
                    var6_11 = ConstantAnalyzer.unknownValue[var7_25 - 1];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(2 * var7_25, var6_11));
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                var7_26 = 1 + (var4_4 - 116 & 1);
                var8_38 = var1_1.getStack(var7_26);
                if (var8_38.value != ConstValue.VOLATILE) {
                    switch (var4_4) {
                        case 116: {
                            var9_53 /* !! */  = new Integer(-((Integer)var8_38.value).intValue());
                            break;
                        }
                        case 117: {
                            var9_53 /* !! */  = new Long(-((Long)var8_38.value).longValue());
                            break;
                        }
                        case 118: {
                            var9_53 /* !! */  = new Float(-((Float)var8_38.value).floatValue());
                            break;
                        }
                        case 119: {
                            var9_53 /* !! */  = new Double(-((Double)var8_38.value).doubleValue());
                            break;
                        }
                        default: {
                            throw new AssertError("Can't happen.");
                        }
                    }
                    var1_1.constInfo = new ConstantInfo(2, var9_53 /* !! */ );
                    var6_12 = new ConstValue(var9_53 /* !! */ );
                    var6_12.addConstantListener(var1_1.constInfo);
                    var8_38.addConstantListener(var6_12);
                } else {
                    var6_12 = ConstantAnalyzer.unknownValue[var7_26 - 1];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var7_26, var6_12));
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                var7_27 = 1 + (var4_4 - 96 & 1);
                var8_39 = var1_1.getStack(var7_27 + 1);
                var9_54 = var1_1.getStack(1);
                if (var8_39.value != ConstValue.VOLATILE && var9_54.value != ConstValue.VOLATILE) {
                    switch (var4_4) {
                        case 120: {
                            var10_67 /* !! */  = new Integer((Integer)var8_39.value << (Integer)var9_54.value);
                            break;
                        }
                        case 122: {
                            var10_67 /* !! */  = new Integer((Integer)var8_39.value >> (Integer)var9_54.value);
                            break;
                        }
                        case 124: {
                            var10_67 /* !! */  = new Integer((Integer)var8_39.value >>> (Integer)var9_54.value);
                            break;
                        }
                        case 121: {
                            var10_67 /* !! */  = new Long((Long)var8_39.value << (Integer)var9_54.value);
                            break;
                        }
                        case 123: {
                            var10_67 /* !! */  = new Long((Long)var8_39.value >> (Integer)var9_54.value);
                            break;
                        }
                        case 125: {
                            var10_67 /* !! */  = new Long((Long)var8_39.value >>> (Integer)var9_54.value);
                            break;
                        }
                        default: {
                            throw new AssertError("Can't happen.");
                        }
                    }
                    var1_1.constInfo = new ConstantInfo(2, var10_67 /* !! */ );
                    var6_13 = new ConstValue(var10_67 /* !! */ );
                    var6_13.addConstantListener(var1_1.constInfo);
                    var8_39.addConstantListener(var6_13);
                    var9_54.addConstantListener(var6_13);
                } else {
                    var6_13 = ConstantAnalyzer.unknownValue[var7_27 - 1];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var7_27 + 1, var6_13));
                break;
            }
            case 132: {
                var7_28 = var1_1.getLocal(var3_3.getLocalSlot());
                if (var7_28.value != ConstValue.VOLATILE) {
                    var6_14 = new ConstValue(new Integer((Integer)var7_28.value + var3_3.getIncrement()));
                    var7_28.addConstantListener(var6_14);
                } else {
                    var6_14 = ConstantAnalyzer.unknownValue[0];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.copy().setLocal(var3_3.getLocalSlot(), var6_14));
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                var7_29 = 1 + ((var4_4 - 133) / 3 & 1);
                var8_40 = var1_1.getStack(var7_29);
                if (var8_40.value != ConstValue.VOLATILE) {
                    switch (var4_4) {
                        case 136: 
                        case 139: 
                        case 142: {
                            var9_55 /* !! */  = new Integer(((Number)var8_40.value).intValue());
                            break;
                        }
                        case 133: 
                        case 140: 
                        case 143: {
                            var9_55 /* !! */  = new Long(((Number)var8_40.value).longValue());
                            break;
                        }
                        case 134: 
                        case 137: 
                        case 144: {
                            var9_55 /* !! */  = new Float(((Number)var8_40.value).floatValue());
                            break;
                        }
                        case 135: 
                        case 138: 
                        case 141: {
                            var9_55 /* !! */  = new Double(((Number)var8_40.value).doubleValue());
                            break;
                        }
                        default: {
                            throw new AssertError("Can't happen.");
                        }
                    }
                    var1_1.constInfo = new ConstantInfo(2, var9_55 /* !! */ );
                    var6_15 = new ConstValue(var9_55 /* !! */ );
                    var6_15.addConstantListener(var1_1.constInfo);
                    var8_40.addConstantListener(var6_15);
                } else {
                    switch (var4_4) {
                        case 133: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 143: {
                            var6_15 = ConstantAnalyzer.unknownValue[1];
                            break;
                        }
                        default: {
                            var6_15 = ConstantAnalyzer.unknownValue[0];
                        }
                    }
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var7_29, var6_15));
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                var7_30 = var1_1.getStack(1);
                if (var7_30.value != ConstValue.VOLATILE) {
                    var8_41 = (Integer)var7_30.value;
                    switch (var4_4) {
                        case 145: {
                            var8_41 = (byte)var8_41;
                            break;
                        }
                        case 146: {
                            var8_41 = (char)var8_41;
                            break;
                        }
                        case 147: {
                            var8_41 = (short)var8_41;
                            break;
                        }
                    }
                    var9_56 = new Integer(var8_41);
                    var1_1.constInfo = new ConstantInfo(2, var9_56);
                    var6_16 = new ConstValue(var9_56);
                    var7_30.addConstantListener(var1_1.constInfo);
                    var7_30.addConstantListener(var6_16);
                } else {
                    var6_16 = ConstantAnalyzer.unknownValue[0];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(1, var6_16));
                break;
            }
            case 148: {
                var7_31 = var1_1.getStack(4);
                var8_42 = var1_1.getStack(2);
                if (var7_31.value != ConstValue.VOLATILE && var8_42.value != ConstValue.VOLATILE) {
                    var9_57 = (Long)var7_31.value;
                    var13_85 = new Integer(var9_57 == (var11_76 = ((Long)var7_31.value).longValue()) ? 0 : (var9_57 < var11_76 ? -1 : 1));
                    var1_1.constInfo = new ConstantInfo(2, var13_85);
                    var6_17 = new ConstValue(var13_85);
                    var6_17.addConstantListener(var1_1.constInfo);
                    var7_31.addConstantListener(var6_17);
                    var8_42.addConstantListener(var6_17);
                } else {
                    var6_17 = ConstantAnalyzer.unknownValue[0];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(4, var6_17));
                break;
            }
            case 149: 
            case 150: {
                var7_32 = var1_1.getStack(2);
                var8_43 = var1_1.getStack(1);
                if (var7_32.value != ConstValue.VOLATILE && var8_43.value != ConstValue.VOLATILE) {
                    var9_58 = ((Float)var7_32.value).floatValue();
                    var11_77 = new Integer(var9_58 == (var10_68 = ((Float)var7_32.value).floatValue()) ? 0 : (var4_4 == 150 ? (var9_58 < var10_68 ? -1 : 1) : (var9_58 > var10_68 ? 1 : -1)));
                    var1_1.constInfo = new ConstantInfo(2, var11_77);
                    var6_18 = new ConstValue(var11_77);
                    var6_18.addConstantListener(var1_1.constInfo);
                    var7_32.addConstantListener(var6_18);
                    var8_43.addConstantListener(var6_18);
                } else {
                    var6_18 = ConstantAnalyzer.unknownValue[0];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(2, var6_18));
                break;
            }
            case 151: 
            case 152: {
                var7_33 = var1_1.getStack(4);
                var8_44 = var1_1.getStack(2);
                if (var7_33.value != ConstValue.VOLATILE && var8_44.value != ConstValue.VOLATILE) {
                    var9_59 = (Double)var7_33.value;
                    var13_86 = new Integer(var9_59 == (var11_78 = ((Double)var7_33.value).doubleValue()) ? 0 : (var4_4 == 152 ? (var9_59 < var11_78 ? -1 : 1) : (var9_59 > var11_78 ? 1 : -1)));
                    var1_1.constInfo = new ConstantInfo(2, var13_86);
                    var6_19 = new ConstValue(var13_86);
                    var6_19.addConstantListener(var1_1.constInfo);
                    var7_33.addConstantListener(var6_19);
                    var8_44.addConstantListener(var6_19);
                } else {
                    var6_19 = ConstantAnalyzer.unknownValue[0];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(4, var6_19));
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                var7_34 = 1;
                var8_45 = var1_1.getStack(1);
                var9_60 = null;
                v1 = var10_69 = var8_45.value != ConstValue.VOLATILE;
                if (var4_4 >= 159 && var4_4 <= 166) {
                    var9_60 = var1_1.getStack(2);
                    var7_34 = 2;
                    var10_69 &= var9_60.value != ConstValue.VOLATILE;
                }
                if (var10_69) {
                    var8_45.addConstantListener(var1_1);
                    if (var9_60 != null) {
                        var9_60.addConstantListener(var1_1);
                    }
                    var11_79 = var3_3.getNextByAddr();
                    if (var4_4 >= 165) {
                        if (var4_4 >= 198) {
                            var12_90 = var8_45.value == null ? 41 : 26;
                            var4_4 -= 198;
                        } else {
                            var12_90 = var8_45.value == var9_60.value ? 41 : 26;
                            var4_4 -= 165;
                        }
                    } else {
                        var13_87 = (Integer)var8_45.value;
                        if (var4_4 >= 159) {
                            var14_95 = (Integer)var9_60.value;
                            var12_90 = var14_95 == var13_87 ? 41 : (var14_95 < var13_87 ? 38 : 26);
                            var4_4 -= 159;
                        } else {
                            var12_90 = var13_87 == 0 ? 41 : (var13_87 < 0 ? 38 : 26);
                            var4_4 -= 153;
                        }
                    }
                    if ((var12_90 & 1 << var4_4) != 0) {
                        var11_79 = var3_3.getSingleSucc();
                    }
                    var1_1.constInfo = new ConstantInfo(4, var11_79);
                    this.mergeInfo(var11_79, var1_1.pop(var7_34));
                    break;
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(var7_34));
                this.mergeInfo(var3_3.getSingleSucc(), var1_1.pop(var7_34));
                break;
            }
            case 167: {
                this.mergeInfo(var3_3.getSingleSucc(), var1_1.copy());
                break;
            }
            case 171: {
                var7_35 = var1_1.getStack(1);
                if (var7_35.value != ConstValue.VOLATILE) {
                    var7_35.addConstantListener(var1_1);
                    var9_61 = (Integer)var7_35.value;
                    var10_70 = var3_3.getValues();
                    var8_46 = var3_3.getSuccs()[var10_70.length];
                    var11_80 = 0;
                    while (var11_80 < var10_70.length) {
                        if (var10_70[var11_80] == var9_61) {
                            var8_46 = var3_3.getSuccs()[var11_80];
                            break;
                        }
                        ++var11_80;
                    }
                    var1_1.constInfo = new ConstantInfo(4, var8_46);
                    this.mergeInfo(var8_46, var1_1.pop(1));
                    break;
                }
                var8_47 = 0;
                while (var8_47 < var3_3.getSuccs().length) {
                    this.mergeInfo(var3_3.getSuccs()[var8_47], var1_1.pop(1));
                    ++var8_47;
                }
                break;
            }
            case 168: {
                if (var3_3.getSingleSucc().getOpcode() != 58) {
                    throw new RuntimeException("Can't handle jsr to non astores");
                }
                var7_36 = (StackLocalInfo)var3_3.getSingleSucc().getTmpInfo();
                if (var7_36 != null) {
                    var6_20 = var7_36.getStack(1);
                    if (var7_36.retInfo != null && var6_20.value instanceof JSRTargetInfo) {
                        this.mergeInfo(var3_3.getNextByAddr(), var1_1.copy().mergeRetLocals((JSRTargetInfo)var6_20.value, var7_36.retInfo));
                    }
                } else {
                    var6_20 = new ConstValue(new JSRTargetInfo(var3_3.getSingleSucc()));
                }
                this.mergeInfo(var3_3.getSingleSucc(), var1_1.poppush(0, var6_20));
                break;
            }
            case 169: {
                var6_21 = var1_1.getLocal(var3_3.getLocalSlot());
                var8_48 = (JSRTargetInfo)var6_21.value;
                var8_48.setRetInfo(var1_1);
                var6_21.addConstantListener(var1_1);
                var9_62 = var8_48.jsrTarget;
                var10_71 = (StackLocalInfo)var9_62.getTmpInfo();
                var10_71.retInfo = var1_1;
                var10_71.constInfo.flags |= 16;
                var11_81 = var9_62.getPreds();
                var12_91 = 0;
                while (var12_91 < var11_81.length) {
                    var13_88 = var11_81[var12_91];
                    if (var13_88.getTmpInfo() != null) {
                        this.mergeInfo(var13_88.getNextByAddr(), ((StackLocalInfo)var13_88.getTmpInfo()).copy().mergeRetLocals(var8_48, var1_1));
                    }
                    ++var12_91;
                }
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                break;
            }
            case 179: 
            case 181: {
                var8_49 = (FieldIdentifier)this.canonizeReference(var3_3);
                var9_63 = var3_3.getReference();
                var10_72 = TypeSignature.getTypeSize(var9_63.getType());
                if (var8_49 != null && !var8_49.isNotConstant()) {
                    var11_82 = var1_1.getStack(var10_72);
                    var12_92 = var8_49.getConstant();
                    if (var12_92 == null) {
                        var12_92 = ConstantRuntimeEnvironment.getDefaultValue(var9_63.getType());
                    }
                    v2 = var11_82.value == null ? var12_92 == null : var11_82.value.equals(var12_92);
                    if (v2) {
                        var11_82.addConstantListener(var1_1);
                    } else {
                        var8_49.setNotConstant();
                        this.fieldNotConstant(var8_49);
                    }
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(var10_72 += var4_4 == 179 ? 0 : 1));
                break;
            }
            case 178: 
            case 180: {
                var8_50 = var4_4 == 178 ? 0 : 1;
                var9_64 = (FieldIdentifier)this.canonizeReference(var3_3);
                var10_73 = var3_3.getReference();
                var11_83 = TypeSignature.getTypeSize(var10_73.getType());
                if (var9_64 != null) {
                    if (var9_64.isNotConstant()) {
                        var9_64.setReachable();
                        var6_22 = ConstantAnalyzer.unknownValue[var11_83 - 1];
                    } else {
                        var12_93 = var9_64.getConstant();
                        if (var12_93 == null) {
                            var12_93 = ConstantRuntimeEnvironment.getDefaultValue(var10_73.getType());
                        }
                        var1_1.constInfo = new ConstantInfo(2, var12_93);
                        var6_22 = new ConstValue(var12_93);
                        var6_22.addConstantListener(var1_1.constInfo);
                        var9_64.addFieldListener(var2_2);
                    }
                } else {
                    var6_22 = ConstantAnalyzer.unknownValue[var11_83 - 1];
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var8_50, var6_22));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.canonizeReference(var3_3);
                var8_51 = var3_3.getReference();
                var9_65 = true;
                var10_74 = 0;
                var11_84 = null;
                var12_94 = TypeSignature.getParameterTypes(var8_51.getType());
                var13_89 = new Object[var12_94.length];
                var14_96 = null;
                var15_97 = new ConstValue[var12_94.length];
                var16_98 = var12_94.length - 1;
                while (var16_98 >= 0) {
                    var15_97[var16_98] = var1_1.getStack(var10_74 += TypeSignature.getTypeSize(var12_94[var16_98]));
                    var17_100 = var15_97[var16_98].value;
                    if (var17_100 != ConstValue.VOLATILE) {
                        var13_89[var16_98] = var17_100;
                    } else {
                        var9_65 = false;
                    }
                    --var16_98;
                }
                if (var4_4 != 184) {
                    var14_96 = var1_1.getStack(++var10_74);
                    var11_84 = var14_96.value;
                    if (var11_84 == ConstValue.VOLATILE || var11_84 == null) {
                        var9_65 = false;
                    }
                }
                if ((var16_99 = TypeSignature.getReturnType(var8_51.getType())).equals("V")) {
                    this.handleReference(var8_51, var4_4 == 182 || var4_4 == 185);
                    this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(var10_74));
                    break;
                }
                if (var9_65 && !ConstantRuntimeEnvironment.isWhite(var16_99)) {
                    var9_65 = false;
                }
                var17_100 = null;
                if (!var9_65) ** GOTO lbl508
                try {
                    var17_100 = ConstantAnalyzer.runtime.invokeMethod(var8_51, var4_4 != 183, var11_84, var13_89);
                }
                catch (InterpreterException var18_101) {
                    var9_65 = false;
                    if (GlobalOptions.verboseLevel > 3) {
                        GlobalOptions.err.println("Can't interpret " + var8_51 + ": " + var18_101.getMessage());
                    }
                }
                catch (InvocationTargetException var18_102) {
                    var9_65 = false;
                    if (GlobalOptions.verboseLevel <= 3) ** GOTO lbl508
                    GlobalOptions.err.println("Method " + var8_51 + " throwed exception: " + var18_102.getTargetException());
                }
lbl508:
                // 5 sources

                if (!var9_65) {
                    this.handleReference(var8_51, var4_4 == 182 || var4_4 == 185);
                    var19_104 = TypeSignature.getTypeSize(var16_99);
                    var18_103 = ConstantAnalyzer.unknownValue[var19_104 - 1];
                } else {
                    var1_1.constInfo = new ConstantInfo(2, var17_100);
                    var18_103 = new ConstValue(var17_100);
                    var18_103.addConstantListener(var1_1.constInfo);
                    if (var14_96 != null) {
                        var14_96.addConstantListener(var18_103);
                    }
                    var19_105 = 0;
                    while (var19_105 < var15_97.length) {
                        var15_97[var19_105].addConstantListener(var18_103);
                        ++var19_105;
                    }
                }
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var10_74, var18_103));
                break;
            }
            case 187: {
                this.handleClass(var3_3.getClazzType());
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(0, ConstantAnalyzer.unknownValue[0]));
                break;
            }
            case 190: {
                var6_23 = ConstantAnalyzer.unknownValue[0];
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(1, var6_23));
                break;
            }
            case 192: {
                this.handleClass(var3_3.getClazzType());
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(0));
                break;
            }
            case 193: {
                this.handleClass(var3_3.getClazzType());
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(1, ConstantAnalyzer.unknownValue[0]));
                break;
            }
            case 194: 
            case 195: {
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.pop(1));
                break;
            }
            case 197: {
                this.handleClass(var3_3.getClazzType());
                this.mergeInfo(var3_3.getNextByAddr(), var1_1.poppush(var3_3.getDimensions(), ConstantAnalyzer.unknownValue[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode " + var4_4);
            }
        }
    }

    public void fieldNotConstant(FieldIdentifier fieldIdentifier) {
        Iterator iterator = this.bytecode.getInstructions().iterator();
        while (iterator.hasNext()) {
            Reference reference;
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() != 180 && instruction.getOpcode() != 178 || !(reference = instruction.getReference()).getName().equals(fieldIdentifier.getName()) || !reference.getType().equals(fieldIdentifier.getType()) || instruction.getTmpInfo() == null) continue;
            ((StackLocalInfo)instruction.getTmpInfo()).enqueue();
        }
    }

    public void dumpStackLocalInfo() {
        Iterator iterator = this.bytecode.getInstructions().iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            System.err.println("" + instruction.getTmpInfo());
            System.err.println(instruction.getDescription());
        }
    }

    public void analyzeCode(MethodIdentifier methodIdentifier, BytecodeInfo bytecodeInfo) {
        Handler[] handlerArray;
        this.bytecode = bytecodeInfo;
        TodoQueue todoQueue = new TodoQueue();
        MethodInfo methodInfo = bytecodeInfo.getMethodInfo();
        Object object = bytecodeInfo.getInstructions().iterator();
        while (object.hasNext()) {
            handlerArray = (Instruction)object.next();
            handlerArray.setTmpInfo(null);
        }
        object = new StackLocalInfo(bytecodeInfo.getMaxLocals(), methodInfo.isStatic(), methodInfo.getType(), todoQueue);
        ((StackLocalInfo)object).instr = (Instruction)bytecodeInfo.getInstructions().get(0);
        ((StackLocalInfo)object).instr.setTmpInfo(object);
        ((StackLocalInfo)object).enqueue();
        runtime.setFieldListener(methodIdentifier);
        while (todoQueue.first != null) {
            handlerArray = todoQueue.first;
            todoQueue.first = handlerArray.nextOnQueue;
            handlerArray.nextOnQueue = null;
            this.handleOpcode((StackLocalInfo)handlerArray, methodIdentifier);
        }
        runtime.setFieldListener(null);
        handlerArray = bytecodeInfo.getExceptionHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            if (handlerArray[n].catcher.getTmpInfo() != null && handlerArray[n].type != null) {
                Main.getClassBundle().reachableClass(handlerArray[n].type);
            }
            ++n;
        }
        Iterator iterator = bytecodeInfo.getInstructions().iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            StackLocalInfo stackLocalInfo = (StackLocalInfo)instruction.getTmpInfo();
            if (stackLocalInfo == null) continue;
            if (stackLocalInfo.constInfo.flags == 0) {
                instruction.setTmpInfo(unknownConstInfo);
                continue;
            }
            instruction.setTmpInfo(stackLocalInfo.constInfo);
        }
    }

    public static void replaceWith(ListIterator listIterator, Instruction instruction, Instruction instruction2) {
        switch (instruction.getOpcode()) {
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 167: 
            case 178: {
                if (instruction2 == null) {
                    listIterator.remove();
                } else {
                    listIterator.set(instruction2);
                }
                return;
            }
            case 116: 
            case 118: 
            case 133: 
            case 134: 
            case 135: 
            case 139: 
            case 140: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 180: 
            case 190: 
            case 198: 
            case 199: {
                listIterator.set(new Instruction(87));
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: 
            case 129: 
            case 131: 
            case 148: 
            case 151: 
            case 152: {
                listIterator.set(new Instruction(88));
                listIterator.add(new Instruction(88));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 137: 
            case 138: 
            case 142: 
            case 143: 
            case 144: 
            case 149: 
            case 150: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                listIterator.set(new Instruction(88));
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                listIterator.set(new Instruction(87));
                listIterator.add(new Instruction(88));
                break;
            }
            case 179: 
            case 181: {
                if (TypeSignature.getTypeSize(instruction.getReference().getType()) == 2) {
                    listIterator.set(new Instruction(88));
                    if (instruction.getOpcode() != 181) break;
                    listIterator.add(new Instruction(87));
                    break;
                }
                listIterator.set(new Instruction(instruction.getOpcode() == 181 ? 88 : 87));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                Reference reference = instruction.getReference();
                String[] stringArray = TypeSignature.getParameterTypes(reference.getType());
                int n = stringArray.length;
                if (n > 0) {
                    listIterator.set(new Instruction(TypeSignature.getTypeSize(stringArray[--n]) + 87 - 1));
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        listIterator.add(new Instruction(TypeSignature.getTypeSize(stringArray[n2]) + 87 - 1));
                        --n2;
                    }
                    if (instruction.getOpcode() == 184) break;
                    listIterator.add(new Instruction(87));
                    break;
                }
                if (instruction.getOpcode() != 184) {
                    listIterator.set(new Instruction(87));
                    break;
                }
                if (instruction2 == null) {
                    listIterator.remove();
                } else {
                    listIterator.set(instruction2);
                }
                return;
            }
        }
        if (instruction2 != null) {
            listIterator.add(instruction2);
        }
    }

    public void appendJump(ListIterator listIterator, Instruction instruction) {
        Instruction instruction2 = new Instruction(167);
        instruction2.setSuccs(instruction);
        listIterator.add(instruction2);
    }

    public void transformCode(BytecodeInfo bytecodeInfo) {
        ListIterator<Instruction> listIterator = bytecodeInfo.getInstructions().listIterator();
        block6: while (listIterator.hasNext()) {
            Instruction instruction;
            ConstantInfo constantInfo;
            Instruction instruction2 = (Instruction)listIterator.next();
            ConstantInfo constantInfo2 = (ConstantInfo)instruction2.getTmpInfo();
            instruction2.setTmpInfo(null);
            if (constantInfo2 == null || (constantInfo2.flags & 0x18) == 8) {
                listIterator.remove();
                continue;
            }
            if ((constantInfo2.flags & 2) != 0) {
                if (instruction2.getOpcode() <= 20) continue;
                Instruction instruction3 = new Instruction(constantInfo2.constant instanceof Long || constantInfo2.constant instanceof Double ? 20 : 18);
                instruction3.setConstant(constantInfo2.constant);
                ConstantAnalyzer.replaceWith(listIterator, instruction2, instruction3);
                if (GlobalOptions.verboseLevel <= 2) continue;
                GlobalOptions.err.println(bytecodeInfo + ": Replacing " + instruction2 + " with constant " + constantInfo2.constant);
                continue;
            }
            if ((constantInfo2.flags & 4) != 0) {
                Instruction instruction4 = (Instruction)constantInfo2.constant;
                if (instruction2.getOpcode() >= 159 && instruction2.getOpcode() <= 166) {
                    listIterator.set(new Instruction(88));
                } else {
                    listIterator.set(new Instruction(87));
                }
                if (GlobalOptions.verboseLevel > 2) {
                    GlobalOptions.err.println(bytecodeInfo + ": Replacing " + instruction2 + " with goto " + instruction4.getAddr());
                }
                while (listIterator.hasNext()) {
                    constantInfo = (ConstantInfo)((Instruction)listIterator.next()).getTmpInfo();
                    if (constantInfo != null) {
                        instruction = (Instruction)listIterator.previous();
                        if (instruction4 == instruction) continue block6;
                        this.appendJump(listIterator, instruction4);
                        continue block6;
                    }
                    listIterator.remove();
                }
                continue;
            }
            int n = instruction2.getOpcode();
            block0 : switch (n) {
                case 0: {
                    listIterator.remove();
                    break;
                }
                case 168: {
                    constantInfo = (ConstantInfo)instruction2.getSingleSucc().getTmpInfo();
                    if ((constantInfo.flags & 0x10) != 0) continue block6;
                    instruction = new Instruction(167);
                    instruction.setSuccs(instruction2.getSingleSucc());
                    listIterator.set(instruction);
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    Object object;
                    Object object2;
                    while (listIterator.hasNext()) {
                        object2 = (ConstantInfo)((Instruction)listIterator.next()).getTmpInfo();
                        if (object2 != null && (((ConstantInfo)object2).flags & 0x18) != 8) {
                            object = (Instruction)listIterator.previous();
                            if (instruction2.getSingleSucc() != object) continue block6;
                            listIterator.previous();
                            listIterator.next();
                            ConstantAnalyzer.replaceWith(listIterator, instruction2, null);
                            break block0;
                        }
                        listIterator.remove();
                    }
                    continue block6;
                }
                case 179: 
                case 181: {
                    Object object2 = instruction2.getReference();
                    Object object = (FieldIdentifier)Main.getClassBundle().getIdentifier((Reference)object2);
                    if (object == null || (Main.stripping & 1) == 0 || ((Identifier)object).isReachable()) continue block6;
                    ConstantAnalyzer.replaceWith(listIterator, instruction2, null);
                    break;
                }
            }
        }
    }

    private static final class JSRTargetInfo
    implements Cloneable {
        Instruction jsrTarget;
        BitSet usedLocals;
        Object dependent;

        public JSRTargetInfo copy() {
            try {
                JSRTargetInfo jSRTargetInfo = (JSRTargetInfo)this.clone();
                jSRTargetInfo.usedLocals = (BitSet)this.usedLocals.clone();
                this.addDependent(jSRTargetInfo);
                return jSRTargetInfo;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IncompatibleClassChangeError(cloneNotSupportedException.getMessage());
            }
        }

        private void addDependent(JSRTargetInfo jSRTargetInfo) {
            if (this.dependent == null || this.dependent == jSRTargetInfo) {
                this.dependent = jSRTargetInfo;
            } else if (this.dependent instanceof JSRTargetInfo) {
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(this.dependent);
                hashSet.add(jSRTargetInfo);
            } else if (this.dependent instanceof Collection) {
                ((Collection)this.dependent).add(jSRTargetInfo);
            }
        }

        public void setRetInfo(StackLocalInfo stackLocalInfo) {
            this.dependent = stackLocalInfo;
        }

        public boolean uses(int n) {
            return this.usedLocals.get(n);
        }

        public void addUsed(int n) {
            if (this.usedLocals.get(n)) {
                return;
            }
            this.usedLocals.set(n);
            if (this.dependent instanceof StackLocalInfo) {
                ((StackLocalInfo)this.dependent).enqueue();
            } else if (this.dependent instanceof JSRTargetInfo) {
                ((JSRTargetInfo)this.dependent).addUsed(n);
            } else if (this.dependent instanceof Collection) {
                Iterator iterator = ((Collection)this.dependent).iterator();
                while (iterator.hasNext()) {
                    JSRTargetInfo jSRTargetInfo = (JSRTargetInfo)iterator.next();
                    jSRTargetInfo.addUsed(n);
                }
            }
        }

        public void merge(JSRTargetInfo jSRTargetInfo) {
            jSRTargetInfo.addDependent(this);
            int n = 0;
            while (n < jSRTargetInfo.usedLocals.size()) {
                if (jSRTargetInfo.usedLocals.get(n)) {
                    this.addUsed(n);
                }
                ++n;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.jsrTarget));
            if (this.dependent instanceof StackLocalInfo) {
                stringBuffer.append("->").append(((StackLocalInfo)this.dependent).instr);
            }
            return stringBuffer.append(this.usedLocals).append('_').append(this.hashCode()).toString();
        }

        public JSRTargetInfo(Instruction instruction) {
            this.jsrTarget = instruction;
            this.usedLocals = new BitSet();
        }
    }

    private static interface ConstantListener {
        public void constantChanged();
    }

    private static class ConstValue
    implements ConstantListener {
        public static final Object VOLATILE = new Object();
        Object value;
        int stackSize;
        Set listeners;

        public ConstValue copy() {
            return this.value == VOLATILE ? this : new ConstValue(this);
        }

        public void addConstantListener(ConstantListener constantListener) {
            this.listeners.add(constantListener);
        }

        public void removeConstantListener(ConstantListener constantListener) {
            this.listeners.remove(constantListener);
        }

        public void fireChanged() {
            this.value = VOLATILE;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ConstantListener)iterator.next()).constantChanged();
            }
            this.listeners = null;
        }

        public void constantChanged() {
            if (this.value != VOLATILE) {
                this.fireChanged();
            }
        }

        public void merge(ConstValue constValue) {
            if (this == constValue) {
                return;
            }
            boolean bl = this.value == null ? constValue.value == null : this.value.equals(constValue.value);
            if (bl) {
                if (this.value != VOLATILE) {
                    constValue.addConstantListener(this);
                    this.addConstantListener(constValue);
                }
                return;
            }
            if (this.value instanceof JSRTargetInfo && constValue.value instanceof JSRTargetInfo && ((JSRTargetInfo)this.value).jsrTarget == ((JSRTargetInfo)constValue.value).jsrTarget) {
                ((JSRTargetInfo)this.value).merge((JSRTargetInfo)constValue.value);
                return;
            }
            if (this.value != VOLATILE) {
                this.fireChanged();
            }
        }

        public String toString() {
            return this.value == VOLATILE ? "vol(" + this.stackSize + ")" : "" + this.value;
        }

        public ConstValue(Object object) {
            this.value = object;
            this.stackSize = object instanceof Double || object instanceof Long ? 2 : 1;
            this.listeners = new HashSet();
        }

        public ConstValue(ConstValue constValue) {
            this.value = constValue.value;
            this.stackSize = constValue.stackSize;
            this.listeners = new HashSet();
            constValue.addConstantListener(this);
        }

        public ConstValue(int n) {
            this.value = VOLATILE;
            this.stackSize = n;
        }
    }

    private static class TodoQueue {
        StackLocalInfo first;

        TodoQueue() {
        }
    }

    private static class StackLocalInfo
    implements ConstantListener {
        ConstValue[] stack;
        ConstValue[] locals;
        Instruction instr;
        ConstantInfo constInfo;
        StackLocalInfo retInfo;
        StackLocalInfo nextOnQueue;
        TodoQueue notifyQueue;

        public ConstValue copy(ConstValue constValue) {
            return constValue == null ? null : constValue.copy();
        }

        public final void enqueue() {
            if (this.nextOnQueue == null) {
                this.nextOnQueue = this.notifyQueue.first;
                this.notifyQueue.first = this;
            }
        }

        public void constantChanged() {
            this.enqueue();
        }

        public StackLocalInfo poppush(int n, ConstValue constValue) {
            ConstValue[] constValueArray = new ConstValue[this.stack.length - n + constValue.stackSize];
            ConstValue[] constValueArray2 = (ConstValue[])this.locals.clone();
            System.arraycopy(this.stack, 0, constValueArray, 0, this.stack.length - n);
            constValueArray[this.stack.length - n] = constValue.copy();
            return new StackLocalInfo(constValueArray, constValueArray2, this.notifyQueue);
        }

        public StackLocalInfo pop(int n) {
            ConstValue[] constValueArray = new ConstValue[this.stack.length - n];
            ConstValue[] constValueArray2 = (ConstValue[])this.locals.clone();
            System.arraycopy(this.stack, 0, constValueArray, 0, this.stack.length - n);
            return new StackLocalInfo(constValueArray, constValueArray2, this.notifyQueue);
        }

        public StackLocalInfo dup(int n, int n2) {
            int n3;
            ConstValue[] constValueArray = new ConstValue[this.stack.length + n];
            ConstValue[] constValueArray2 = (ConstValue[])this.locals.clone();
            if (n2 == 0) {
                System.arraycopy(this.stack, 0, constValueArray, 0, this.stack.length);
            } else {
                n3 = this.stack.length - n - n2;
                System.arraycopy(this.stack, 0, constValueArray, 0, n3);
                int n4 = 0;
                while (n4 < n) {
                    constValueArray[n3++] = this.copy(this.stack[this.stack.length - n + n4]);
                    ++n4;
                }
                n4 = 0;
                while (n4 < n2) {
                    constValueArray[n3++] = this.copy(this.stack[this.stack.length - n - n2 + n4]);
                    ++n4;
                }
            }
            n3 = 0;
            while (n3 < n) {
                constValueArray[this.stack.length + n3] = this.copy(this.stack[this.stack.length - n + n3]);
                ++n3;
            }
            return new StackLocalInfo(constValueArray, constValueArray2, this.notifyQueue);
        }

        public StackLocalInfo swap() {
            ConstValue[] constValueArray = new ConstValue[this.stack.length];
            ConstValue[] constValueArray2 = (ConstValue[])this.locals.clone();
            System.arraycopy(this.stack, 0, constValueArray, 0, this.stack.length - 2);
            constValueArray[this.stack.length - 2] = this.stack[this.stack.length - 1].copy();
            constValueArray[this.stack.length - 1] = this.stack[this.stack.length - 2].copy();
            return new StackLocalInfo(constValueArray, constValueArray2, this.notifyQueue);
        }

        public StackLocalInfo copy() {
            ConstValue[] constValueArray = (ConstValue[])this.stack.clone();
            ConstValue[] constValueArray2 = (ConstValue[])this.locals.clone();
            return new StackLocalInfo(constValueArray, constValueArray2, this.notifyQueue);
        }

        public ConstValue getLocal(int n) {
            return this.locals[n];
        }

        public ConstValue getStack(int n) {
            return this.stack[this.stack.length - n];
        }

        public StackLocalInfo setLocal(int n, ConstValue constValue) {
            JSRTargetInfo jSRTargetInfo;
            this.locals[n] = constValue;
            if (constValue != null && constValue.stackSize == 2) {
                this.locals[n + 1] = null;
            }
            int n2 = 0;
            while (n2 < this.locals.length) {
                if (this.locals[n2] != null && this.locals[n2].value instanceof JSRTargetInfo && !(jSRTargetInfo = (JSRTargetInfo)this.locals[n2].value).uses(n)) {
                    jSRTargetInfo = jSRTargetInfo.copy();
                    this.locals[n2] = this.locals[n2].copy();
                    this.locals[n2].value = jSRTargetInfo;
                    jSRTargetInfo.addUsed(n);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.stack.length) {
                if (this.stack[n2] != null && this.stack[n2].value instanceof JSRTargetInfo && !(jSRTargetInfo = (JSRTargetInfo)this.stack[n2].value).uses(n)) {
                    jSRTargetInfo = jSRTargetInfo.copy();
                    this.stack[n2] = this.stack[n2].copy();
                    this.stack[n2].value = jSRTargetInfo;
                    jSRTargetInfo.addUsed(n);
                }
                ++n2;
            }
            return this;
        }

        public StackLocalInfo mergeRetLocals(JSRTargetInfo jSRTargetInfo, StackLocalInfo stackLocalInfo) {
            int n;
            JSRTargetInfo jSRTargetInfo2;
            int n2 = 0;
            while (n2 < this.locals.length) {
                if (jSRTargetInfo.uses(n2)) {
                    this.locals[n2] = stackLocalInfo.locals[n2];
                }
                ++n2;
            }
            this.locals[stackLocalInfo.instr.getLocalSlot()] = null;
            n2 = 0;
            while (n2 < this.locals.length) {
                if (this.locals[n2] != null && this.locals[n2].value instanceof JSRTargetInfo) {
                    jSRTargetInfo2 = (JSRTargetInfo)this.locals[n2].value;
                    jSRTargetInfo2 = jSRTargetInfo2.copy();
                    this.locals[n2] = this.locals[n2].copy();
                    this.locals[n2].value = jSRTargetInfo2;
                    n = 0;
                    while (n < this.locals.length) {
                        if (jSRTargetInfo.uses(n)) {
                            jSRTargetInfo2.addUsed(n);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.stack.length) {
                if (this.stack[n2] != null && this.stack[n2].value instanceof JSRTargetInfo) {
                    jSRTargetInfo2 = (JSRTargetInfo)this.stack[n2].value;
                    jSRTargetInfo2 = jSRTargetInfo2.copy();
                    this.stack[n2] = this.stack[n2].copy();
                    this.stack[n2].value = jSRTargetInfo2;
                    n = 0;
                    while (n < this.locals.length) {
                        if (jSRTargetInfo.uses(n)) {
                            jSRTargetInfo2.addUsed(n);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
            return this;
        }

        public void merge(StackLocalInfo stackLocalInfo) {
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    if (stackLocalInfo.locals[n] == null) {
                        this.locals[n].constantChanged();
                        this.locals[n] = null;
                        this.enqueue();
                    } else {
                        this.locals[n].merge(stackLocalInfo.locals[n]);
                    }
                }
                ++n;
            }
            if (this.stack.length != stackLocalInfo.stack.length) {
                throw new AssertError("stack length differs");
            }
            n = 0;
            while (n < this.stack.length) {
                if (stackLocalInfo.stack[n] == null != (this.stack[n] == null)) {
                    throw new AssertError("stack types differ");
                }
                if (this.stack[n] != null) {
                    this.stack[n].merge(stackLocalInfo.stack[n]);
                }
                ++n;
            }
        }

        public String toString() {
            return "Locals: " + Arrays.asList(this.locals) + "Stack: " + Arrays.asList(this.stack) + "Instr: " + this.instr;
        }

        private StackLocalInfo(ConstValue[] constValueArray, ConstValue[] constValueArray2, TodoQueue todoQueue) {
            this.stack = constValueArray;
            this.locals = new ConstValue[constValueArray2.length];
            int n = 0;
            while (n < constValueArray2.length) {
                this.locals[n] = this.copy(constValueArray2[n]);
                ++n;
            }
            this.notifyQueue = todoQueue;
        }

        public StackLocalInfo(int n, boolean bl, String string, TodoQueue todoQueue) {
            String[] stringArray = TypeSignature.getParameterTypes(string);
            this.locals = new ConstValue[n];
            this.stack = new ConstValue[0];
            this.notifyQueue = todoQueue;
            int n2 = 0;
            if (!bl) {
                this.locals[n2++] = new ConstValue(1);
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                int n4 = TypeSignature.getTypeSize(stringArray[n3]);
                this.locals[n2] = unknownValue[n4 - 1];
                n2 += n4;
                ++n3;
            }
        }
    }

    private static class ConstantInfo
    implements ConstantListener {
        int flags;
        Object constant;

        public void constantChanged() {
            this.constant = null;
            this.flags &= 0xFFFFFFF9;
        }

        ConstantInfo() {
            this(0, null);
        }

        ConstantInfo(int n) {
            this(n, null);
        }

        ConstantInfo(int n, Object object) {
            this.flags = n;
            this.constant = object;
        }
    }
}

