/*
 * Decompiled with CFR 0.152.
 */
package jode.swingui;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JProgressBar;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jode.bytecode.ClassInfo;
import jode.swingui.Main;

public class HierarchyTreeModel
implements TreeModel,
Runnable {
    static final int MAX_PACKAGE_LEVEL = 10;
    TreeElement root;
    Set listeners;
    JProgressBar progressBar;
    Main main;

    private TreeElement handleClass(HashMap hashMap, ClassInfo classInfo) {
        ClassInfo[] classInfoArray;
        if (classInfo == null) {
            return this.root;
        }
        TreeElement treeElement = (TreeElement)hashMap.get(classInfo);
        if (treeElement != null) {
            return treeElement;
        }
        HierarchyTreeModel hierarchyTreeModel = this;
        if (hierarchyTreeModel == null) {
            throw null;
        }
        treeElement = hierarchyTreeModel.new TreeElement(classInfo.getName());
        hashMap.put(classInfo, treeElement);
        if (!classInfo.isInterface()) {
            classInfoArray = classInfo.getSuperclass();
            this.handleClass(hashMap, (ClassInfo)classInfoArray).addChild(treeElement);
        }
        classInfoArray = classInfo.getInterfaces();
        int n = 0;
        while (n < classInfoArray.length) {
            this.handleClass(hashMap, classInfoArray[n]).addChild(treeElement);
            ++n;
        }
        if (classInfoArray.length == 0 && classInfo.isInterface()) {
            this.root.addChild(treeElement);
        }
        return treeElement;
    }

    public int readPackage(int n, HashMap hashMap, String string, int n2) {
        if (n++ >= 10) {
            return n2;
        }
        String string2 = string.length() == 0 ? "" : string + ".";
        Enumeration enumeration = ClassInfo.getClassesAndPackages(string);
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string2 + string3;
            if (ClassInfo.isPackage(string4)) {
                n2 = this.readPackage(n, hashMap, string4, n2);
                continue;
            }
            TreeElement treeElement = this.handleClass(hashMap, ClassInfo.forName(string4));
            if (this.progressBar != null) {
                this.progressBar.setValue(++n2);
            }
            treeElement.inClassPath = true;
        }
        return n2;
    }

    public int countClasses(int n, String string) {
        if (n++ >= 10) {
            return 0;
        }
        int n2 = 0;
        String string2 = string.length() == 0 ? "" : string + ".";
        Enumeration enumeration = ClassInfo.getClassesAndPackages(string);
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string2 + string3;
            if (ClassInfo.isPackage(string4)) {
                n2 += this.countClasses(n, string4);
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public void rebuild() {
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    public void run() {
        TreeModelListener[] treeModelListenerArray;
        if (this.progressBar != null) {
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.countClasses(0, ""));
        }
        this.readPackage(0, new HashMap(), "", 0);
        Set set = this.listeners;
        synchronized (set) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.root});
        int n = 0;
        while (n < treeModelListenerArray.length) {
            treeModelListenerArray[n].treeStructureChanged(treeModelEvent);
            ++n;
        }
        this.main.reselect();
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public Object getChild(Object object, int n) {
        Iterator iterator = ((TreeElement)object).getChilds().iterator();
        int n2 = 0;
        while (n2 < n) {
            iterator.next();
            ++n2;
        }
        return iterator.next();
    }

    public int getChildCount(Object object) {
        return ((TreeElement)object).getChilds().size();
    }

    public int getIndexOfChild(Object object, Object object2) {
        Iterator iterator = ((TreeElement)object).getChilds().iterator();
        int n = 0;
        while (iterator.next() != object2) {
            ++n;
        }
        return n;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return ((TreeElement)object).getChilds().isEmpty();
    }

    public boolean isValidClass(Object object) {
        return ((TreeElement)object).inClassPath;
    }

    public String getFullName(Object object) {
        return ((TreeElement)object).getFullName();
    }

    public TreePath getPath(String string) {
        if (string == null || string.length() == 0) {
            return new TreePath(this.root);
        }
        int n = 2;
        ClassInfo classInfo = ClassInfo.forName(string);
        while (classInfo.getSuperclass() != null) {
            ++n;
            classInfo = classInfo.getSuperclass();
        }
        Object[] objectArray = new TreeElement[n];
        objectArray[0] = this.root;
        int n2 = 0;
        block1: while (n2 < n - 1) {
            classInfo = ClassInfo.forName(string);
            int n3 = 2;
            while (n3 < n - n2) {
                classInfo = classInfo.getSuperclass();
                ++n3;
            }
            Iterator iterator = ((TreeElement)objectArray[n2]).getChilds().iterator();
            while (iterator.hasNext()) {
                TreeElement treeElement = (TreeElement)iterator.next();
                if (!treeElement.getFullName().equals(classInfo.getName())) continue;
                objectArray[++n2] = treeElement;
                continue block1;
            }
            return null;
        }
        return new TreePath(objectArray);
    }

    public HierarchyTreeModel(Main main) {
        HierarchyTreeModel hierarchyTreeModel = this;
        if (hierarchyTreeModel == null) {
            throw null;
        }
        this.root = hierarchyTreeModel.new TreeElement("");
        this.listeners = new HashSet();
        this.main = main;
        this.progressBar = null;
        this.rebuild();
    }

    public HierarchyTreeModel(Main main, JProgressBar jProgressBar) {
        HierarchyTreeModel hierarchyTreeModel = this;
        if (hierarchyTreeModel == null) {
            throw null;
        }
        this.root = hierarchyTreeModel.new TreeElement("");
        this.listeners = new HashSet();
        this.main = main;
        this.progressBar = jProgressBar;
        this.rebuild();
    }

    class TreeElement
    implements Comparable {
        String fullName;
        TreeSet childs;
        boolean inClassPath = false;

        public String getFullName() {
            return this.fullName;
        }

        public void addChild(TreeElement treeElement) {
            this.childs.add(treeElement);
        }

        public Collection getChilds() {
            return this.childs;
        }

        public String toString() {
            return this.fullName;
        }

        public int compareTo(Object object) {
            TreeElement treeElement = (TreeElement)object;
            return this.fullName.compareTo(treeElement.fullName);
        }

        public boolean equals(Object object) {
            return object instanceof TreeElement && this.fullName.equals(((TreeElement)object).fullName);
        }

        public int hashCode() {
            return this.fullName.hashCode();
        }

        public TreeElement(String string) {
            this.fullName = string;
            this.childs = new TreeSet();
        }
    }
}

