/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.ExecutionException;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;
import java.util.List;

public class Decode
extends Microinstruction {
    private Register ir;
    private Machine machine;

    public Decode(String name, Register ir, Machine machine) {
        super(name);
        this.ir = ir;
        this.machine = machine;
    }

    public void setIr(Register newIR) {
        this.ir = newIR;
    }

    public Register getIr() {
        return this.ir;
    }

    public void setMachine(Machine newMachine) {
        this.machine = newMachine;
    }

    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public Object clone() {
        return new Decode(this.getName(), this.getIr(), this.machine);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Decode, "Passed non-Decode to Decode.copyDataTo()");
        Decode newDecode = (Decode)newMicro;
        newDecode.setName(this.getName());
        newDecode.setIr(this.getIr());
        newDecode.machine = this.machine;
    }

    @Override
    public boolean uses(Module m) {
        return m == this.ir;
    }

    @Override
    public void execute() {
        List<MachineInstruction> instructions = this.machine.getInstructions();
        int width = this.ir.getWidth();
        long value = this.ir.getValue();
        for (int i = 1; i <= width; ++i) {
            value = value << 64 - width >>> 64 - width;
            long opcode = value >>> width - i;
            for (MachineInstruction instr : instructions) {
                if (opcode != instr.getOpcode() || i != instr.getFields().get(0).getNumBits()) continue;
                this.machine.getControlUnit().setMicroIndex(0);
                this.machine.getControlUnit().setCurrentInstruction(instr);
                return;
            }
        }
        throw new ExecutionException("No opcode matched the bits in the register " + this.ir);
    }

    @Override
    public String getXMLDescription() {
        return "<Decode name=\"" + this.getHTMLName() + "\" ir=\"" + this.getIr().getID() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getIr().getHTMLName() + "</TD></TR>";
    }
}

