/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.Module;
import cpusim.module.ModuleFactory;
import cpusim.module.RAM;
import java.util.HashMap;
import java.util.Vector;

public class RAMFactory
extends ModuleFactory {
    private Vector currentModules;
    private RAM prototype;

    public RAMFactory(Machine machine) {
        super(machine);
        this.currentModules = machine.getModule("rams");
        this.prototype = new RAM("???", 128, 8);
        this.clones = (Module[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap editors = new HashMap();
        return editors;
    }

    @Override
    Module getPrototype() {
        return this.prototype;
    }

    @Override
    Class getModuleClass() {
        return RAM.class;
    }

    @Override
    public Vector getCurrentModules() {
        return this.currentModules;
    }

    @Override
    public String toString() {
        return "RAM";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "length", "cellSize"};
    }

    @Override
    public void setClones(Object[] newClones) {
        RAM[] rams = new RAM[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            rams[i] = (RAM)newClones[i];
        }
        this.clones = rams;
    }

    @Override
    public boolean checkValidity(Object[] modules) {
        Module[] rams = new RAM[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            rams[i] = (RAM)modules[i];
        }
        return this.allNamesAreUnique(rams) && !this.someNamesAreEmpty(rams) && this.lengthsArePositive((RAM[])rams) && this.cellSizesAreValid((RAM[])rams);
    }

    private boolean cellSizesAreValid(RAM[] rams) {
        for (int i = 0; i < rams.length; ++i) {
            int size = rams[i].getCellSize();
            if (size > 0 && size <= 64) continue;
            this.displayError("The RAM module \"" + rams[i].getName() + "\" has cell size " + rams[i].getCellSize() + ".\nThe cell size must be an integer from 1 to 64.");
            return false;
        }
        return true;
    }

    public boolean lengthsArePositive(RAM[] rams) {
        for (int i = 0; i < rams.length; ++i) {
            if (rams[i].getLength() > 0) continue;
            this.displayError("The RAM module \"" + rams[i].getName() + "\" has length " + rams[i].getLength() + ".\nThe length must be a positive integer.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newModulesAreAllowed() {
        return true;
    }

    @Override
    public String getHelpPageID() {
        return "RAM";
    }
}

