/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import acm.io.IOConsole;
import cpusim.CommandLineChannel;
import cpusim.FileChannel;
import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.assembler.AssembledInstructionCall;
import cpusim.assembler.Assembler;
import cpusim.assembler.AssemblyException;
import cpusim.gui.Desktop;
import cpusim.gui.LangUnit;
import cpusim.microinstruction.IO;
import cpusim.util.LoadException;
import cpusim.xml.MachineReader;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.xml.sax.SAXParseException;

public class Main {
    public static void main(String[] argv) {
        Desktop desktop;
        String machineFileName = null;
        String textFileName = null;
        Object languageName = null;
        boolean commandLineMode = false;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-m") && i + 1 < argv.length) {
                machineFileName = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-t") && i + 1 < argv.length) {
                textFileName = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-l") && i + 1 < argv.length) {
                LangUnit.setLanguage(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-c")) {
                commandLineMode = true;
                ++i;
                continue;
            }
            String errorMessage = "Bad command line argument: " + argv[i];
            if (commandLineMode) {
                System.out.println(errorMessage);
            } else {
                JOptionPane.showMessageDialog(null, errorMessage, "Command line Error", 0);
            }
            return;
        }
        if (commandLineMode) {
            if (machineFileName == null || textFileName == null) {
                System.out.println("If you specify command line mode '-c', you must also specify a machine file with '-m' and a program file with '-t'.");
                return;
            }
            Main.loadAndRunInCommandLineMode(machineFileName, textFileName);
            return;
        }
        MachineReader reader = new MachineReader();
        if (machineFileName == null) {
            Machine machine = new Machine("New");
            Assembler assembler = new Assembler(machine);
            desktop = new Desktop(machine, assembler);
        } else {
            try {
                File machineFile = new File(machineFileName);
                reader.parseDataFromFile(machineFile);
                Machine machine = reader.getMachine();
                Assembler assembler = new Assembler(machine);
                desktop = new Desktop(machine, assembler);
                desktop.displayMachine(reader, machineFile);
            }
            catch (Exception ex) {
                String errorMessage = ex.getMessage();
                if (errorMessage == null) {
                    errorMessage = "The error type is unknown.";
                }
                String messagePrefix = "Error when reading the machine file \"" + machineFileName + "\"";
                if (ex instanceof SAXParseException) {
                    messagePrefix = messagePrefix + " at line " + ((SAXParseException)ex).getLineNumber();
                }
                errorMessage = messagePrefix + ".\n" + errorMessage + "\n" + "CPU Sim will start with a new machine.";
                Machine machine = new Machine("New");
                Assembler assembler = new Assembler(machine);
                desktop = new Desktop(machine, assembler);
                JOptionPane.showMessageDialog(desktop, errorMessage, "Reading Error", 0);
            }
        }
        desktop.loadPreferences();
        if (textFileName != null) {
            desktop.openWindowForFile(new File(textFileName));
        }
        desktop.setVisible(true);
        desktop.requestFocus();
    }

    private static void loadAndRunInCommandLineMode(String machineFileName, String textFileName) {
        MachineReader reader = new MachineReader();
        File machineFile = new File(machineFileName);
        File programFile = new File(textFileName);
        try {
            reader.parseDataFromFile(machineFile);
        }
        catch (Exception ex) {
            String errorMessage = "Error when reading the machine file \"" + machineFileName + "\"";
            if (ex instanceof SAXParseException) {
                errorMessage = errorMessage + " at line " + ((SAXParseException)ex).getLineNumber();
            }
            errorMessage = ex.getMessage() == null ? errorMessage + ".\nThe error type is unknown." : errorMessage + ".\n" + ex.getMessage();
            System.out.println(errorMessage);
            return;
        }
        final Machine machine = reader.getMachine();
        Assembler assembler = new Assembler(machine);
        try {
            assembler.assemble(programFile.getAbsolutePath(), machine.getStartingAddressForLoading());
        }
        catch (AssemblyException exc) {
            String errorMessage = exc.getMessage();
            if (exc.token.type == 8) {
                errorMessage = errorMessage + "\n at the end of the file";
            } else if (exc.token.columnNumber != -1 || exc.token.lineNumber != -1) {
                errorMessage = errorMessage + "\n       at line " + (exc.token.lineNumber + 1) + " and column " + exc.token.columnNumber;
            }
            if (!exc.token.filename.equals("")) {
                errorMessage = errorMessage + "\n       in file " + exc.token.filename;
            }
            System.out.println(errorMessage);
            return;
        }
        List<AssembledInstructionCall> instrs = assembler.getAssembledInstructions();
        try {
            machine.getCodeStore().loadAssembledInstructions(instrs, machine.getStartingAddressForLoading());
        }
        catch (LoadException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        Vector<Microinstruction> ioMicros = machine.getMicros("io");
        CommandLineChannel commandLineChannel = new CommandLineChannel("Command Line");
        for (Microinstruction io : ioMicros) {
            if (((IO)io).getConnection() instanceof FileChannel) continue;
            ((IO)io).setConnection(commandLineChannel);
        }
        IOConsole.SYSTEM_CONSOLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 46 && (e.getModifiersEx() == 2 || e.getModifiersEx() == 4)) {
                    machine.setRunMode(5);
                }
            }
        });
        machine.execute(0);
    }
}

