/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.assembler.EQU;
import cpusim.util.Factory;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class EQUFactory
implements Factory {
    private Machine machine;
    private JDialog parentFrame;
    private EQU prototype;

    public EQUFactory(Machine m) {
        this.machine = m;
        this.parentFrame = null;
        this.prototype = new EQU("?", 0L);
    }

    private EQU getNewEQU(String name) {
        EQU prototype = this.getPrototype();
        EQU clone = (EQU)prototype.clone();
        clone.setName(name);
        return clone;
    }

    public void setParentFrame(JDialog parent) {
        this.parentFrame = parent;
    }

    private EQU getPrototype() {
        return this.prototype;
    }

    @Override
    public String getHelpPageID() {
        return "EQU";
    }

    @Override
    public Object getNewObject(String name) {
        return this.getNewEQU(name);
    }

    @Override
    public Object[] createClones() {
        Vector equs = this.machine.getEQUs();
        Object[] clones = new EQU[equs.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = (EQU)((EQU)equs.elementAt(i)).clone();
        }
        return clones;
    }

    @Override
    public boolean checkValidity(Object[] list) {
        boolean result = true;
        try {
            Validate.allNamesAreUnique(list);
            for (Object f : list) {
                Validate.nameIsValidAssembly(((EQU)f).getName(), this.machine);
            }
        }
        catch (ValidationException e) {
            this.displayError(e.getMessage());
            result = false;
        }
        return result;
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }
}

