/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;

public class CpusimSet
extends Microinstruction {
    private Register register;
    private int start;
    private int numBits;
    private long value;

    public CpusimSet(String name, Register register, int start, int numBits, long value) {
        super(name);
        this.register = register;
        this.start = start;
        this.numBits = numBits;
        this.value = value;
    }

    public void setRegister(Register r) {
        this.register = r;
    }

    public Register getRegister() {
        return this.register;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public int getStart() {
        return this.start;
    }

    public void setNumBits(int n) {
        this.numBits = n;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public void setValue(long v) {
        this.value = v;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new CpusimSet(this.getName(), this.getRegister(), this.getStart(), this.getNumBits(), this.getValue());
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof CpusimSet, "Passed non-Set to Set.copyDataTo()");
        CpusimSet newSet = (CpusimSet)newMicro;
        newSet.setName(this.getName());
        newSet.setRegister(this.getRegister());
        newSet.setStart(this.getStart());
        newSet.setNumBits(this.getNumBits());
        newSet.setValue(this.getValue());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.register;
    }

    @Override
    public void execute() {
        int width = this.register.getWidth();
        long registerValue = this.register.getValue() << 64 - width;
        long leftPart = this.start == 0 ? 0L : registerValue >>> 64 - this.start << 64 - this.start;
        long middlePart = this.value << 64 - this.numBits >>> this.start;
        long rightPart = this.start + this.numBits == 64 ? 0L : registerValue << this.start + this.numBits >>> this.start + this.numBits;
        long result = (leftPart | middlePart | rightPart) >> 64 - width;
        this.register.setValue(result);
    }

    @Override
    public String getXMLDescription() {
        return "<Set name=\"" + this.getHTMLName() + "\" register=\"" + this.getRegister().getID() + "\" start=\"" + this.getStart() + "\" numBits=\"" + this.getNumBits() + "\" value=\"" + this.getValue() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getRegister().getHTMLName() + "</TD><TD>" + this.getStart() + "</TD><TD>" + this.getNumBits() + "</TD><TD>" + this.getValue() + "</TD></TR>";
    }
}

