/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.EditableJList;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DraggableEditableJList
extends EditableJList {
    private int draggingIndex;

    public DraggableEditableJList(ListModel m) {
        super(m);
        this.setSelectionMode(0);
        this.addMouseListener(new DraggingMouseListener());
        this.addListSelectionListener(new DraggingListSelectionListener());
        this.draggingIndex = -1;
    }

    private void swap(int a, int b) {
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        Object aObject = listModel.getElementAt(a);
        Object bObject = listModel.getElementAt(b);
        listModel.set(a, bObject);
        listModel.set(b, aObject);
    }

    class DraggingMouseListener
    extends MouseAdapter {
        DraggingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DraggableEditableJList.this.draggingIndex = DraggableEditableJList.this.getSelectedIndex();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DraggableEditableJList.this.draggingIndex = -1;
            DraggableEditableJList.this.setSelectionForeground(Color.black);
        }
    }

    class DraggingListSelectionListener
    implements ListSelectionListener {
        DraggingListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DraggableEditableJList.this.draggingIndex != -1) {
                int selectedIndex = DraggableEditableJList.this.getSelectedIndex();
                if (DraggableEditableJList.this.draggingIndex < selectedIndex) {
                    for (int i = DraggableEditableJList.this.draggingIndex; i < selectedIndex; ++i) {
                        DraggableEditableJList.this.swap(i, i + 1);
                    }
                } else {
                    for (int i = DraggableEditableJList.this.draggingIndex; i > selectedIndex; --i) {
                        DraggableEditableJList.this.swap(i, i - 1);
                    }
                }
                DraggableEditableJList.this.draggingIndex = selectedIndex;
                DraggableEditableJList.this.setSelectionForeground(Color.red);
            }
        }
    }
}

