/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.gui.Desktop;
import cpusim.gui.RAMWindow;
import cpusim.gui.RegistersWindow;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.CPUSimConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class UpdateDisplayManager
implements PropertyChangeListener,
CPUSimConstants {
    private Desktop desktop;

    public UpdateDisplayManager(Desktop desktop) {
        this.desktop = desktop;
        desktop.getMachine().addPropertyChangeListener(this);
    }

    public void updateRegisterWindows() {
        HashMap<Object, BaseInternalFrame> moduleWindows = this.desktop.getModuleWindows();
        for (BaseInternalFrame frame : moduleWindows.values()) {
            if (!(frame instanceof RegistersWindow)) continue;
            ((RegistersWindow)frame).updateDataDisplay();
        }
    }

    public void updateRAMWindows() {
        HashMap<Object, BaseInternalFrame> moduleWindows = this.desktop.getModuleWindows();
        for (BaseInternalFrame frame : moduleWindows.values()) {
            if (!(frame instanceof RAMWindow)) continue;
            ((RAMWindow)frame).updateDataDisplay();
        }
    }

    public void updateRegisterAndRAMWindows() {
        for (BaseInternalFrame value : this.desktop.getModuleWindows().values()) {
            if (value instanceof RegistersWindow) {
                ((RegistersWindow)value).cancelCurrentEditing();
                continue;
            }
            if (!(value instanceof RAMWindow)) continue;
            ((RAMWindow)value).cancelCurrentEditing();
        }
        this.updateRegisterWindows();
        this.updateRAMWindows();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("start of execute thread")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDisplayManager.this.desktop.enableChangeMachineMenuItems(false);
                    UpdateDisplayManager.this.desktop.setRunningMenuVisible(true);
                    if (UpdateDisplayManager.this.desktop.getDebugToolBar().isVisible()) {
                        UpdateDisplayManager.this.desktop.getDebugToolBar().setEnableAllButtons(false);
                    } else {
                        UpdateDisplayManager.this.desktop.setModifyMenuEnabled(false);
                        UpdateDisplayManager.this.desktop.enableRunMenuItems(false);
                    }
                }
            });
        } else if (propertyName.equals("exception thrown")) {
            String message = (String)event.getNewValue();
            final String errorMessage = message + "  Execution halted.";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDisplayManager.this.desktop.setRunningMenuVisible(false);
                    UpdateDisplayManager.this.updateDesktop(false);
                    JOptionPane.showMessageDialog(UpdateDisplayManager.this.desktop, errorMessage, "Execution Error", 0);
                    UpdateDisplayManager.this.desktop.enableChangeMachineMenuItems(true);
                    if (UpdateDisplayManager.this.desktop.getDebugToolBar().isVisible()) {
                        UpdateDisplayManager.this.desktop.getDebugToolBar().setEnableAllButtons(true);
                    } else {
                        UpdateDisplayManager.this.desktop.setModifyMenuEnabled(true);
                        UpdateDisplayManager.this.desktop.enableRunMenuItems(true);
                    }
                    UpdateDisplayManager.this.desktop.requestFocus();
                }
            });
        } else if (propertyName.equals("halted step by micro")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDisplayManager.this.desktop.setRunningMenuVisible(false);
                    UpdateDisplayManager.this.updateDesktop(true);
                    UpdateDisplayManager.this.desktop.displayHaltBitsThatAreSet();
                    UpdateDisplayManager.this.desktop.enableChangeMachineMenuItems(true);
                    if (UpdateDisplayManager.this.desktop.getDebugToolBar().isVisible()) {
                        UpdateDisplayManager.this.desktop.getDebugToolBar().setEnableAllButtons(true);
                    } else {
                        UpdateDisplayManager.this.desktop.setModifyMenuEnabled(true);
                        UpdateDisplayManager.this.desktop.enableRunMenuItems(true);
                    }
                    UpdateDisplayManager.this.desktop.requestFocus();
                }
            });
        } else if (propertyName.equals("execution halted")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDisplayManager.this.desktop.setRunningMenuVisible(false);
                    UpdateDisplayManager.this.updateDesktop(false);
                    UpdateDisplayManager.this.desktop.displayHaltBitsThatAreSet();
                    UpdateDisplayManager.this.desktop.enableChangeMachineMenuItems(true);
                    if (UpdateDisplayManager.this.desktop.getDebugToolBar().isVisible()) {
                        UpdateDisplayManager.this.desktop.getDebugToolBar().setEnableAllButtons(true);
                    } else {
                        UpdateDisplayManager.this.desktop.setModifyMenuEnabled(true);
                        UpdateDisplayManager.this.desktop.enableRunMenuItems(true);
                    }
                    UpdateDisplayManager.this.desktop.requestFocus();
                }
            });
        } else if (propertyName.equals("execution aborted")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateDisplayManager.this.desktop.setRunningMenuVisible(false);
                    UpdateDisplayManager.this.updateDesktop(false);
                    JOptionPane.showMessageDialog(UpdateDisplayManager.this.desktop, "Execution aborted by the user.", "Execution halted", 1);
                    UpdateDisplayManager.this.desktop.enableChangeMachineMenuItems(true);
                    if (UpdateDisplayManager.this.desktop.getDebugToolBar().isVisible()) {
                        UpdateDisplayManager.this.desktop.getDebugToolBar().setEnableAllButtons(true);
                    } else {
                        UpdateDisplayManager.this.desktop.setModifyMenuEnabled(true);
                        UpdateDisplayManager.this.desktop.enableRunMenuItems(true);
                    }
                    UpdateDisplayManager.this.desktop.requestFocus();
                }
            });
        }
    }

    private void updateDesktop(boolean outlineChanges) {
        if (this.desktop.getDebugToolBar().isVisible()) {
            this.desktop.getDebugToolBar().updateDisplay(outlineChanges);
        } else {
            this.updateRegisterAndRAMWindows();
            this.desktop.getMachine().getControlUnit().reset();
            this.desktop.getMachine().resetAllChannelsButConsole();
        }
    }
}

