/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.assembler.AssembledInstructionCall;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.InstructionCall;
import cpusim.assembler.Token;
import cpusim.util.Convert;
import java.util.ArrayList;
import java.util.List;

public class CodeGenerator {
    private Machine machine;

    public CodeGenerator(Machine machine) {
        this.machine = machine;
    }

    public List<AssembledInstructionCall> generateCode(List<InstructionCall> instructionsWithNoVars) {
        ArrayList<AssembledInstructionCall> assembledInstrCalls = new ArrayList<AssembledInstructionCall>();
        for (InstructionCall instrCall : instructionsWithNoVars) {
            if (instrCall.machineInstruction != null) {
                this.handleNormalInstruction(instrCall, assembledInstrCalls);
                continue;
            }
            this.handleData(instrCall, assembledInstrCalls);
        }
        return assembledInstrCalls;
    }

    private void handleData(InstructionCall instructionCall, List<AssembledInstructionCall> instructionCallList) {
        int cellSize = this.machine.getCodeStore().getCellSize();
        List<Token> operands = instructionCall.operands;
        int numberOfCells = (int)this.getLong(operands.get(0));
        if (numberOfCells <= 0) {
            throw new AssemblyException("Error: The first operand must be greater than 0 for the data pseudoinstruction", operands.get(0));
        }
        if (operands.size() == 2) {
            if (numberOfCells * cellSize > 64) {
                throw new AssemblyException("Error: A data pseudoinstruction can use at most 64 bits to store one value", operands.get(0));
            }
            long valueToStore = this.getLong(operands.get(1));
            this.toBinary(valueToStore, numberOfCells * cellSize, false, true, operands.get(1), false);
            instructionCallList.add(new AssembledInstructionCall(numberOfCells * cellSize, valueToStore, instructionCall.comment, instructionCall.sourceLine));
        } else {
            int numCellsPerValue = (int)this.getLong(operands.get(1));
            if (numCellsPerValue * cellSize > 64) {
                throw new AssemblyException("Error: A data pseudoinstruction can use at most 64 bits to store one value", operands.get(1));
            }
            if (numCellsPerValue <= 0) {
                throw new AssemblyException("Error: The second operand must be greater than 0 for this data pseudoinstruction", operands.get(1));
            }
            if (numberOfCells % numCellsPerValue != 0) {
                throw new AssemblyException("Error: The number of cells (the first operand) must be divisible by the number of cells per integer (the second operand)", operands.get(0));
            }
            if (numberOfCells / numCellsPerValue != operands.size() - 2) {
                throw new AssemblyException("Error: The number of cells (the first operand) must equal the number of cells per integer (the second operand) times the number of integers inside the brackets", operands.get(0));
            }
            for (int i = 2; i < operands.size(); ++i) {
                long specificValue = this.getLong(operands.get(i));
                this.toBinary(specificValue, cellSize * numCellsPerValue, false, true, operands.get(i), false);
                instructionCallList.add(new AssembledInstructionCall(numCellsPerValue * cellSize, specificValue, i == 2 ? instructionCall.comment : "", instructionCall.sourceLine));
            }
        }
    }

    private void handleNormalInstruction(InstructionCall instructionCall, List<AssembledInstructionCall> aics) {
        MachineInstruction machineInstruction = instructionCall.machineInstruction;
        int[] posFieldLengths = machineInstruction.getPositiveFieldLengths();
        boolean[] posLenFieldSigns = machineInstruction.getPosLenFieldSigns();
        List<Token> operands = instructionCall.operands;
        String opcodePart = this.toBinary(machineInstruction.getOpcode(), posFieldLengths[0], false, false, null, true);
        String[] instrParts = new String[posFieldLengths.length];
        instrParts[0] = opcodePart;
        for (int i = 1; i < instrParts.length; ++i) {
            int currentFieldLength = posFieldLengths[i];
            boolean currentFieldSign = posLenFieldSigns[i];
            long op = this.getLong(operands.get(i - 1));
            instrParts[i] = this.toBinary(op, currentFieldLength, currentFieldSign, false, operands.get(i - 1), false);
        }
        String combinedFields = "";
        for (String instrPart : instrParts) {
            combinedFields = combinedFields + instrPart;
        }
        int numBits = combinedFields.length();
        long longVal = Long.parseLong(combinedFields, 2);
        longVal = longVal << 64 - numBits >> 64 - numBits;
        aics.add(new AssembledInstructionCall(machineInstruction.length(), longVal, instructionCall.comment, instructionCall.sourceLine));
    }

    private String toBinary(long decimal, int bits, boolean signed, boolean ignoreSign, Token t, boolean isOpcode) {
        String result;
        long maxUnsignedValue = Long.rotateLeft(1L, bits) - 1L;
        long maxSignedValue = Long.rotateLeft(1L, bits - 1) - 1L;
        long minSignedValue = -(maxSignedValue + 1L);
        if (decimal >= 0L) {
            if (decimal > maxSignedValue && signed && !ignoreSign && !isOpcode) {
                throw new AssemblyException("Error: Value " + decimal + " is greater than the maximum allowed value for " + "this signed " + bits + "-bit field, which is " + maxSignedValue, t);
            }
            if (decimal > maxUnsignedValue && !isOpcode) {
                throw new AssemblyException("Error: Value " + decimal + " is greater than the maximum allowed value for " + "this " + bits + "-bit field, which is " + maxUnsignedValue, t);
            }
            result = Long.toBinaryString(decimal);
            for (int i = result.length(); i < bits; ++i) {
                result = "0" + result;
            }
        } else {
            if (!(signed || ignoreSign || isOpcode)) {
                throw new AssemblyException("Error: The value " + decimal + " is a negative value in a field that allows " + "only nonnegative values", t);
            }
            if (decimal < minSignedValue && !isOpcode) {
                throw new AssemblyException("Error: Value " + decimal + " is less than the least allowed " + "value for this field, which is " + minSignedValue, t);
            }
            result = Long.toBinaryString(maxUnsignedValue + decimal + 1L);
        }
        return result;
    }

    private long getLong(Token token) {
        long answer;
        String string = token.contents;
        try {
            answer = Convert.fromAnyBaseStringToLong(string);
        }
        catch (NumberFormatException e) {
            throw new AssemblyException("Error: The number " + token.contents + " could not be parsed as a long." + "\n    It might have illegal characters or be too large", token);
        }
        return answer;
    }
}

