/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.MachineInstrFactory;
import cpusim.MachineInstruction;
import cpusim.gui.Desktop;
import cpusim.gui.HelpDialog;
import cpusim.gui.InstructionDialog;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.NamedObject;
import cpusim.util.OOTableModel;
import cpusim.util.RegisterRAMPair;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;

public abstract class EditDialog
extends JDialog
implements CPUSimConstants {
    protected Machine machine;
    protected JButton newButton;
    protected JButton deleteButton;
    protected JButton cancelButton;
    protected JButton duplicateButton;
    protected ExtendedJTable table;
    protected Desktop desktop;

    public EditDialog(Frame parent, String name, boolean modal) {
        super(parent, name, modal);
        this.desktop = (Desktop)parent;
    }

    public EditDialog(Dialog parent, String name, boolean modal) {
        super(parent, name, modal);
        this.desktop = this.getDesktopFrom(parent);
    }

    private Desktop getDesktopFrom(Dialog parent) {
        if (parent.getParent() instanceof Desktop) {
            return (Desktop)parent.getParent();
        }
        return this.getDesktopFrom((Dialog)parent.getParent());
    }

    public Machine getMachine() {
        return this.machine;
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getDuplicateButton() {
        return this.duplicateButton;
    }

    public ExtendedJTable getTable() {
        return this.table;
    }

    public void setMachine(Machine m) {
        this.machine = m;
    }

    public void setNewButton(JButton b) {
        this.newButton = b;
    }

    public void setDuplicateButton(JButton b) {
        this.duplicateButton = b;
    }

    public void setTable(ExtendedJTable t) {
        this.table = t;
    }

    protected String createUniqueName(Object[] list, String proposedName) {
        for (Object aList : list) {
            String oldName = aList.toString();
            if (oldName == null || !oldName.equals(proposedName)) continue;
            return this.createUniqueName(list, proposedName + "?");
        }
        return proposedName;
    }

    protected String createUniqueDuplicatedName(Object[] list, String proposedName) {
        proposedName = proposedName + "copy";
        for (Object aList : list) {
            String oldName = aList.toString();
            if (oldName == null || !oldName.equals(proposedName)) continue;
            return this.createUniqueDuplicatedName(list, proposedName + "copy");
        }
        return proposedName;
    }

    protected Object[] getObjectList() {
        return this.table.getOOModel().getAllObjects();
    }

    protected abstract void updateMachine();

    protected abstract Factory getCurrentFactory();

    protected JPanel createBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 10));
        JButton okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        JButton helpButton = new JButton();
        if (MAC_OS_X) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText("Help");
        }
        okButton.addActionListener(new OkButtonListener());
        this.getRootPane().setDefaultButton(okButton);
        CancelButtonListener cancelListener = new CancelButtonListener();
        this.cancelButton.addActionListener(cancelListener);
        this.addWindowListener(cancelListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
        helpButton.addActionListener(new HelpButtonListener());
        buttonPanel.add(helpButton);
        JPanel invisiblePanel = new JPanel();
        buttonPanel.add(invisiblePanel);
        buttonPanel.add(okButton);
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    protected class HelpButtonListener
    implements ActionListener {
        protected HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(EditDialog.this);
            d.showPage(EditDialog.this.getCurrentFactory().getHelpPageID());
        }
    }

    protected class CancelButtonListener
    extends WindowAdapter
    implements ActionListener {
        protected CancelButtonListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EditDialog.this.desktop.updateDialogSizePrefs(EditDialog.this.getClass().getSimpleName(), EditDialog.this.getX(), EditDialog.this.getY(), EditDialog.this.getWidth(), EditDialog.this.getHeight());
            EditDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditDialog.this.desktop.updateDialogSizePrefs(EditDialog.this.getClass().getSimpleName(), EditDialog.this.getX(), EditDialog.this.getY(), EditDialog.this.getWidth(), EditDialog.this.getHeight());
            EditDialog.this.setVisible(false);
        }
    }

    protected class OkButtonListener
    implements ActionListener {
        protected OkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = EditDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            Object[] objList = EditDialog.this.getObjectList();
            try {
                boolean allOK = EditDialog.this.getCurrentFactory().checkValidity(objList);
                if (allOK) {
                    EditDialog.this.updateMachine();
                    EditDialog.this.desktop.updateDialogSizePrefs(EditDialog.this.getClass().getSimpleName(), EditDialog.this.getX(), EditDialog.this.getY(), EditDialog.this.getWidth(), EditDialog.this.getHeight());
                    EditDialog.this.machine.setDirty(true);
                    EditDialog.this.setVisible(false);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(EditDialog.this, ex.getMessage(), "Error", 0);
            }
        }
    }

    protected class DuplicateButtonListener
    implements ActionListener {
        protected DuplicateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = EditDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            OOTableModel model = EditDialog.this.table.getOOModel();
            if (EditDialog.this.table.getSelectedRow() == -1) {
                Assert.That(false, "Duplicate button clicked when no row was selected");
                return;
            }
            Object theObject = EditDialog.this.table.getObjectAtSelectedRow();
            Object newObject = null;
            if (theObject instanceof NamedObject) {
                NamedObject namedObject = (NamedObject)theObject;
                String uniqueName = EditDialog.this.createUniqueDuplicatedName(model.getAllObjects(), namedObject.getName());
                NamedObject newNamedObject = (NamedObject)namedObject.clone();
                newNamedObject.setName(uniqueName);
                newObject = newNamedObject;
            } else if (theObject instanceof RegisterRAMPair) {
                newObject = ((RegisterRAMPair)theObject).clone();
            } else {
                Assert.That(false, "EditDialog.DuplicateButtonListener.actionPerformed() tried to clone a non-cloneable object");
            }
            model.insertObject(newObject, 0);
            EditDialog.this.table.selectAndMakeVisibleModelRow(0);
        }
    }

    protected class NewButtonListener
    implements ActionListener {
        protected NewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = EditDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            OOTableModel model = EditDialog.this.table.getOOModel();
            String uniqueName = EditDialog.this.createUniqueName(model.getAllObjects(), "?");
            Object newObject = EditDialog.this.getCurrentFactory().getNewObject(uniqueName);
            if (EditDialog.this instanceof InstructionDialog) {
                MachineInstruction instr = (MachineInstruction)newObject;
                long uniqueOpcode = ((MachineInstrFactory)EditDialog.this.getCurrentFactory()).createUniqueOpcode(model.getAllObjects());
                instr.setOpcode(uniqueOpcode);
            }
            model.insertObject(newObject, 0);
            EditDialog.this.table.selectAndMakeVisibleModelRow(0);
            EditDialog.this.deleteButton.setEnabled(true);
            EditDialog.this.duplicateButton.setEnabled(true);
        }
    }
}

