/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Field;
import cpusim.FieldValue;
import cpusim.FieldValuesFactory;
import cpusim.Machine;
import cpusim.gui.EditDialog;
import cpusim.util.Assert;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FieldValuesDialog
extends EditDialog {
    private FieldValuesFactory valuesFactory;

    public FieldValuesDialog(Dialog parent, Machine machine, Field currentField) {
        super(parent, "Edit Acceptable field values", true);
        Container contentPane = this.getContentPane();
        this.machine = machine;
        this.valuesFactory = new FieldValuesFactory(currentField, this, machine);
        JPanel panel = this.createValuesPanel();
        contentPane.add((Component)panel, "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.valuesFactory;
    }

    private ExtendedJTable createFieldValueJTable() {
        OOTableModel model = null;
        Object[] clones = (FieldValue[])this.valuesFactory.createClones();
        HashMap editors = new HashMap();
        HashMap renderers = new HashMap();
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"name", "value"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, "beans introspection exception thrown when trying to create the FieldValueTable in FieldValuesDialog.");
        }
        this.table = new ExtendedJTable((TableModel)model, editors, renderers);
        this.table.getSelectionModel().addListSelectionListener(new FieldValueTableSelectionListener());
        this.table.setSelectionMode(0);
        return this.table;
    }

    private JPanel createListAddButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton("New");
        this.newButton.setToolTipText("create new field");
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setToolTipText("delete selected field");
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton("Duplicate");
        this.duplicateButton.setToolTipText("duplicate selected field");
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return buttonPanel;
    }

    public JPanel createValuesPanel() {
        JPanel ValuesPanel = new JPanel();
        ValuesPanel.setLayout(new BorderLayout());
        ValuesPanel.add((Component)this.createListAddButtonPanel(), "South");
        this.table = this.createFieldValueJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        ValuesPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        ValuesPanel.add((Component)new JScrollPane(this.table), "Center");
        ValuesPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return ValuesPanel;
    }

    @Override
    public void updateMachine() {
        Object[] objList = this.getObjectList();
        ArrayList<FieldValue> valueList = new ArrayList<FieldValue>();
        for (Object obj : objList) {
            valueList.add((FieldValue)obj);
        }
        this.valuesFactory.getField().setValues(valueList);
    }

    class FieldValueTableSelectionListener
    implements ListSelectionListener {
        FieldValueTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = FieldValuesDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                FieldValuesDialog.this.deleteButton.setEnabled(false);
                FieldValuesDialog.this.duplicateButton.setEnabled(false);
            } else {
                FieldValuesDialog.this.deleteButton.setEnabled(true);
                FieldValuesDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = FieldValuesDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            if (FieldValuesDialog.this.table.getSelectedRow() == -1) {
                Assert.That(false, "Delete button clicked when no row was selected");
                return;
            }
            FieldValuesDialog.this.table.deleteSelectedRowWithoutWarning();
            FieldValuesDialog.this.deleteButton.setEnabled(false);
            FieldValuesDialog.this.duplicateButton.setEnabled(false);
        }
    }

    class ValuesTableSelectionListener
    implements ListSelectionListener {
        ValuesTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = FieldValuesDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                FieldValuesDialog.this.deleteButton.setEnabled(false);
                FieldValuesDialog.this.duplicateButton.setEnabled(false);
            } else {
                FieldValuesDialog.this.deleteButton.setEnabled(true);
                FieldValuesDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }
}

