/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.gui.Desktop;
import cpusim.gui.EditDialog;
import cpusim.gui.LangUnit;
import cpusim.util.Assert;
import cpusim.util.Convert;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import cpusim.util.RegisterRAMPair;
import cpusim.util.RegisterRAMPairFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class HighlightOptionsDialog
extends EditDialog {
    private RegisterRAMPairFactory currentFactory;
    private Desktop desktop;

    public HighlightOptionsDialog(Frame parent) {
        super(parent, LangUnit.LU_HIGHLIGHT_OPT.str(), true);
        this.desktop = (Desktop)parent;
        Container contentPane = this.getContentPane();
        this.machine = this.desktop.getMachine();
        this.currentFactory = new RegisterRAMPairFactory(this.desktop);
        this.currentFactory.setParentFrame(this);
        contentPane.add((Component)this.createRegisterRAMPairsPanel(), "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
        if (this.machine.getAllRegisters().size() == 0 || this.machine.getModule("rams").size() == 0) {
            this.newButton.setEnabled(false);
        }
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.currentFactory;
    }

    @Override
    protected void updateMachine() {
        Vector pairs = Convert.toVector(this.getObjectList());
        this.desktop.getHighlightManager().setRegisterRAMPairs(pairs);
        if (this.desktop.getDebugToolBar().isVisible()) {
            this.desktop.getHighlightManager().highlightCellsAndText();
        }
    }

    private ExtendedJTable createExtendedJTable() {
        OOTableModel model = null;
        Object[] clones = (RegisterRAMPair[])this.currentFactory.createClones();
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"register", "ram", "dynamic"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, LangUnit.LU_EXCEPT_TAB_PAIR.str());
        }
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox registerCombo = new JComboBox(registers);
        editors.put("register", new DefaultCellEditor(registerCombo));
        Vector rams = this.machine.getModule("rams");
        JComboBox ramCombo = new JComboBox(rams);
        editors.put("ram", new DefaultCellEditor(ramCombo));
        ExtendedJTable rrPairTable = new ExtendedJTable((TableModel)model, editors);
        rrPairTable.setSelectionMode(0);
        rrPairTable.getSelectionModel().addListSelectionListener(new ExtendedTableSelectionListener());
        return rrPairTable;
    }

    private JPanel createNewDeleteDuplicateButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton(LangUnit.LU_NEW.str());
        this.newButton.setToolTipText(LangUnit.LU_CREATE_PAIR.str());
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(LangUnit.LU_DELETE.str());
        this.deleteButton.setToolTipText(LangUnit.LU_PAIR_DEL.str());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton(LangUnit.LU_DUPLICATE.str());
        this.duplicateButton.setToolTipText(LangUnit.LU_PAIR_DUP.str());
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return buttonPanel;
    }

    private JPanel createRegisterRAMPairsPanel() {
        JPanel rrPairsPanel = new JPanel();
        rrPairsPanel.setLayout(new BorderLayout());
        rrPairsPanel.add((Component)this.createNewDeleteDuplicateButtonPanel(), "South");
        this.table = this.createExtendedJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        rrPairsPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        rrPairsPanel.add((Component)new JScrollPane(this.table), "Center");
        rrPairsPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return rrPairsPanel;
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = HighlightOptionsDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            if (HighlightOptionsDialog.this.table.getSelectedRow() == -1) {
                Assert.That(false, LangUnit.LU_DEL_NONE.str());
                return;
            }
            HighlightOptionsDialog.this.table.deleteSelectedRowWithoutWarning();
            HighlightOptionsDialog.this.deleteButton.setEnabled(false);
            HighlightOptionsDialog.this.duplicateButton.setEnabled(false);
        }
    }

    class ExtendedTableSelectionListener
    implements ListSelectionListener {
        ExtendedTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = HighlightOptionsDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                HighlightOptionsDialog.this.deleteButton.setEnabled(false);
                HighlightOptionsDialog.this.duplicateButton.setEnabled(false);
            } else {
                HighlightOptionsDialog.this.deleteButton.setEnabled(true);
                HighlightOptionsDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }
}

