/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Module;
import cpusim.util.Assert;
import java.math.BigInteger;

public class Register
extends Module {
    private long value = 0L;
    private int width;

    public Register(String name, int width) {
        super(name);
        this.setWidth(width);
    }

    public int getWidth() {
        return this.width;
    }

    public long getValue() {
        return this.value;
    }

    public void setWidth(int w) {
        Assert.That(w > 0, "Register.setWidth() called with a parameter <= 0");
        if (w < this.width) {
            this.setValue(0L);
        }
        this.width = w;
    }

    public void setValue(long newValue) {
        BigInteger max = BigInteger.valueOf(2L).pow(this.width - 1);
        BigInteger newBigValue = BigInteger.valueOf(newValue);
        Assert.That(max.negate().compareTo(newBigValue) <= 0 && newBigValue.compareTo(max.shiftLeft(1).subtract(BigInteger.ONE)) <= 0, "Attempt to set value of register " + this.getName() + " to value " + newValue + " which is out of range.");
        long oldValue = this.value;
        this.value = newValue;
        this.getChangeSupport().firePropertyChange("value", oldValue, this.value);
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getWidth() + "</TD></TR>";
    }

    @Override
    public String getXMLDescription() {
        return "<Register name=\"" + this.getHTMLName() + "\" width=\"" + this.getWidth() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public Object clone() {
        return new Register(this.getName(), this.width);
    }

    public void clear() {
        this.setValue(0L);
    }

    @Override
    public void copyDataTo(Module comp) {
        Assert.That(comp instanceof Register, "Passed non-Register to Register.copyDataTo()");
        Register newRegister = (Register)comp;
        newRegister.setName(this.getName());
        newRegister.setWidth(this.width);
    }
}

