/*
 * Decompiled with CFR 0.152.
 */
package cpusim.scrollabledesktop;

import cpusim.gui.LangUnit;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.scrollabledesktop.BaseMenuItem;
import cpusim.scrollabledesktop.BaseRadioButtonMenuItem;
import cpusim.scrollabledesktop.DesktopMediator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class DesktopMenu
extends JMenu
implements ActionListener {
    private DesktopMediator desktopMediator;
    private boolean tileMode;
    private int baseItemsEndIndex;
    private ButtonGroup frameRadioButtonMenuItemGroup;

    public DesktopMenu(DesktopMediator desktopMediator) {
        this(desktopMediator, false);
    }

    public DesktopMenu(DesktopMediator desktopMediator, boolean tileMode) {
        super(LangUnit.LU_TEXT.str());
        this.setMnemonic(84);
        this.desktopMediator = desktopMediator;
        this.tileMode = tileMode;
        this.frameRadioButtonMenuItemGroup = new ButtonGroup();
        this.add(new BaseMenuItem(this, LangUnit.LU_TILE.str(), 76, -1));
        this.add(new BaseMenuItem(this, LangUnit.LU_CASCADE.str(), 65, -1));
        this.addSeparator();
        this.baseItemsEndIndex = this.getItemCount();
    }

    public void add(BaseInternalFrame associatedFrame) {
        int displayedCount = this.getItemCount() - this.baseItemsEndIndex + 1;
        int currentMenuCount = displayedCount;
        if (currentMenuCount > 9) {
            currentMenuCount /= 10;
        }
        BaseRadioButtonMenuItem menuButton = new BaseRadioButtonMenuItem(this, displayedCount + " " + associatedFrame.getTitle(), 48 + currentMenuCount, -1, true, associatedFrame, false);
        associatedFrame.setAssociatedMenuButton(menuButton);
        this.add(menuButton);
        this.frameRadioButtonMenuItemGroup.add(menuButton);
        menuButton.setSelected(true);
    }

    public void remove(JRadioButtonMenuItem menuButton) {
        this.frameRadioButtonMenuItemGroup.remove(menuButton);
        super.remove(menuButton);
        this.refreshMenu();
    }

    private void refreshMenu() {
        Enumeration<AbstractButton> e = this.frameRadioButtonMenuItemGroup.getElements();
        int displayedCount = 1;
        int currentMenuCount = 0;
        while (e.hasMoreElements()) {
            BaseRadioButtonMenuItem b = (BaseRadioButtonMenuItem)e.nextElement();
            currentMenuCount = displayedCount;
            if (currentMenuCount > 9) {
                currentMenuCount /= 10;
            }
            b.setMnemonic(48 + currentMenuCount);
            b.setText(displayedCount + " " + b.getAssociatedFrame().getTitle());
            ++displayedCount;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.desktopMediator.actionPerformed(e);
    }
}

