/*
 * Decompiled with CFR 0.152.
 */
package cpusim.syntax;

import cpusim.syntax.SyntaxStyle;
import cpusim.syntax.SyntaxToken;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class SyntaxUtilities {
    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length = offset + match.length();
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static SyntaxStyle[] getSyntaxStyles(int styleIndex) {
        SyntaxStyle[] styles = new SyntaxStyle[11];
        switch (styleIndex) {
            case 0: {
                styles[0] = new SyntaxStyle(Color.black, false, false);
                styles[5] = new SyntaxStyle(new Color(0x411134), false, true);
                styles[6] = new SyntaxStyle(new Color(204), false, true);
                styles[1] = new SyntaxStyle(new Color(0x888888), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 1: {
                styles[5] = new SyntaxStyle(new Color(6904269), false, true);
                styles[6] = new SyntaxStyle(new Color(102), false, true);
                styles[1] = new SyntaxStyle(new Color(3619071), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 2: {
                styles[5] = new SyntaxStyle(new Color(44851), false, true);
                styles[6] = new SyntaxStyle(new Color(2186785), false, true);
                styles[1] = new SyntaxStyle(new Color(6700346), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 3: {
                styles[5] = new SyntaxStyle(new Color(15627776), false, true);
                styles[6] = new SyntaxStyle(new Color(9057807), false, true);
                styles[1] = new SyntaxStyle(new Color(9859156), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 4: {
                styles[5] = new SyntaxStyle(new Color(13439094), false, true);
                styles[6] = new SyntaxStyle(new Color(7934637), false, true);
                styles[1] = new SyntaxStyle(new Color(9333390), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 5: {
                styles[5] = new SyntaxStyle(new Color(3186832), false, true);
                styles[6] = new SyntaxStyle(new Color(5645228), false, true);
                styles[1] = new SyntaxStyle(new Color(11346536), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
                break;
            }
            case 6: {
                styles[5] = new SyntaxStyle(new Color(1597022), false, true);
                styles[6] = new SyntaxStyle(new Color(11161666), false, true);
                styles[1] = new SyntaxStyle(new Color(5868562), true, false);
                styles[10] = new SyntaxStyle(Color.red, false, true);
            }
        }
        return styles;
    }

    public static int paintSyntaxLine(Segment line, SyntaxToken tokens, SyntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
            line.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    private SyntaxUtilities() {
    }
}

