/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.data.JAXB;

import gen.core.tmx14.Tuv;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.util.ReflectionUtil;

public class JAXBTuv
implements ITuv {
    public static final JAXBTuv EMPTY_TUV = new JAXBTuv(null);
    private static final char TAG_START_CHAR = '\ue101';
    private static final char TAG_END_CHAR = '\ue102';
    private final Tuv tuv;
    private Map<String, String> props;

    public JAXBTuv(Tuv tuv) {
        this.tuv = tuv;
    }

    @Override
    public String getContent() {
        if (this.tuv == null) {
            return null;
        }
        List content = this.tuv.getSeg().getContent();
        return content.isEmpty() ? "" : this.extractContent(content);
    }

    private String extractContent(List<Object> content) {
        StringBuilder tmp = new StringBuilder();
        for (Object o : content) {
            if (o instanceof String) {
                tmp.append((String)o);
                continue;
            }
            try {
                Method m = o.getClass().getDeclaredMethod("getContent", new Class[0]);
                if (m == null) {
                    throw new RuntimeException("TUV contained item that didn't respond to getContent().");
                }
                Object subContent = m.invoke(o, new Object[0]);
                if (!(subContent instanceof List)) {
                    throw new RuntimeException("TUV contained item that didn't return a List from getContent().");
                }
                tmp.append('\ue101');
                tmp.append(this.extractContent((List)subContent));
                tmp.append('\ue102');
            }
            catch (NoSuchMethodException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {}
        }
        return tmp.toString();
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.props == null) {
            if (this.tuv == null) {
                this.props = Collections.EMPTY_MAP;
            } else {
                Map<String, String> temp = ReflectionUtil.simplePropsToMap(this.tuv);
                temp.putAll(ReflectionUtil.listPropsToMap(this.tuv.getNoteOrProp()));
                this.props = Collections.unmodifiableMap(temp);
            }
        }
        return this.props;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JAXBTuv other = (JAXBTuv)obj;
        if (this.tuv == null) {
            return other.getContent() == null;
        }
        return this.getContent().equals(other.getContent()) && this.getLanguage().equals(other.getLanguage()) && this.tuv.getNoteOrProp().equals(this.tuv.getNoteOrProp());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.tuv != null ? this.tuv.hashCode() : 0);
        hash = 19 * hash + (this.getLanguage() != null ? this.getLanguage().hashCode() : 0);
        hash = 19 * hash + (this.tuv.getNoteOrProp() != null ? this.tuv.getNoteOrProp().hashCode() : 0);
        return hash;
    }

    @Override
    public Object getUnderlyingRepresentation() {
        return this.tuv;
    }

    @Override
    public String getLanguage() {
        if (this.tuv == null) {
            return null;
        }
        return JAXBTuv.getLanguage(this.tuv);
    }

    public static String getLanguage(Tuv tuv) {
        if (tuv.getLang() != null) {
            return tuv.getLang();
        }
        return tuv.getXmlLang();
    }

    @Override
    public boolean equivalentTo(ITuv other) {
        return false;
    }
}

