/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Unifier;

public abstract class AbstractPatternRule
extends Rule {
    protected final Language language;
    protected final List<Element> patternElements;
    protected final boolean testUnification;
    protected final boolean sentStart;
    protected String subId;
    protected Unifier unifier;
    protected AnalyzedTokenReadings[] unifiedTokens;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    protected boolean prevMatched;
    private final String id;
    private final String description;
    private final boolean getUnified;
    private boolean groupsOrUnification;

    public AbstractPatternRule(String id, String description, Language language, List<Element> elements, boolean getUnified) {
        this.id = id;
        this.description = description;
        this.patternElements = new ArrayList<Element>(elements);
        this.language = language;
        this.getUnified = getUnified;
        this.unifier = language.getUnifier();
        this.testUnification = this.initUnifier();
        boolean bl = this.sentStart = this.patternElements.size() > 0 && this.patternElements.get(0).isSentStart();
        if (!this.testUnification) {
            for (Element elem : this.patternElements) {
                if (!elem.hasAndGroup()) continue;
                this.groupsOrUnification = true;
                break;
            }
        } else {
            this.groupsOrUnification = true;
        }
    }

    private boolean initUnifier() {
        for (Element elem : this.patternElements) {
            if (!elem.isUnified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id + "[" + this.subId + "]:" + this.patternElements + ":" + this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) throws IOException {
        return null;
    }

    @Override
    public void reset() {
    }

    public final void setStartPositionCorrection(int startPositionCorrection) {
        this.startPositionCorrection = startPositionCorrection;
    }

    public final int getStartPositionCorrection() {
        return this.startPositionCorrection;
    }

    public final void setEndPositionCorrection(int endPositionCorrection) {
        this.endPositionCorrection = endPositionCorrection;
    }

    public final int getEndPositionCorrection() {
        return this.endPositionCorrection;
    }

    public final String getSubId() {
        return this.subId;
    }

    public final void setSubId(String subId) {
        this.subId = subId;
    }

    protected void setupAndGroup(int firstMatchToken, Element elem, AnalyzedTokenReadings[] tokens) throws IOException {
        if (elem.hasAndGroup()) {
            for (Element andElement : elem.getAndGroup()) {
                if (!andElement.isReferenceElement()) continue;
                this.setupRef(firstMatchToken, andElement, tokens);
            }
            elem.setupAndGroup();
        }
    }

    protected void setupRef(int firstMatchToken, Element elem, AnalyzedTokenReadings[] tokens) throws IOException {
        int refPos;
        if (elem.isReferenceElement() && (refPos = firstMatchToken + elem.getMatch().getTokenRef()) < tokens.length) {
            elem.compile(tokens[refPos], this.language.getSynthesizer());
        }
    }

    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, Element elem, Element prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        int l;
        boolean thisMatched = false;
        int numberOfReadings = tokens[tokenNo].getReadingsLength();
        this.setupAndGroup(firstMatchToken, elem, tokens);
        for (l = 0; l < numberOfReadings; ++l) {
            AnalyzedToken matchToken = tokens[tokenNo].getAnalyzedToken(l);
            boolean bl = this.prevMatched = this.prevMatched || prevSkipNext > 0 && prevElement != null && prevElement.isMatchedByScopeNextException(matchToken);
            if (this.prevMatched) {
                return false;
            }
            boolean bl2 = thisMatched = thisMatched || elem.isMatched(matchToken);
            if (!thisMatched && !elem.isInflected() && elem.getPOStag() == null && prevElement != null && prevElement.getExceptionList() == null) {
                return false;
            }
            if (!this.groupsOrUnification) continue;
            thisMatched &= this.testUnificationAndGroups(thisMatched, l + 1 == numberOfReadings, matchToken, elem);
        }
        if (thisMatched) {
            for (l = 0; l < numberOfReadings; ++l) {
                if (!elem.isExceptionMatchedCompletely(tokens[tokenNo].getAnalyzedToken(l))) continue;
                return false;
            }
            if (tokenNo > 0 && elem.hasPreviousException() && elem.isMatchedByPreviousException(tokens[tokenNo - 1])) {
                return false;
            }
        }
        return thisMatched;
    }

    protected boolean testUnificationAndGroups(boolean matched, boolean lastReading, AnalyzedToken matchToken, Element elem) {
        boolean thisMatched = matched;
        boolean elemIsMatched = elem.isMatched(matchToken);
        if (this.testUnification) {
            if (matched && elem.isUnified()) {
                if (elem.isUniNegated()) {
                    thisMatched = !thisMatched || !this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else if (elem.isLastInUnification()) {
                    thisMatched = thisMatched && this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else {
                    this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                }
            }
            if (thisMatched && this.getUnified) {
                this.unifiedTokens = this.unifier.getFinalUnified();
            }
            if (!elem.isUnified()) {
                this.unifier.reset();
            }
        }
        elem.addMemberAndGroup(matchToken);
        if (lastReading) {
            thisMatched &= elem.checkAndGroup(thisMatched);
        }
        return thisMatched;
    }
}

