/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.util.FileUtil;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXReader2;

public class ExternalTMX {
    private final String name;
    private final List<PrepareTMXEntry> entries;

    public ExternalTMX(final ProjectProperties props, File file, boolean extTmxLevel2, boolean useSlash) throws Exception {
        this.name = file.getName();
        this.entries = new ArrayList<PrepareTMXEntry>();
        TMXReader2.LoadCallback loader = new TMXReader2.LoadCallback(){

            @Override
            public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                if (tuvSource == null) {
                    return false;
                }
                if (tuvTarget != null) {
                    this.addTuv(tu, tuvSource, tuvTarget, isParagraphSegtype);
                } else {
                    for (int i = 0; i < tu.tuvs.size(); ++i) {
                        if (tu.tuvs.get(i) == tuvSource) continue;
                        this.addTuv(tu, tuvSource, tu.tuvs.get(i), isParagraphSegtype);
                    }
                }
                return true;
            }

            private void addTuv(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                String changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                String creator = StringUtil.nvl(tuvTarget.creationid, tu.creationid);
                long changed = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                long created = StringUtil.nvlLong(tuvTarget.creationdate, tu.creationdate);
                ArrayList<String> sources = new ArrayList<String>();
                ArrayList<String> targets = new ArrayList<String>();
                Segmenter.segmentEntries(props.isSentenceSegmentingEnabled() && isParagraphSegtype, props.getSourceLanguage(), tuvSource.text, props.getTargetLanguage(), tuvTarget.text, sources, targets);
                for (int i = 0; i < sources.size(); ++i) {
                    PrepareTMXEntry te = new PrepareTMXEntry();
                    te.source = (String)sources.get(i);
                    te.translation = (String)targets.get(i);
                    te.changer = changer;
                    te.changeDate = changed;
                    te.creator = creator;
                    te.creationDate = created;
                    te.note = tu.note;
                    te.otherProperties = tu.props;
                    ExternalTMX.this.entries.add(te);
                }
            }
        };
        TMXReader2 reader = new TMXReader2();
        reader.readTMX(file, props.getSourceLanguage(), props.getTargetLanguage(), props.isSentenceSegmentingEnabled(), false, extTmxLevel2, useSlash, loader);
    }

    public String getName() {
        return this.name;
    }

    public List<PrepareTMXEntry> getEntries() {
        return this.entries;
    }

    public static boolean isInPath(File path, File tmxFile) {
        try {
            FileUtil.computeRelativePath(path, tmxFile);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

