/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.LingvoDSL;
import org.omegat.core.dictionaries.StarDict;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;

public class DictionariesManager
implements DirectoryMonitor.Callback {
    public static final String IGNORE_FILE = "ignore.txt";
    protected DirectoryMonitor monitor;
    protected final Map<String, DictionaryInfo> infos = new TreeMap<String, DictionaryInfo>();
    private final IDictionaries pane;
    protected static String DICTIONARY_SUBDIR = "dictionary";
    protected final Set<String> ignoreWords = new TreeSet<String>();

    public DictionariesManager(IDictionaries pane) {
        this.pane = pane;
    }

    public void start(String dictDir) {
        File dir = new File(dictDir);
        this.monitor = new DirectoryMonitor(dir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            this.infos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        String fn = file.getPath();
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            this.infos.remove(fn);
        }
        if (file.exists()) {
            try {
                IDictionary dict;
                long st = System.currentTimeMillis();
                if (file.getName().equals(IGNORE_FILE)) {
                    this.loadIgnoreWords(file);
                } else if (fn.endsWith(".ifo")) {
                    dict = new StarDict(file);
                    Map<String, Object> header = dict.readHeader();
                    DictionariesManager dictionariesManager2 = this;
                    synchronized (dictionariesManager2) {
                        this.infos.put(fn, new DictionaryInfo(dict, header));
                    }
                } else if (fn.endsWith(".dsl")) {
                    dict = new LingvoDSL(file);
                    Map<String, Object> header = dict.readHeader();
                    DictionariesManager dictionariesManager3 = this;
                    synchronized (dictionariesManager3) {
                        this.infos.put(fn, new DictionaryInfo(dict, header));
                    }
                } else {
                    fn = null;
                }
                if (fn != null) {
                    long en = System.currentTimeMillis();
                    Log.log("Loaded dictionary from '" + fn + "': " + (en - st) + "ms");
                }
            }
            catch (Exception ex) {
                Log.log("Error load dictionary from '" + fn + "': " + ex.getMessage());
            }
        }
        this.pane.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIgnoreWords(File f) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        try {
            Set<String> set = this.ignoreWords;
            synchronized (set) {
                String line;
                this.ignoreWords.clear();
                while ((line = rd.readLine()) != null) {
                    this.ignoreWords.add(line.trim());
                }
            }
        }
        finally {
            rd.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreWord(String word) {
        List<String> words = Collections.emptyList();
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            this.ignoreWords.add(word);
            words = new ArrayList<String>(this.ignoreWords);
        }
        this.saveIgnoreWords(words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveIgnoreWords(Collection<String> words) {
        if (this.monitor == null) {
            Log.log("Could not save ignore words because no dictionary dir has been set.");
            return;
        }
        try {
            File outFile = new File(this.monitor.getDir(), IGNORE_FILE);
            File outFileTmp = new File(this.monitor.getDir(), "ignore.txt.new");
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTmp), "UTF-8"));
            try {
                for (String w : words) {
                    wr.write(w + System.getProperty("line.separator"));
                }
                wr.flush();
            }
            finally {
                wr.close();
            }
            outFile.delete();
            FileUtil.rename(outFileTmp, outFile);
        }
        catch (Exception ex) {
            Log.log("Error saving ignore words: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DictionaryEntry> findWords(Collection<String> words) {
        ArrayList<DictionaryInfo> dicts;
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            dicts = new ArrayList<DictionaryInfo>(this.infos.values());
        }
        ArrayList<DictionaryEntry> result = new ArrayList<DictionaryEntry>();
        for (String word : words) {
            for (DictionaryInfo di : dicts) {
                try {
                    Set<String> set = this.ignoreWords;
                    synchronized (set) {
                        if (this.ignoreWords.contains(word)) {
                            continue;
                        }
                    }
                    Object data = di.info.get(word);
                    if (data == null) {
                        String lowerCaseWord = word.toLowerCase();
                        Set<String> set2 = this.ignoreWords;
                        synchronized (set2) {
                            if (this.ignoreWords.contains(lowerCaseWord)) {
                                continue;
                            }
                        }
                        data = di.info.get(lowerCaseWord);
                    }
                    if (data == null) continue;
                    if (data.getClass().isArray()) {
                        for (Object d : (Object[])data) {
                            String a = di.dict.readArticle(word, d);
                            result.add(new DictionaryEntry(word, a));
                        }
                        continue;
                    }
                    String a = di.dict.readArticle(word, data);
                    result.add(new DictionaryEntry(word, a));
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
        return result;
    }

    protected static class DictionaryInfo {
        public final IDictionary dict;
        public final Map<String, Object> info;

        public DictionaryInfo(IDictionary dict, Map<String, Object> info) {
            this.dict = dict;
            this.info = info;
        }
    }
}

