/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.dict.zip.DictZipHeader;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.util.LFileCopy;

public class StarDict
implements IDictionary {
    protected static final int BUFFER_SIZE = 65536;
    protected final File ifoFile;
    protected final String contentType;
    private DictZipHeader fHeader;
    private DictType dictType;
    private String dictName;
    private String dataFile;

    public StarDict(File ifoFile) throws Exception {
        this.ifoFile = ifoFile;
        Map<String, String> header = this.readIFO(ifoFile);
        String version = header.get("version");
        if (!"2.4.2".equals(version) && !"3.0.0".equals(version)) {
            throw new Exception("Invalid version of dictionary: " + version);
        }
        this.contentType = header.get("sametypesequence");
        if (!("g".equals(this.contentType) || "m".equals(this.contentType) || "x".equals(this.contentType) || "h".equals(this.contentType))) {
            throw new Exception("Invalid type of dictionary: " + this.contentType);
        }
        String f = ifoFile.getPath();
        if (f.endsWith(".ifo")) {
            f = f.substring(0, f.length() - ".ifo".length());
        }
        this.dictName = f;
        String dzFile = f + ".dict.dz";
        if (new File(dzFile).isFile()) {
            this.dictType = DictType.DICTZIP;
            this.dataFile = dzFile;
        } else {
            String dictFile = f + ".dict";
            if (!new File(dictFile).isFile()) {
                throw new FileNotFoundException("No .dict.dz or .dict files were found for " + this.dictName);
            }
            this.dictType = DictType.DICTFILE;
            this.dataFile = dictFile;
        }
    }

    @Override
    public Map<String, Object> readHeader() throws IOException {
        int b;
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = new File(this.dictName + ".idx");
        byte[] idxBytes = this.readFile(file);
        DataInputStream idx = new DataInputStream(new ByteArrayInputStream(idxBytes));
        ByteArrayOutputStream mem = new ByteArrayOutputStream();
        while ((b = idx.read()) != -1) {
            if (b == 0) {
                String key = new String(mem.toByteArray(), 0, mem.size(), "UTF-8");
                mem.reset();
                int bodyOffset = idx.readInt();
                int bodyLength = idx.readInt();
                this.addIndex(key, bodyOffset, bodyLength, result);
                continue;
            }
            mem.write(b);
        }
        return result;
    }

    private void addIndex(String key, int start, int len, Map<String, Object> result) {
        Entry[] data = result.get(key);
        if (data == null) {
            Entry d = new Entry(start, len);
            data = d;
        } else if (data instanceof Entry[]) {
            Entry[] dobj = data;
            Entry[] d = new Entry[dobj.length + 1];
            System.arraycopy(dobj, 0, d, 0, dobj.length);
            d[d.length - 1] = new Entry(start, len);
            data = d;
        } else {
            Entry[] d = new Entry[]{(Entry)data, new Entry(start, len)};
            data = d;
        }
        result.put(key, data);
    }

    @Override
    public String readArticle(String word, Object data) {
        Entry dictData = (Entry)data;
        return dictData.getArticle();
    }

    private synchronized String readArticle(int start, int len) {
        switch (this.dictType) {
            case DICTFILE: {
                return this.readDictArticleText(start, len);
            }
            case DICTZIP: {
                return this.readDictZipArticleText(start, len);
            }
        }
        throw new RuntimeException("Unknown StarDict dictionary type: " + (Object)((Object)this.dictType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDictArticleText(int start, int len) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.dataFile);
            byte[] data = new byte[len];
            in.skip(start);
            in.read(data);
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (IOException e) {
            System.err.println(e);
            String string = null;
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
            in = null;
        }
    }

    private DictZipHeader getDZHeader(DictZipInputStream din) throws IOException {
        if (this.fHeader == null) {
            this.fHeader = din.readHeader();
        }
        return this.fHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDictZipArticleText(int start, int len) {
        RandomAccessInputStream in = null;
        DictZipInputStream din = null;
        try {
            in = new RandomAccessInputStream(this.dataFile, "r");
            din = new DictZipInputStream(in);
            DictZipHeader h = this.getDZHeader(din);
            int off = h.getOffset(start);
            int pos = h.getPosition(start);
            in.seek(pos);
            byte[] b = new byte[off + len];
            din.readFully(b);
            byte[] data = new byte[len];
            System.arraycopy(b, off, data, 0, len);
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (IOException e) {
            System.err.println(e);
            String string = null;
            return string;
        }
        finally {
            try {
                din.close();
                in.close();
            }
            catch (Throwable t) {}
            din = null;
            in = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        FilterInputStream in;
        if (file.exists()) {
            in = new BufferedInputStream(new FileInputStream(file), 65536);
        } else {
            File gzFile = new File(file.getPath() + ".gz");
            if (gzFile.exists()) {
                in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(gzFile), 65536));
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
        try {
            LFileCopy.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readIFO(File ifoFile) throws Exception {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ifoFile), "UTF-8"));
        try {
            String line = null;
            String first = rd.readLine();
            if (!"StarDict's dict ifo file".equals(first)) {
                throw new Exception("Invalid header of .ifo file: " + first);
            }
            TreeMap<String, String> result = new TreeMap<String, String>();
            while ((line = rd.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                int pos = line.indexOf(61);
                if (pos < 0) {
                    throw new Exception("Invalid format of .ifo file: " + line);
                }
                result.put(line.substring(0, pos), line.substring(pos + 1));
            }
            TreeMap<String, String> treeMap = result;
            return treeMap;
        }
        finally {
            rd.close();
        }
    }

    private class Entry {
        private volatile String cache;
        private final int start;
        private final int len;

        public Entry(int start, int len) {
            this.start = start;
            this.len = len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getArticle() {
            String article = this.cache;
            if (article == null) {
                Entry entry = this;
                synchronized (entry) {
                    article = this.cache;
                    if (article == null) {
                        article = this.cache = this.loadArticle();
                    }
                }
            }
            return article;
        }

        private String loadArticle() {
            return StarDict.this.readArticle(this.start, this.len).replace("\n", "<br>");
        }
    }

    public static enum DictType {
        DICTZIP,
        DICTFILE;

    }
}

