/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.Core;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.WikiGet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMyMemoryTranslate
extends BaseTranslate {
    private static final String MYMEMORY_API_EMAIL = "mymemory.api.email";
    protected static String GT_URL = "http://mymemory.translated.net/api/get?q=";
    protected static String MYMEMORYLABEL_TRANSLATION = "translation";
    protected static String MYMEMORYLABEL_MATCHQUALITYPERCENTAGE = "match";
    protected static String XPATH_QUERY = "child::tuv[starts-with(@lang, '#langCode#')]/seg/text()";
    protected final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected final XPathFactory xPathFactory = XPathFactory.newInstance();

    @Override
    protected abstract String getPreferenceName();

    @Override
    public abstract String getName();

    protected String mymemoryCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        return lCode;
    }

    @Override
    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    protected String getBestTranslation(Language sLang, Language tLang, String text, XPath xpath, NodeList allTUs) throws XPathExpressionException {
        int lowestEditDistance = 999999;
        int dist = 0;
        Node tu = null;
        String sourceSeg = "";
        String targetSeg = "";
        String targetSegQueryString = XPATH_QUERY.replace("#langCode#", tLang.getLanguageCode());
        String sourceSegQueryString = XPATH_QUERY.replace("#langCode#", sLang.getLanguageCode());
        String bestTranslation = "";
        for (int i = 0; i < allTUs.getLength(); ++i) {
            tu = allTUs.item(i);
            sourceSeg = xpath.evaluate(sourceSegQueryString, tu);
            targetSeg = xpath.evaluate(targetSegQueryString, tu);
            Locale srcLoc = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
            dist = this.getLevensteinDistance(text.toLowerCase(srcLoc), sourceSeg.toLowerCase(srcLoc));
            if (dist < lowestEditDistance && !sourceSeg.isEmpty() && !targetSeg.isEmpty()) {
                lowestEditDistance = dist;
                bestTranslation = targetSeg;
            }
            if (dist == 0) break;
        }
        bestTranslation = this.cleanUpText(bestTranslation);
        return bestTranslation;
    }

    protected String cleanUpText(String str) {
        str = str.replace("&quot;", "\"");
        str = str.replace("&nbsp;", "\u00a0");
        str = str.replace("&amp;", "&");
        str = str.replace("&apos;", "'");
        str = str.replace("&#39;", "'");
        str = str.replace("&lt;", "<");
        str = str.replace("&gt;", ">");
        str = str.trim();
        return str;
    }

    private int getLevensteinDistance(String text, String sourceSeg) {
        LevenshteinDistance leven = new LevenshteinDistance();
        ITokenizer srcTokenizer = Core.getProject().getSourceTokenizer();
        Token[] textTokenArray = srcTokenizer.tokenizeVerbatim(text);
        Token[] sourceSegTokenArray = srcTokenizer.tokenizeVerbatim(sourceSeg);
        int dist = leven.compute(textTokenArray, sourceSegTokenArray);
        return dist;
    }

    protected String getMyMemoryResponse(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException, IOException {
        String url = this.buildMyMemoryUrl(sLang, tLang, text, format);
        String email = System.getProperty(MYMEMORY_API_EMAIL);
        if (!StringUtil.isEmpty(email)) {
            url = url + "&de=" + email;
        }
        String myMemoryResponse = "";
        myMemoryResponse = WikiGet.getURL(url);
        return myMemoryResponse;
    }

    protected abstract String buildMyMemoryUrl(Language var1, Language var2, String var3, String var4) throws UnsupportedEncodingException;

    protected String getXMLString(String str) {
        int XMLHeader = str.indexOf("<?xml");
        if (XMLHeader != -1) {
            str = str.substring(XMLHeader);
        }
        return str;
    }
}

