/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

public class CalcStandardStatistics
extends LongProcessThread {
    private static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters"), OStrings.getString("CT_STATS_Files")};
    private static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Remaining"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Unique_Remaining")};
    private static final boolean[] htAlign = new boolean[]{false, true, true, true, true, true};
    private static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Total_Words"), OStrings.getString("CT_STATS_FILE_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Unique_Words"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Total_Characters"), OStrings.getString("CT_STATS_FILE_Remaining_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters")};
    private static final boolean[] ftAlign = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private final StatisticsPanel callback;

    public CalcStandardStatistics(StatisticsPanel callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        String result = CalcStandardStatistics.buildProjectStats(p, null, this.callback);
        this.callback.setTextData(result);
        this.callback.finishData();
        String internalDir = p.getProjectProperties().getProjectInternal();
        try {
            File oldstats = new File(internalDir + "word_counts");
            if (oldstats.exists()) {
                oldstats.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String fn = internalDir + "project_stats.txt";
        Statistics.writeStat(fn, result);
        this.callback.setDataFile(fn);
    }

    public static String buildProjectStats(IProject project, StatisticsInfo hotStat) {
        return CalcStandardStatistics.buildProjectStats(project, hotStat, null);
    }

    public static String buildProjectStats(IProject project, StatisticsInfo hotStat, StatisticsPanel callback) {
        StatCount total = new StatCount();
        StatCount remaining = new StatCount();
        StatCount unique = new StatCount();
        StatCount remainingUnique = new StatCount();
        HashMap<String, SourceTextEntry> uniqueSegment = new HashMap<String, SourceTextEntry>();
        HashSet<String> translated = new HashSet<String>();
        for (SourceTextEntry ste : project.getAllEntries()) {
            TMXEntry tr;
            String src = ste.getSrcText();
            for (ProtectedPart pp : ste.getProtectedParts()) {
                src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
            }
            if (!uniqueSegment.containsKey(src)) {
                uniqueSegment.put(src, ste);
            }
            if (!(tr = project.getTranslationInfo(ste)).isTranslated()) continue;
            translated.add(src);
        }
        HashSet<String> filesUnique = new HashSet<String>();
        HashSet<String> filesRemainingUnique = new HashSet<String>();
        for (Map.Entry en : uniqueSegment.entrySet()) {
            StatCount count = new StatCount((SourceTextEntry)en.getValue());
            unique.add(count);
            filesUnique.add(((SourceTextEntry)en.getValue()).getKey().file);
            if (translated.contains(en.getKey())) continue;
            remainingUnique.add(count);
            filesRemainingUnique.add(((SourceTextEntry)en.getValue()).getKey().file);
        }
        unique.addFiles(filesUnique.size());
        remainingUnique.addFiles(filesRemainingUnique.size());
        ArrayList<FileData> counts = new ArrayList<FileData>();
        HashMap<String, Boolean> firstSeenUniqueSegment = new HashMap<String, Boolean>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            FileData numbers = new FileData();
            numbers.filename = file.filePath;
            counts.add(numbers);
            int fileTotal = 0;
            int fileRemaining = 0;
            for (SourceTextEntry ste : file.entries) {
                String src = ste.getSrcText();
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
                }
                StatCount count = new StatCount(ste);
                total.add(count);
                fileTotal = 1;
                TMXEntry tr = project.getTranslationInfo(ste);
                if (!tr.isTranslated()) {
                    remaining.add(count);
                    fileRemaining = 1;
                }
                numbers.total.add(count);
                Boolean firstSeen = (Boolean)firstSeenUniqueSegment.get(src);
                if (firstSeen == null) {
                    firstSeenUniqueSegment.put(src, false);
                    numbers.unique.add(count);
                    if (!tr.isTranslated()) {
                        numbers.remainingUnique.add(count);
                    }
                }
                if (tr.isTranslated()) continue;
                numbers.remaining.add(count);
            }
            total.addFiles(fileTotal);
            remaining.addFiles(fileRemaining);
        }
        StringBuilder result = new StringBuilder();
        result.append(OStrings.getString("CT_STATS_Project_Statistics"));
        result.append("\n\n");
        String[][] headerTable = CalcStandardStatistics.calcHeaderTable(new StatCount[]{total, remaining, unique, remainingUnique});
        if (callback != null) {
            callback.setProjectTableData(htHeaders, headerTable);
        }
        result.append(TextUtil.showTextTable(htHeaders, headerTable, htAlign));
        result.append("\n\n");
        result.append(OStrings.getString("CT_STATS_FILE_Statistics"));
        result.append("\n\n");
        String[][] filesTable = CalcStandardStatistics.calcFilesTable(project.getProjectProperties(), counts);
        if (callback != null) {
            callback.setFilesTableData(ftHeaders, filesTable);
        }
        result.append(TextUtil.showTextTable(ftHeaders, filesTable, ftAlign));
        if (hotStat != null) {
            hotStat.numberOfSegmentsTotal = total.segments;
            hotStat.numberofTranslatedSegments = translated.size();
            hotStat.numberOfUniqueSegments = unique.segments;
            hotStat.uniqueCountsByFile.clear();
            for (FileData fd : counts) {
                hotStat.uniqueCountsByFile.put(fd.filename, fd.unique.segments);
            }
        }
        return result.toString();
    }

    protected static String[][] calcHeaderTable(StatCount[] result) {
        String[][] table = new String[result.length][6];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = htRows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
            table[i][5] = Integer.toString(result[i].files);
        }
        return table;
    }

    protected static String[][] calcFilesTable(ProjectProperties m_config, List<FileData> counts) {
        String[][] table = new String[counts.size()][17];
        int r = 0;
        for (FileData numbers : counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, m_config.getSourceRoot());
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.remaining.segments);
            table[r][3] = Integer.toString(numbers.unique.segments);
            table[r][4] = Integer.toString(numbers.remainingUnique.segments);
            table[r][5] = Integer.toString(numbers.total.words);
            table[r][6] = Integer.toString(numbers.remaining.words);
            table[r][7] = Integer.toString(numbers.unique.words);
            table[r][8] = Integer.toString(numbers.remainingUnique.words);
            table[r][9] = Integer.toString(numbers.total.charsWithoutSpaces);
            table[r][10] = Integer.toString(numbers.remaining.charsWithoutSpaces);
            table[r][11] = Integer.toString(numbers.unique.charsWithoutSpaces);
            table[r][12] = Integer.toString(numbers.remainingUnique.charsWithoutSpaces);
            table[r][13] = Integer.toString(numbers.total.charsWithSpaces);
            table[r][14] = Integer.toString(numbers.remaining.charsWithSpaces);
            table[r][15] = Integer.toString(numbers.unique.charsWithSpaces);
            table[r][16] = Integer.toString(numbers.remainingUnique.charsWithSpaces);
            ++r;
        }
        return table;
    }

    public static class FileData {
        public String filename;
        public StatCount total = new StatCount();
        public StatCount unique = new StatCount();
        public StatCount remaining = new StatCount();
        public StatCount remainingUnique = new StatCount();
    }
}

