/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.TMXProp;
import org.omegat.util.Token;

public class FindMatches {
    private static final int PENALTY_FOR_FUZZY = 20;
    private static final int PENALTY_FOR_REMOVED = 5;
    private static final int SUBSEGMENT_MATCH_THRESHOLD = 85;
    private static final boolean ALLOW_PARTIALY_MATCH = true;
    private final ISimilarityCalculator distance = new LevenshteinDistance();
    private final Pattern removePattern = PatternConsts.getRemovePattern();
    private final ITokenizer tok;
    private final Locale srcLocale;
    private final int maxCount;
    private List<NearString> result = new ArrayList<NearString>(6);
    private final boolean searchExactlyTheSame;
    private String originalText;
    private String srcText;
    private String removedText;
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;
    FindMatches separateSegmentMatcher;
    Map<String, Token[]> tokenizeStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeNoStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeAllCache = new HashMap<String, Token[]>();

    public FindMatches(ITokenizer sourceTokenizer, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this.tok = sourceTokenizer;
        this.srcLocale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        this.maxCount = maxCount;
        this.searchExactlyTheSame = searchExactlyTheSame;
        if (allowSeparateSegmentMatch) {
            this.separateSegmentMatcher = new FindMatches(sourceTokenizer, 1, false, true);
        }
    }

    public List<NearString> search(final IProject project, String searchText, final boolean requiresTranslation, boolean fillSimilarityData, final IStopped stop) throws StoppedException {
        this.result.clear();
        this.originalText = searchText;
        this.srcText = searchText;
        this.removedText = "";
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(this.srcText);
            while (removeMatcher.find()) {
                this.removedText = this.removedText + this.srcText.substring(removeMatcher.start(), removeMatcher.end());
            }
            this.srcText = removeMatcher.replaceAll("");
        }
        this.strTokensStem = this.tokenizeStem(this.srcText);
        this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
        this.strTokensAll = this.tokenizeAll(this.srcText);
        final String orphanedFileName = OStrings.getString("CT_ORPHAN_STRINGS");
        if (project.getProjectProperties().isSupportDefaultTranslations()) {
            project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

                @Override
                public void iterate(String source, TMXEntry trans) {
                    FindMatches.this.checkStopped(stop);
                    if (!FindMatches.this.searchExactlyTheSame && source.equals(FindMatches.this.originalText)) {
                        return;
                    }
                    if (requiresTranslation && trans.translation == null) {
                        return;
                    }
                    String fileName = project.isOrphaned(source) ? orphanedFileName : null;
                    FindMatches.this.processEntry(null, source, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, null);
                }
            });
        }
        project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            @Override
            public void iterate(EntryKey source, TMXEntry trans) {
                FindMatches.this.checkStopped(stop);
                if (!FindMatches.this.searchExactlyTheSame && source.sourceText.equals(FindMatches.this.originalText)) {
                    return;
                }
                if (requiresTranslation && trans.translation == null) {
                    return;
                }
                String fileName = project.isOrphaned(source) ? orphanedFileName : null;
                FindMatches.this.processEntry(source, source.sourceText, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, null);
            }
        });
        Pattern SEARCH_FOR_PENALTY = Pattern.compile("penalty-(\\d+)");
        for (Map.Entry<String, ExternalTMX> en : project.getTransMemories().entrySet()) {
            int penalty = 0;
            Matcher matcher = SEARCH_FOR_PENALTY.matcher(en.getKey());
            if (matcher.find()) {
                penalty = Integer.parseInt(matcher.group(1));
            }
            for (PrepareTMXEntry tmen : en.getValue().getEntries()) {
                this.checkStopped(stop);
                if (requiresTranslation && tmen.translation == null) continue;
                this.processEntry(null, tmen.source, tmen.translation, NearString.MATCH_SOURCE.TM, false, penalty, en.getKey(), tmen.creator, tmen.creationDate, tmen.changer, tmen.changeDate, tmen.otherProperties);
            }
        }
        for (SourceTextEntry ste : project.getAllEntries()) {
            this.checkStopped(stop);
            if (ste.getSourceTranslation() == null) continue;
            this.processEntry(ste.getKey(), ste.getSrcText(), ste.getSourceTranslation(), NearString.MATCH_SOURCE.MEMORY, ste.isSourceTranslationFuzzy(), 0, ste.getKey().file, "", 0L, "", 0L, null);
        }
        if (this.separateSegmentMatcher != null && !project.getProjectProperties().isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = project.getProjectProperties().getSourceLanguage();
            Language targetLang = project.getProjectProperties().getTargetLanguage();
            List<String> segments = Segmenter.segment(sourceLang, this.srcText, spaces, brules);
            if (segments.size() > 1) {
                ArrayList<String> fsrc = new ArrayList<String>(segments.size());
                ArrayList<String> ftrans = new ArrayList<String>(segments.size());
                for (int i = 0; i < segments.size(); i = (int)((short)(i + 1))) {
                    String onesrc = segments.get(i);
                    List<NearString> segmentMatch = this.separateSegmentMatcher.search(project, onesrc, requiresTranslation, false, stop);
                    if (!segmentMatch.isEmpty() && segmentMatch.get((int)0).scores[0].score >= 85) {
                        fsrc.add(segmentMatch.get((int)0).source);
                        ftrans.add(segmentMatch.get((int)0).translation);
                        continue;
                    }
                    fsrc.add("");
                    ftrans.add("");
                }
                String foundSrc = Segmenter.glue(sourceLang, sourceLang, fsrc, spaces, brules);
                String foundTrans = Segmenter.glue(sourceLang, targetLang, ftrans, spaces, brules);
                this.processEntry(null, foundSrc, foundTrans, NearString.MATCH_SOURCE.TM, false, 0, "", "", 0L, "", 0L, null);
            }
        }
        if (fillSimilarityData) {
            for (NearString near : this.result) {
                byte[] similarityData = FuzzyMatcher.buildSimilarityData(this.strTokensAll, this.tokenizeAll(near.source));
                near.attr = similarityData;
            }
        }
        return this.result;
    }

    protected void processEntry(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int penalty, String tmxName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> props) {
        String realSource = source;
        String entryRemovedText = "";
        int realPenaltyForRemoved = 0;
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(realSource);
            while (removeMatcher.find()) {
                entryRemovedText = entryRemovedText + source.substring(removeMatcher.start(), removeMatcher.end());
            }
            realSource = removeMatcher.replaceAll("");
            if (!entryRemovedText.equals(this.removedText)) {
                realPenaltyForRemoved = 5;
            }
        }
        Token[] candTokens = this.tokenizeStem(realSource);
        int similarityStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensStem, candTokens);
        similarityStem -= penalty;
        if (fuzzy) {
            similarityStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem -= realPenaltyForRemoved, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensNoStem = this.tokenizeNoStem(realSource);
        int similarityNoStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensNoStem, candTokensNoStem);
        similarityNoStem -= penalty;
        if (fuzzy) {
            similarityNoStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem -= realPenaltyForRemoved, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensAll = this.tokenizeAll(realSource);
        int simAdjusted = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensAll, candTokensAll);
        simAdjusted -= penalty;
        if (fuzzy) {
            simAdjusted -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem, simAdjusted -= realPenaltyForRemoved)) {
            return;
        }
        this.addNearString(key, source, translation, comesFrom, fuzzy, similarityStem, similarityNoStem, simAdjusted, null, tmxName, creator, creationDate, changer, changedDate, props);
    }

    protected boolean haveChanceToAdd(int simStem, int simNoStem, int simExactly) {
        if (simStem < 30 && simNoStem < 30) {
            return false;
        }
        if (this.result.size() < this.maxCount) {
            return true;
        }
        NearString st = this.result.get(this.result.size() - 1);
        int chance = this.checkScore(st.scores[0].score, simStem);
        if (chance == 0) {
            chance = this.checkScore(st.scores[0].scoreNoStem, simNoStem);
        }
        if (chance == 0) {
            chance = this.checkScore(st.scores[0].adjustedScore, simExactly);
        }
        return chance != 1;
    }

    private int checkScore(int storedScore, int checkedStore) {
        return storedScore < checkedStore ? -1 : (storedScore > checkedStore ? 1 : 0);
    }

    protected void addNearString(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int similarity, int similarityNoStem, int simAdjusted, byte[] similarityData, String tmxName, String creator, long creationDate, String changer, long changedDate, List<TMXProp> tuProperties) {
        int pos = 0;
        for (int i = 0; i < this.result.size(); ++i) {
            NearString st = this.result.get(i);
            if (source.equals(st.source) && (translation == null && st.translation == null || translation != null && translation.equals(st.translation))) {
                this.result.set(i, NearString.merge(st, key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, tuProperties));
                return;
            }
            if (st.scores[0].score < similarity) break;
            if (st.scores[0].score == similarity) {
                if (st.scores[0].scoreNoStem < similarityNoStem) break;
                if (st.scores[0].scoreNoStem == similarityNoStem) {
                    if (st.scores[0].adjustedScore < simAdjusted) break;
                    String entrySource = this.srcText;
                    if (similarity == 100 && !st.source.equals(entrySource) && source.equals(entrySource)) break;
                }
            }
            pos = i + 1;
        }
        this.result.add(pos, new NearString(key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, tuProperties));
        if (this.result.size() > this.maxCount) {
            this.result.remove(this.result.size() - 1);
        }
    }

    public Token[] tokenizeStem(String str) {
        Token[] result = this.tokenizeStemCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.MATCHING);
            this.tokenizeStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeNoStem(String str) {
        Token[] result = this.tokenizeNoStemCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.NONE);
            this.tokenizeNoStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeAll(String str) {
        Token[] result = this.tokenizeAllCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeVerbatim(str);
            this.tokenizeAllCache.put(str, result);
        }
        return result;
    }

    protected void checkStopped(IStopped stop) throws StoppedException {
        if (stop.isStopped()) {
            throw new StoppedException();
        }
    }

    public static class StoppedException
    extends RuntimeException {
    }
}

