/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.omegat.core.Core;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class PluginUtils {
    protected static URLClassLoader pluginsClassLoader;
    protected static List<Class<?>> loadedPlugins;
    protected static List<Class<?>> filterClasses;
    protected static List<Class<?>> tokenizerClasses;
    protected static List<Class<?>> markerClasses;
    protected static List<Class<?>> machineTranslationClasses;
    protected static List<Class<?>> glossaryClasses;
    protected static List<Class<?>> basePluginClasses;

    private PluginUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Map<String, String> params) {
        block17: {
            File pluginsDir = new File(StaticUtils.installDir(), "plugins");
            File homePluginsDir = new File(StaticUtils.getConfigDir(), "plugins");
            try {
                List<File> fs = FileUtil.findFiles(pluginsDir, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                List<File> fsHome = FileUtil.findFiles(homePluginsDir, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                fs.addAll(fsHome);
                URL[] urls = new URL[fs.size()];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = fs.get(i).toURI().toURL();
                    Log.logInfoRB("PLUGIN_LOAD_JAR", urls[i].toString());
                }
                boolean foundMain = false;
                pluginsClassLoader = new URLClassLoader(urls, PluginUtils.class.getClassLoader());
                Enumeration<URL> mlist = pluginsClassLoader.getResources("META-INF/MANIFEST.MF");
                while (mlist.hasMoreElements()) {
                    Manifest m;
                    URL mu = mlist.nextElement();
                    InputStream in = mu.openStream();
                    try {
                        m = new Manifest(in);
                    }
                    finally {
                        in.close();
                    }
                    if ("org.omegat.Main".equals(m.getMainAttributes().getValue("Main-Class"))) {
                        foundMain = true;
                    }
                    PluginUtils.loadFromManifest(m, pluginsClassLoader);
                }
                if (foundMain) break block17;
                String manifests = params.get("dev-manifests");
                if (manifests == null) {
                    manifests = "manifest-template.mf";
                }
                for (String mf : manifests.split(File.pathSeparator)) {
                    Manifest m;
                    FileInputStream in = new FileInputStream(mf);
                    try {
                        m = new Manifest(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    PluginUtils.loadFromManifest(m, pluginsClassLoader);
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        Collections.sort(tokenizerClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        for (Class<?> pl : basePluginClasses) {
            try {
                pl.newInstance();
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static List<Class<?>> getFilterClasses() {
        return filterClasses;
    }

    public static List<Class<?>> getTokenizerClasses() {
        return tokenizerClasses;
    }

    public static Class<?> getTokenizerClassForLanguage(Language lang) {
        if (lang == null) {
            return DefaultTokenizer.class;
        }
        Class<?> exactResult = PluginUtils.searchForTokenizer(lang.getLanguage());
        if (PluginUtils.isDefault(exactResult)) {
            return exactResult;
        }
        Class<?> generalResult = PluginUtils.searchForTokenizer(lang.getLanguageCode());
        if (PluginUtils.isDefault(generalResult)) {
            return generalResult;
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (generalResult != null) {
            return generalResult;
        }
        return DefaultTokenizer.class;
    }

    private static boolean isDefault(Class<?> c) {
        if (c == null) {
            return false;
        }
        Tokenizer ann = c.getAnnotation(Tokenizer.class);
        return ann == null ? false : ann.isDefault();
    }

    private static Class<?> searchForTokenizer(String lang) {
        if (lang.length() < 1) {
            return null;
        }
        lang = lang.toLowerCase();
        Class<?> fallback = null;
        for (Class<?> c : tokenizerClasses) {
            Tokenizer ann = c.getAnnotation(Tokenizer.class);
            if (ann == null) continue;
            String[] languages = ann.languages();
            try {
                if (languages.length == 1 && languages[0].equals("discoverAtRuntime")) {
                    languages = ((ITokenizer)c.newInstance()).getSupportedLanguages();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (String s : languages) {
                if (!lang.equals(s)) continue;
                if (ann.isDefault()) {
                    return c;
                }
                if (fallback != null) continue;
                fallback = c;
            }
        }
        return fallback;
    }

    public static List<Class<?>> getMarkerClasses() {
        return markerClasses;
    }

    public static List<Class<?>> getMachineTranslationClasses() {
        return machineTranslationClasses;
    }

    public static List<Class<?>> getGlossaryClasses() {
        return glossaryClasses;
    }

    protected static void loadFromManifest(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        String pluginClasses = m.getMainAttributes().getValue("OmegaT-Plugins");
        if (pluginClasses != null) {
            for (String clazz : pluginClasses.split("\\s+")) {
                if (clazz.trim().isEmpty()) continue;
                try {
                    Class<?> c = classLoader.loadClass(clazz);
                    Method load = c.getMethod("loadPlugins", new Class[0]);
                    load.invoke(c, new Object[0]);
                    loadedPlugins.add(c);
                    Log.logInfoRB("PLUGIN_LOAD_OK", clazz);
                }
                catch (Throwable ex) {
                    Log.logErrorRB(ex, "PLUGIN_LOAD_ERROR", clazz, ex.getClass().getSimpleName(), ex.getMessage());
                    Core.pluginLoadingError(StringUtil.format(OStrings.getString("PLUGIN_LOAD_ERROR"), clazz, ex.getClass().getSimpleName(), ex.getMessage()));
                }
            }
        }
        PluginUtils.loadFromManifestOld(m, classLoader);
    }

    public static void unloadPlugins() {
        for (Class<?> p : loadedPlugins) {
            try {
                Method load = p.getMethod("unloadPlugins", new Class[0]);
                load.invoke(p, new Object[0]);
            }
            catch (Throwable ex) {
                Log.logErrorRB(ex, "PLUGIN_UNLOAD_ERROR", p.getClass().getSimpleName(), ex.getMessage());
            }
        }
    }

    protected static void loadFromManifestOld(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        block10: for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            PLUGIN_TYPE pType;
            String key = e.getKey();
            Attributes attrs = e.getValue();
            String sType = attrs.getValue("OmegaT-Plugin");
            if ("true".equals(attrs.getValue("OmegaT-Tokenizer"))) {
                sType = "tokenizer";
            }
            if (sType == null) continue;
            try {
                pType = PLUGIN_TYPE.valueOf(sType.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                pType = PLUGIN_TYPE.UNKNOWN;
            }
            switch (pType) {
                case FILTER: {
                    filterClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
                case TOKENIZER: {
                    tokenizerClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
                case MARKER: {
                    markerClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
                case MACHINETRANSLATOR: {
                    machineTranslationClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
                case BASE: {
                    basePluginClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
                case GLOSSARY: {
                    glossaryClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block10;
                }
            }
            Log.logErrorRB("PLUGIN_UNKNOWN", key);
        }
    }

    static {
        loadedPlugins = new ArrayList();
        filterClasses = new ArrayList();
        tokenizerClasses = new ArrayList();
        markerClasses = new ArrayList();
        machineTranslationClasses = new ArrayList();
        glossaryClasses = new ArrayList();
        basePluginClasses = new ArrayList();
    }

    static enum PLUGIN_TYPE {
        FILTER,
        TOKENIZER,
        MARKER,
        MACHINETRANSLATOR,
        BASE,
        GLOSSARY,
        UNKNOWN;

    }
}

