/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.ilias;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ILIASFilter
extends AbstractFilter {
    protected Map<String, String> align;
    private final Pattern patternMark = Pattern.compile("<!-- language file start -->");
    private final Pattern patternText = Pattern.compile("^(\\S+)#:#(\\S+)#:#(.+)$");

    @Override
    public String getFileFormatName() {
        return OStrings.getString("ILIASFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    public Instance[] getDefaultInstances() {
        String targetFile = "ilias_${targetLanguageCode}.${extension}";
        return new Instance[]{new Instance("*.lang", null, "UTF-8", targetFile), new Instance("*.lang.local", null, "UTF-8", targetFile)};
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String line;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        while ((line = lbpr.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            Matcher mat = this.patternText.matcher(line);
            if (!mat.matches()) {
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            String key = mat.group(1) + "#:#" + mat.group(2);
            String value = mat.group(3);
            if (value.isEmpty()) {
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            outfile.write(key + "#:#");
            String trans = this.process(key, value);
            outfile.write(trans);
            outfile.write(lbpr.getLinebreak());
        }
        lbpr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isFileSupported(BufferedReader reader) {
        boolean markFound = false;
        boolean textFound = false;
        int MAX_LINES_TO_CHECK = 128;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        try {
            String line;
            int more = 129;
            while ((line = lbpr.readLine()) != null && --more > 0) {
                if ((line = line.trim()).isEmpty()) continue;
                markFound = this.patternMark.matcher(line).matches();
                if (markFound) {
                    break;
                }
                textFound = this.patternText.matcher(line).matches();
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                lbpr.close();
            }
            catch (IOException e) {}
        }
        return markFound & !textFound;
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    private String process(String key, String value) {
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(key, value, null, false, null, this);
            return value;
        }
        if (this.entryTranslateCallback != null) {
            String trans = this.entryTranslateCallback.getTranslation(key, value);
            return trans != null ? trans : value;
        }
        if (this.entryAlignCallback != null) {
            this.align.put(key, value);
        }
        return value;
    }
}

