/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.Handler;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLReader;
import org.omegat.filters3.xml.XMLWriter;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLFilter
extends AbstractFilter
implements Translator {
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private XMLDialect dialect;
    private String encoding;
    private String eol;
    private Language targetLanguage;

    public XMLFilter(XMLDialect dialect) {
        try {
            this.parserFactory.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialect = dialect;
    }

    public XMLDialect getDialect() {
        return this.dialect;
    }

    @Override
    public BufferedReader createReader(File inFile, String inEncoding) throws UnsupportedEncodingException, IOException {
        XMLReader xmlreader = new XMLReader(inFile, inEncoding);
        this.encoding = xmlreader.getEncoding();
        this.eol = xmlreader.getEol();
        return new BufferedReader(xmlreader);
    }

    @Override
    public BufferedWriter createWriter(File outFile, String outEncoding) throws UnsupportedEncodingException, IOException {
        if (outEncoding == null) {
            outEncoding = this.encoding;
        }
        if (outFile == null) {
            return new BufferedWriter(new StringWriter());
        }
        return new BufferedWriter(new XMLWriter(outFile, outEncoding, this.eol));
    }

    @Override
    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        BufferedReader inReader = null;
        try {
            inReader = this.createReader(inFile, fc.getInEncoding());
            this.inEncodingLastParsedFile = this.encoding;
            this.targetLanguage = fc.getTargetLang();
            InputSource source = new InputSource(inReader);
            source.setSystemId(inFile.toURI().toString());
            SAXParser parser = this.parserFactory.newSAXParser();
            Handler handler = new Handler(this, this.dialect, inFile, outFile, fc.getOutEncoding());
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new TranslationException(e);
        }
        catch (SAXException e) {
            throw new TranslationException(e);
        }
        finally {
            if (inReader != null) {
                inReader.close();
            }
        }
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new UnsupportedOperationException("XMLFilter.processFile(BufferedReader,BufferedWriter) should never be called!");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public String translate(String entry, List<ProtectedPart> protectedParts) {
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(null, entry, null, false, null, null, this, protectedParts);
            return entry;
        }
        if (this.entryTranslateCallback != null) {
            String translation = this.entryTranslateCallback.getTranslation(null, entry, null);
            return translation != null ? translation : entry;
        }
        return entry;
    }

    @Override
    public boolean isFileSupported(BufferedReader reader) {
        if (this.dialect.getConstraints() == null || this.dialect.getConstraints().isEmpty()) {
            return true;
        }
        try {
            Pattern xmlns;
            Pattern root;
            char[] cbuf = new char[65536];
            int cbuf_len = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbuf_len);
            Matcher matcher = PatternConsts.XML_DOCTYPE.matcher(buf);
            if (matcher.find()) {
                Pattern doctype = this.dialect.getConstraints().get(1);
                if (!(doctype == null || matcher.group(1) != null && doctype.matcher(matcher.group(1)).matches())) {
                    return false;
                }
                Pattern publicc = this.dialect.getConstraints().get(2);
                if (!(publicc == null || matcher.group(3) != null && publicc.matcher(matcher.group(3)).matches())) {
                    return false;
                }
                Pattern system = this.dialect.getConstraints().get(3);
                if (!(system == null || matcher.group(5) != null && system.matcher(matcher.group(5)).matches())) {
                    return false;
                }
            } else if (this.dialect.getConstraints().containsKey(1) || this.dialect.getConstraints().containsKey(2) || this.dialect.getConstraints().containsKey(3)) {
                return false;
            }
            if ((matcher = PatternConsts.XML_ROOTTAG.matcher(buf)).find() ? (root = this.dialect.getConstraints().get(4)) != null && (matcher.group(1) == null || !root.matcher(matcher.group(1)).matches()) : this.dialect.getConstraints().containsKey(4)) {
                return false;
            }
            matcher = PatternConsts.XML_XMLNS.matcher(buf);
            return !(matcher.find() ? (xmlns = this.dialect.getConstraints().get(5)) != null && (matcher.group(2) == null || !xmlns.matcher(matcher.group(2)).matches()) : this.dialect.getConstraints().containsKey(5));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void tagStart(String path, Attributes atts) {
    }

    @Override
    public void tagEnd(String path) {
    }

    @Override
    public void comment(String comment) {
    }

    @Override
    public void text(String text) {
    }

    @Override
    public boolean isInIgnored() {
        return false;
    }
}

