/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class EditXOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final XHTMLOptions options;
    private int returnStatus = 0;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextField ignoreTagsTF;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JButton okButton;
    private JCheckBox paragraphOnBrCB;
    private JTextField skipMetaTF;
    private JTextField skipRegExpTF;
    private JCheckBox translateButtonValueCB;
    private JCheckBox translateHrefCB;
    private JCheckBox translateHreflangCB;
    private JCheckBox translateLangCB;
    private JCheckBox translateSrcCB;
    private JCheckBox translateValueCB;

    public EditXOptionsDialog(Dialog parent, Map<String, String> config) {
        super(parent, true);
        this.options = new XHTMLOptions(new TreeMap<String, String>(config));
        this.initComponents();
        this.translateHrefCB.setSelected(this.options.getTranslateHref());
        this.translateSrcCB.setSelected(this.options.getTranslateSrc());
        this.translateLangCB.setSelected(this.options.getTranslateLang());
        this.translateHreflangCB.setSelected(this.options.getTranslateHreflang());
        this.translateValueCB.setSelected(this.options.getTranslateValue());
        this.translateButtonValueCB.setSelected(this.options.getTranslateButtonValue());
        this.paragraphOnBrCB.setSelected(this.options.getParagraphOnBr());
        this.skipRegExpTF.setText(this.options.getSkipRegExp());
        this.skipMetaTF.setText(this.options.getSkipMeta());
        this.ignoreTagsTF.setText(this.options.getIgnoreTags());
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditXOptionsDialog.this.doClose(0);
            }
        });
        DockingUI.displayCentered(this);
    }

    public XHTMLOptions getOptions() {
        return this.options;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.translateHrefCB = new JCheckBox();
        this.translateSrcCB = new JCheckBox();
        this.translateLangCB = new JCheckBox();
        this.translateHreflangCB = new JCheckBox();
        this.translateValueCB = new JCheckBox();
        this.translateButtonValueCB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.paragraphOnBrCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.skipRegExpTF = new JTextField();
        this.jLabel5 = new JLabel();
        this.skipMetaTF = new JTextField();
        this.jLabel6 = new JLabel();
        this.ignoreTagsTF = new JTextField();
        this.setTitle(OStrings.getString("XHTML_Filter_Options"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditXOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditXOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setMinimumSize(new Dimension(167, 121));
        this.jPanel1.setLayout(new GridLayout(0, 1));
        Mnemonics.setLocalizedText(this.jLabel2, OStrings.getString("HTML_TRANSLATE_ATTRIBUTES"));
        this.jPanel1.add(this.jLabel2);
        this.translateHrefCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateHrefCB, OStrings.getString("HTML_TRANSLATE_HREF"));
        this.jPanel1.add(this.translateHrefCB);
        this.translateSrcCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateSrcCB, OStrings.getString("HTML_TRANSLATE_SRC"));
        this.jPanel1.add(this.translateSrcCB);
        this.translateLangCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateLangCB, OStrings.getString("HTML_TRANSLATE_LANG"));
        this.jPanel1.add(this.translateLangCB);
        this.translateHreflangCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateHreflangCB, OStrings.getString("HTML_TRANSLATE_HREFLANG"));
        this.jPanel1.add(this.translateHreflangCB);
        this.translateValueCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateValueCB, OStrings.getString("HTML_TRANSLATE_VALUE"));
        this.jPanel1.add(this.translateValueCB);
        this.translateButtonValueCB.setSelected(true);
        Mnemonics.setLocalizedText(this.translateButtonValueCB, OStrings.getString("HTML_TRANSLATE_BUTTON_VALUE"));
        this.jPanel1.add(this.translateButtonValueCB);
        Mnemonics.setLocalizedText(this.jLabel3, OStrings.getString("HTML_PARAGRAPH_ON"));
        this.jPanel1.add(this.jLabel3);
        Mnemonics.setLocalizedText(this.paragraphOnBrCB, OStrings.getString("HTML_PARAGRAPH_ON_BR"));
        this.jPanel1.add(this.paragraphOnBrCB);
        Mnemonics.setLocalizedText(this.jLabel4, OStrings.getString("HTML_SKIPREGEXP"));
        this.jPanel1.add(this.jLabel4);
        this.jPanel1.add(this.skipRegExpTF);
        Mnemonics.setLocalizedText(this.jLabel5, OStrings.getString("HTML_SKIPMETA"));
        this.jPanel1.add(this.jLabel5);
        this.jPanel1.add(this.skipMetaTF);
        Mnemonics.setLocalizedText(this.jLabel6, OStrings.getString("HTML_IGNORE_TAGS"));
        this.jPanel1.add(this.jLabel6);
        this.jPanel1.add(this.ignoreTagsTF);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private boolean checkRegExp(JTextField textfield) {
        try {
            Pattern.compile(textfield.getText());
        }
        catch (PatternSyntaxException e) {
            textfield.setCaretPosition(e.getIndex());
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), OStrings.getString("HTML_ERROR_CUSTOMREGEXP_TITLE"), 0);
            textfield.grabFocus();
            return false;
        }
        return true;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.checkRegExp(this.skipRegExpTF)) {
            return;
        }
        this.options.setTranslateHref(this.translateHrefCB.isSelected());
        this.options.setTranslateSrc(this.translateSrcCB.isSelected());
        this.options.setTranslateLang(this.translateLangCB.isSelected());
        this.options.setTranslateValue(this.translateValueCB.isSelected());
        this.options.setTranslateButtonValue(this.translateButtonValueCB.isSelected());
        this.options.setTranslateHreflang(this.translateHreflangCB.isSelected());
        this.options.setParagraphOnBr(this.paragraphOnBrCB.isSelected());
        this.options.setSkipRegExp(this.skipRegExpTF.getText());
        this.options.setSkipMeta(this.skipMetaTF.getText());
        this.options.setIgnoreTags(this.ignoreTagsTF.getText());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

