/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableSelectionEvent;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.LastSegmentManager;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.editor.AlphabeticalMarkers;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.DocumentFilter3;
import org.omegat.gui.editor.EditorPopups;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.SegmentExportImport;
import org.omegat.gui.editor.SegmentHistory;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.gui.editor.autocompleter.IAutoCompleter;
import org.omegat.gui.editor.mark.CalcMarkersThread;
import org.omegat.gui.editor.mark.ComesFromTMMarker;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.DockablePanel;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorController
implements IEditor {
    private static final Logger LOGGER = Logger.getLogger(EditorController.class.getName());
    private DockablePanel pane;
    private JScrollPane scrollPane;
    private String title;
    private boolean dockableSelected;
    protected final EditorTextArea3 editor;
    protected MarkerController markerController;
    private String introPaneTitle;
    private String emptyProjectPaneTitle;
    private JTextPane introPane;
    private JTextPane emptyProjectPane;
    protected final MainWindow mw;
    protected SegmentBuilder[] m_docSegList;
    protected int displayedFileIndex;
    protected int previousDisplayedFileIndex;
    protected int displayedEntryIndex;
    private SegmentHistory history = new SegmentHistory();
    protected final EditorSettings settings;
    protected Font font;
    Document3.ORIENTATION currentOrientation;
    protected boolean sourceLangIsRTL;
    protected boolean targetLangIsRTL;
    volatile IEditorFilter entriesFilter;
    private Component entriesFilterControlComponent;
    private SegmentExportImport segmentExportImport;
    private long dirtyTime = -1L;
    private final DragTargetOverlay.IDropInfo dropInfo = new DragTargetOverlay.IDropInfo(){

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.javaFileListFlavor;
        }

        @Override
        public int getDnDAction() {
            return 1;
        }

        @Override
        public boolean handleDroppedObject(Object dropped) {
            List files = (List)dropped;
            File firstFile = (File)files.get(0);
            if (firstFile.getName().equals("omegat.project")) {
                firstFile = firstFile.getParentFile();
            }
            if (StaticUtils.isProjectDir(firstFile)) {
                return this.handleDroppedProject(firstFile);
            }
            return this.handleDroppedFiles(files);
        }

        private boolean handleDroppedProject(final File projDir) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectUICommands.projectOpen(projDir, true);
                }
            });
            return true;
        }

        private boolean handleDroppedFiles(final List<?> files) {
            if (!Core.getProject().isProjectLoaded()) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorController.this.mw.importFiles(Core.getProject().getProjectProperties().getSourceRoot(), files.toArray(new File[files.size()]));
                }
            });
            return true;
        }

        @Override
        public Component getComponentToOverlay() {
            return EditorController.this.scrollPane;
        }

        @Override
        public String getOverlayMessage() {
            return Core.getProject().isProjectLoaded() ? OStrings.getString("DND_ADD_SOURCE_FILE") : OStrings.getString("DND_OPEN_PROJECT");
        }

        @Override
        public boolean canAcceptDrop() {
            return true;
        }
    };

    public EditorController(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.segmentExportImport = new SegmentExportImport(this);
        this.editor = new EditorTextArea3(this);
        DragTargetOverlay.apply(this.editor, this.dropInfo);
        this.setFont(Core.getMainWindow().getApplicationFont());
        this.markerController = new MarkerController(this);
        this.createUI();
        this.settings = new EditorSettings(this);
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                SHOW_TYPE showType;
                switch (eventType) {
                    case CREATE: 
                    case LOAD: {
                        EditorController.this.history.clear();
                        EditorController.this.removeFilter();
                        showType = !Core.getProject().getAllEntries().isEmpty() ? SHOW_TYPE.FIRST_ENTRY : SHOW_TYPE.EMPTY_PROJECT;
                        EditorController.this.markerController.removeAll();
                        EditorController.this.setInitialOrientation();
                        break;
                    }
                    case CLOSE: {
                        EditorController.this.history.clear();
                        EditorController.this.removeFilter();
                        EditorController.this.markerController.removeAll();
                        showType = SHOW_TYPE.INTRO;
                        EditorController.this.deactivateWithoutCommit();
                        break;
                    }
                    default: {
                        showType = SHOW_TYPE.NO_CHANGE;
                    }
                }
                if (showType != SHOW_TYPE.NO_CHANGE) {
                    EditorController.this.updateState(showType);
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                EditorController.this.updateState(SHOW_TYPE.NO_CHANGE);
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
            }
        });
        this.createAdditionalPanes();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorController.this.updateState(SHOW_TYPE.INTRO);
                EditorController.this.pane.requestFocus();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            @Override
            public void onFontChanged(Font newFont) {
                EditorController.this.setFont(newFont);
                ViewLabel.fontHeight = 0;
                EditorController.this.editor.revalidate();
                EditorController.this.editor.repaint();
                EditorController.this.emptyProjectPane.setFont(EditorController.this.font);
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.log(Level.SEVERE, "Uncatched exception in thread [" + t.getName() + "]", e);
            }
        });
        EditorPopups.init(this);
    }

    private void createUI() {
        Container c;
        Border viewportBorder;
        this.pane = new DockablePanel("EDITOR", " ", false);
        this.pane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.pane.setMinimumSize(new Dimension(100, 100));
        this.pane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EditorController.this.updateTitle();
            }
        });
        this.scrollPane = new JScrollPane(this.editor);
        Border panelBorder = UIManager.getBorder("OmegaTDockablePanel.border");
        if (panelBorder != null) {
            this.scrollPane.setBorder(panelBorder);
        }
        if ((viewportBorder = UIManager.getBorder("OmegaTDockablePanelViewport.border")) != null) {
            this.scrollPane.setViewportBorder(viewportBorder);
        }
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.pane.setLayout(new BorderLayout());
        this.pane.add((Component)this.scrollPane, "Center");
        Core.getMainWindow().addDockable(this.pane);
        for (c = this.pane; c != null && !(c instanceof DockingDesktop); c = c.getParent()) {
        }
        DockingDesktop desktop = (DockingDesktop)c;
        desktop.addDockableSelectionListener(new DockableSelectionListener(){

            @Override
            public void selectionChanged(DockableSelectionEvent dockableselectionevent) {
                EditorController.this.dockableSelected = EditorController.this.pane == dockableselectionevent.getSelectedDockable();
            }
        });
    }

    private void updateState(SHOW_TYPE showType) {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane data = null;
        switch (showType) {
            case INTRO: {
                data = this.introPane;
                this.title = this.introPaneTitle;
                break;
            }
            case EMPTY_PROJECT: {
                data = this.emptyProjectPane;
                this.title = this.emptyProjectPaneTitle;
                break;
            }
            case FIRST_ENTRY: {
                this.displayedFileIndex = 0;
                this.displayedEntryIndex = 0;
                this.title = StringUtil.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorController.this.loadDocument();
                        EditorController.this.activateEntry();
                        LastSegmentManager.restoreLastSegment(EditorController.this);
                    }
                });
                break;
            }
            case NO_CHANGE: {
                this.title = StringUtil.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
            }
        }
        this.updateTitle();
        this.pane.setToolTipText(this.title);
        if (this.scrollPane.getViewport().getView() != data) {
            if (UIManager.getBoolean("OmegaTDockablePanel.isProportionalMargins")) {
                int size = data.getFont().getSize() / 2;
                data.setBorder(new EmptyBorder(size, size, size, size));
            }
            this.scrollPane.setViewportView(data);
        }
    }

    private void updateTitle() {
        this.pane.setName(StaticUIUtils.truncateToFit(this.title, this.pane, 70));
    }

    private void setFont(Font font) {
        this.font = font;
        this.editor.setFont(font);
    }

    private void setInitialOrientation() {
        String sourceLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String targetLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        this.sourceLangIsRTL = EditorUtils.isRTL(sourceLang);
        this.targetLangIsRTL = EditorUtils.isRTL(targetLang);
        this.currentOrientation = this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != EditorUtils.localeIsRTL() ? Document3.ORIENTATION.DIFFER : (this.sourceLangIsRTL ? Document3.ORIENTATION.ALL_RTL : Document3.ORIENTATION.ALL_LTR);
        this.applyOrientationToEditor();
    }

    private void applyOrientationToEditor() {
        ComponentOrientation targetOrientation = null;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                targetOrientation = ComponentOrientation.LEFT_TO_RIGHT;
                break;
            }
            case ALL_RTL: {
                targetOrientation = ComponentOrientation.RIGHT_TO_LEFT;
                break;
            }
            case DIFFER: {
                targetOrientation = this.targetLangIsRTL ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
            }
        }
        this.editor.setComponentOrientation(targetOrientation);
    }

    protected void toggleOrientation() {
        this.commitAndDeactivate();
        Document3.ORIENTATION newOrientation = this.currentOrientation;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                newOrientation = Document3.ORIENTATION.ALL_RTL;
                break;
            }
            case ALL_RTL: {
                if (this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != EditorUtils.localeIsRTL()) {
                    newOrientation = Document3.ORIENTATION.DIFFER;
                    break;
                }
                newOrientation = Document3.ORIENTATION.ALL_LTR;
                break;
            }
            case DIFFER: {
                newOrientation = Document3.ORIENTATION.ALL_LTR;
            }
        }
        LOGGER.info("Switch document orientation from " + (Object)((Object)this.currentOrientation) + " to " + (Object)((Object)newOrientation));
        this.currentOrientation = newOrientation;
        this.applyOrientationToEditor();
        int activeSegment = this.displayedEntryIndex;
        this.loadDocument();
        this.displayedEntryIndex = activeSegment;
        this.activateEntry();
    }

    public Document3.ORIENTATION getOrientation() {
        return this.currentOrientation;
    }

    @Override
    public void requestFocus() {
        this.scrollPane.getViewport().getView().requestFocusInWindow();
    }

    @Override
    public SourceTextEntry getCurrentEntry() {
        if (this.m_docSegList == null || this.displayedEntryIndex < 0 || this.m_docSegList.length <= this.displayedEntryIndex) {
            return null;
        }
        if (this.m_docSegList[this.displayedEntryIndex] == null) {
            return null;
        }
        return this.m_docSegList[this.displayedEntryIndex].ste;
    }

    @Override
    public String getCurrentFile() {
        if (Core.getProject().getProjectFiles().isEmpty()) {
            return null;
        }
        if (this.displayedFileIndex < Core.getProject().getProjectFiles().size()) {
            return Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath;
        }
        return null;
    }

    @Override
    public String getCurrentTargetFile() {
        String currentSource = this.getCurrentFile();
        if (currentSource == null) {
            return null;
        }
        return Core.getProject().getTargetPathForSourceFile(currentSource);
    }

    protected void loadDocument() {
        IProject.FileInfo file;
        UIThreadsUtil.mustBeSwingThread();
        try {
            file = Core.getProject().getProjectFiles().get(this.displayedFileIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            file = Core.getProject().getProjectFiles().get(0);
        }
        if (this.m_docSegList != null) {
            this.markerController.removeAll();
        }
        boolean hasRTL = this.sourceLangIsRTL || this.targetLangIsRTL || EditorUtils.localeIsRTL() || this.currentOrientation != Document3.ORIENTATION.ALL_LTR;
        Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
        for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
            hasRTL = hasRTL || EditorUtils.isRTL(entry.getKey().getLanguageCode().toLowerCase());
        }
        Document3 doc = new Document3(this);
        ArrayList<SegmentBuilder> temp_docSegList2 = new ArrayList<SegmentBuilder>(file.entries.size());
        for (int i = 0; i < file.entries.size(); ++i) {
            SourceTextEntry ste = file.entries.get(i);
            if (this.entriesFilter != null && !this.entriesFilter.allowed(ste)) continue;
            SegmentBuilder sb = new SegmentBuilder(this, doc, this.settings, ste, ste.entryNum(), hasRTL);
            temp_docSegList2.add(sb);
            sb.createSegmentElement(false);
            sb.addSegmentSeparator();
        }
        this.m_docSegList = temp_docSegList2.toArray(new SegmentBuilder[temp_docSegList2.size()]);
        doc.setDocumentFilter(new DocumentFilter3());
        Locale targetLocale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        this.editor.setLocale(targetLocale);
        this.editor.setDocument(doc);
        doc.addUndoableEditListener(this.editor.undoManager);
        this.editor.undoManager.reset();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }
        });
        this.markerController.process(this.m_docSegList);
        this.editor.repaint();
    }

    @Override
    public void activateEntry() {
        this.activateEntry(CaretPosition.startOfEntry());
    }

    public void activateEntry(CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        SourceTextEntry ste = this.getCurrentEntry();
        if (ste == null) {
            return;
        }
        if (this.scrollPane.getViewport().getView() != this.editor) {
            return;
        }
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.m_docSegList[this.displayedEntryIndex].createSegmentElement(true);
        Core.getNotes().setNoteText(Core.getProject().getTranslationInfo((SourceTextEntry)ste).note);
        this.markerController.reprocessImmediately(this.m_docSegList[this.displayedEntryIndex]);
        this.editor.undoManager.reset();
        this.history.insertNew(this.m_docSegList[this.displayedEntryIndex].segmentNumberInProject);
        this.setMenuEnabled();
        this.showStat();
        this.showLengthMessage();
        if (Preferences.isPreference("wf_exportCurrentSegment")) {
            this.segmentExportImport.exportCurrentSegment(ste);
        }
        int te = this.editor.getOmDocument().getTranslationEnd();
        int ts = this.editor.getOmDocument().getTranslationStart();
        if (pos.position != null) {
            pos.position = Math.max(0, pos.position);
            pos.position = Math.min(pos.position, te - ts);
        }
        if (pos.selectionStart != null && pos.selectionEnd != null) {
            pos.selectionStart = Math.max(0, pos.selectionStart);
            pos.selectionEnd = Math.min(pos.selectionEnd, te - ts);
            if (pos.selectionStart >= pos.selectionEnd) {
                pos.selectionStart = null;
                pos.selectionEnd = null;
            }
        }
        this.scrollForDisplayNearestSegments(pos);
        if (this.previousDisplayedFileIndex != this.displayedFileIndex) {
            this.previousDisplayedFileIndex = this.displayedFileIndex;
            CoreEvents.fireEntryNewFile(Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath);
        }
        this.editor.autoCompleter.setVisible(false);
        this.editor.repaint();
        CoreEvents.fireEntryActivated(ste);
        this.dirtyTime = -1L;
    }

    private void setMenuEnabled() {
        this.mw.menu.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
        this.mw.menu.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
        this.mw.menu.editMultipleDefault.setEnabled(!this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
        this.mw.menu.editMultipleAlternate.setEnabled(this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
    }

    void showLengthMessage() {
        Document3 doc = this.editor.getOmDocument();
        String trans = doc.extractTranslation();
        if (trans != null) {
            SourceTextEntry ste = this.m_docSegList[this.displayedEntryIndex].ste;
            String lMsg = " " + ste.getSrcText().length() + "/" + trans.length() + " ";
            Core.getMainWindow().showLengthMessage(lMsg);
        }
    }

    void onTextChanged() {
        Document3 doc = this.editor.getOmDocument();
        if (doc.trustedChangesInProgress || doc.textBeingComposed) {
            return;
        }
        if (doc.isEditMode()) {
            this.dirtyTime = System.nanoTime();
            this.m_docSegList[this.displayedEntryIndex].onActiveEntryChanged();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorController.this.markerController.reprocessImmediately(EditorController.this.m_docSegList[EditorController.this.displayedEntryIndex]);
                    EditorController.this.editor.autoCompleter.textDidChange();
                }
            });
        }
    }

    private void scrollForDisplayNearestSegments(final CaretPosition pos) {
        int lookNext;
        int lookPrev;
        try {
            SegmentBuilder prev = this.m_docSegList[this.displayedEntryIndex - 3];
            lookPrev = prev.getStartPosition();
        }
        catch (IndexOutOfBoundsException ex) {
            lookPrev = 0;
        }
        try {
            SegmentBuilder next = this.m_docSegList[this.displayedEntryIndex + 4];
            lookNext = next.getStartPosition() - 1;
        }
        catch (IndexOutOfBoundsException ex) {
            lookNext = this.editor.getOmDocument().getLength();
        }
        final int p = lookPrev;
        final int n = lookNext;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EditorController.this.editor.setCaretPosition(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EditorController.this.editor.setCaretPosition(p);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        EditorController.this.setCaretPosition(pos);
                                    }
                                });
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    public void showStat() {
        IProject project = Core.getProject();
        IProject.FileInfo fi = project.getProjectFiles().get(this.displayedFileIndex);
        int translatedInFile = 0;
        int translatedUniqueInFile = 0;
        int uniqueInFile = 0;
        for (SourceTextEntry ste : fi.entries) {
            boolean isUnique;
            boolean bl = isUnique = ste.getDuplicate() != SourceTextEntry.DUPLICATE.NEXT;
            if (isUnique) {
                ++uniqueInFile;
            }
            if (!project.getTranslationInfo(ste).isTranslated()) continue;
            ++translatedInFile;
            if (!isUnique) continue;
            ++translatedUniqueInFile;
        }
        StatisticsInfo stat = project.getStatistics();
        MainWindowUI.STATUS_BAR_MODE progressMode = Preferences.getPreferenceEnumDefault("sb_progress_mode", MainWindowUI.STATUS_BAR_MODE.DEFAULT);
        if (progressMode == MainWindowUI.STATUS_BAR_MODE.DEFAULT) {
            StringBuilder pMsg = new StringBuilder(1024).append(" ");
            pMsg.append(translatedInFile).append("/").append(fi.entries.size()).append(" (").append(stat.numberofTranslatedSegments).append("/").append(stat.numberOfUniqueSegments).append(", ").append(stat.numberOfSegmentsTotal).append(") ");
            Core.getMainWindow().showProgressMessage(pMsg.toString());
        } else {
            NumberFormat nfPer = NumberFormat.getPercentInstance();
            nfPer.setRoundingMode(RoundingMode.DOWN);
            nfPer.setMaximumFractionDigits(1);
            String message = StringUtil.format(OStrings.getString("MW_PROGRESS_DEFAULT_PERCENTAGE"), translatedUniqueInFile == 0 ? "0%" : nfPer.format((double)translatedUniqueInFile / (double)uniqueInFile), uniqueInFile - translatedUniqueInFile, stat.numberofTranslatedSegments == 0 ? "0%" : nfPer.format((double)stat.numberofTranslatedSegments / (double)stat.numberOfUniqueSegments), stat.numberOfUniqueSegments - stat.numberofTranslatedSegments, stat.numberOfSegmentsTotal);
            Core.getMainWindow().showProgressMessage(message);
        }
    }

    protected boolean goToSegmentAtLocation(int location) {
        int segmentAtLocation = this.getSegmentIndexAtLocation(location);
        if (this.displayedEntryIndex != segmentAtLocation) {
            this.commitAndDeactivate();
            this.displayedEntryIndex = segmentAtLocation;
            this.activateEntry();
            return true;
        }
        return false;
    }

    protected int getSegmentIndexAtLocation(int location) {
        int segmentAtLocation = this.m_docSegList.length - 1;
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (location >= this.m_docSegList[i].getStartPosition()) continue;
            segmentAtLocation = i - 1;
            break;
        }
        return segmentAtLocation;
    }

    public void refreshEntries(Set<Integer> entryNumbers) {
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (!entryNumbers.contains(this.m_docSegList[i].ste.entryNum())) continue;
            this.m_docSegList[i].createSegmentElement(false);
        }
    }

    @Override
    public void commitAndDeactivate() {
        UIThreadsUtil.mustBeSwingThread();
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        String newTrans = doc.extractTranslation();
        if (newTrans != null) {
            this.commitAndDeactivate(null, newTrans);
        }
        this.dirtyTime = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitAndDeactivate(ForceTranslation forceTranslation, String newTrans) {
        boolean noteChanged;
        UIThreadsUtil.mustBeSwingThread();
        Document3 doc = this.editor.getOmDocument();
        doc.stopEditMode();
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        SourceTextEntry entry = sb.ste;
        TMXEntry oldTE = Core.getProject().getTranslationInfo(entry);
        PrepareTMXEntry newen = new PrepareTMXEntry();
        newen.source = sb.getSourceText();
        newen.note = Core.getNotes().getNoteText();
        if (forceTranslation != null) {
            switch (forceTranslation) {
                case UNTRANSLATED: {
                    newen.translation = null;
                    break;
                }
                case EMPTY: {
                    newen.translation = "";
                    break;
                }
                case EQUALS_TO_SOURCE: {
                    newen.translation = newen.source;
                }
            }
        } else {
            newen.translation = newTrans.isEmpty() ? (oldTE.isTranslated() && "".equals(oldTE.translation) ? "" : null) : (newTrans.equals(newen.source) ? (Preferences.isPreference("wf_allowTransEqualToSrc") ? newTrans : (oldTE.source.equals(oldTE.translation) ? oldTE.translation : null)) : newTrans);
        }
        boolean defaultTranslation = sb.isDefaultTranslation();
        boolean isNewAltTrans = !defaultTranslation && oldTE.defaultTranslation;
        boolean translationChanged = !StringUtil.equalsWithNulls(oldTE.translation, newen.translation);
        boolean bl = noteChanged = !StringUtil.nvl(oldTE.note, "").equals(StringUtil.nvl(newen.note, ""));
        if (!isNewAltTrans && !translationChanged && noteChanged) {
            Core.getProject().setNote(entry, oldTE, newen.note);
        } else if (translationChanged || noteChanged) {
            Core.getProject().setTranslation(entry, newen, defaultTranslation, null);
        }
        this.m_docSegList[this.displayedEntryIndex].createSegmentElement(false);
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (i == this.displayedEntryIndex || !this.m_docSegList[i].ste.getSrcText().equals(entry.getSrcText())) continue;
            this.m_docSegList[i].createSegmentElement(false);
            this.markerController.reprocessImmediately(this.m_docSegList[i]);
        }
        Core.getNotes().clear();
        this.markerController.reprocessImmediately(this.m_docSegList[this.displayedEntryIndex]);
        this.editor.undoManager.reset();
        if (entry != null && Preferences.isPreference("tagValidateOnLeave")) {
            final SourceTextEntry ste = entry;
            new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    ITagValidation tv = Core.getTagValidation();
                    if (!tv.checkInvalidTags(ste)) {
                        tv.displayTagValidationErrors(tv.listInvalidTags(), null);
                    }
                    return null;
                }
            }.execute();
        }
        EditorController editorController = this;
        synchronized (editorController) {
            this.notifyAll();
        }
        this.dirtyTime = -1L;
    }

    protected void deactivateWithoutCommit() {
        UIThreadsUtil.mustBeSwingThread();
        this.segmentExportImport.exportCurrentSegment(null);
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        doc.stopEditMode();
    }

    @Override
    public void commitAndLeave() {
        if (Core.getProject().getAllEntries().isEmpty()) {
            return;
        }
        int currentPosition = this.getCurrentPositionInEntryTranslation();
        this.commitAndDeactivate();
        this.activateEntry(new CaretPosition(currentPosition));
    }

    @Override
    public void nextEntry() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        boolean looped = false;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex < this.m_docSegList.length) continue;
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= files.size()) {
                this.displayedFileIndex = 0;
                looped = true;
            }
            this.loadDocument();
        } while ((ste = this.getCurrentEntry()) == null && (!looped || this.displayedFileIndex != startFileIndex || this.displayedEntryIndex < startEntryIndex && this.m_docSegList.length != 0));
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void prevEntry() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        boolean looped = false;
        do {
            --this.displayedEntryIndex;
            if (this.displayedEntryIndex >= 0) continue;
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = files.size() - 1;
                looped = true;
            }
            this.loadDocument();
            this.displayedEntryIndex = this.m_docSegList.length - 1;
        } while ((ste = this.getCurrentEntry()) == null && (!looped || this.displayedFileIndex != startFileIndex || this.displayedEntryIndex < startEntryIndex && this.m_docSegList.length != 0));
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    private void nextTranslatedEntry(boolean findTranslated) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        while (true) {
            SourceTextEntry ste;
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex >= this.m_docSegList.length) {
                ++this.displayedFileIndex;
                this.displayedEntryIndex = 0;
                if (this.displayedFileIndex >= files.size()) {
                    this.displayedFileIndex = 0;
                }
                this.loadDocument();
            }
            if ((ste = this.getCurrentEntry()) == null || this.displayedFileIndex == startFileIndex && this.displayedEntryIndex == startEntryIndex || (findTranslated ? Core.getProject().getTranslationInfo(ste).isTranslated() : !Core.getProject().getTranslationInfo(ste).isTranslated())) break;
            if (!Preferences.isPreference("wf_stopOnAlternativeTranslation")) continue;
            HasMultipleTranslations checker = new HasMultipleTranslations(ste.getSrcText());
            Core.getProject().iterateByMultipleTranslations(checker);
            if (checker.found) break;
        }
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void nextUntranslatedEntry() {
        this.nextTranslatedEntry(false);
    }

    @Override
    public void nextTranslatedEntry() {
        this.nextTranslatedEntry(true);
    }

    @Override
    public void nextEntryWithNote() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex < this.m_docSegList.length) continue;
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= files.size()) {
                this.displayedFileIndex = 0;
            }
            this.loadDocument();
        } while ((ste = this.getCurrentEntry()) != null && (this.displayedFileIndex != startFileIndex || this.displayedEntryIndex != startEntryIndex) && !Core.getProject().getTranslationInfo(ste).hasNote());
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void prevEntryWithNote() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        do {
            --this.displayedEntryIndex;
            if (this.displayedEntryIndex >= 0) continue;
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = files.size() - 1;
            }
            this.loadDocument();
            this.displayedEntryIndex = this.m_docSegList.length - 1;
        } while ((ste = this.getCurrentEntry()) != null && (this.displayedFileIndex != startFileIndex || this.displayedEntryIndex != startEntryIndex) && !Core.getProject().getTranslationInfo(ste).hasNote());
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void nextUniqueEntry() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        if (files.isEmpty()) {
            return;
        }
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex < this.m_docSegList.length) continue;
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= files.size()) {
                this.displayedFileIndex = 0;
            }
            this.loadDocument();
        } while ((ste = this.getCurrentEntry()) != null && (this.displayedFileIndex != startFileIndex || this.displayedEntryIndex != startEntryIndex) && ste.getDuplicate() == SourceTextEntry.DUPLICATE.NEXT);
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public int getCurrentEntryNumber() {
        SourceTextEntry e = this.getCurrentEntry();
        return e != null ? e.entryNum() : 0;
    }

    @Override
    public void gotoFile(int fileIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        this.commitAndDeactivate();
        this.displayedFileIndex = fileIndex;
        this.displayedEntryIndex = 0;
        this.loadDocument();
        this.activateEntry();
    }

    @Override
    public void gotoEntry(int entryNum) {
        this.gotoEntry(entryNum, CaretPosition.startOfEntry());
    }

    public void gotoEntry(int entryNum, CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.commitAndDeactivate();
        if (entryNum == 0) {
            this.displayedFileIndex = 0;
            this.displayedEntryIndex = 0;
            this.loadDocument();
        } else {
            IProject dataEngine = Core.getProject();
            block0: for (int i = 0; i < dataEngine.getProjectFiles().size(); ++i) {
                IProject.FileInfo fi = dataEngine.getProjectFiles().get(i);
                SourceTextEntry firstEntry = fi.entries.get(0);
                SourceTextEntry lastEntry = fi.entries.get(fi.entries.size() - 1);
                if (firstEntry.entryNum() > entryNum || lastEntry.entryNum() < entryNum) continue;
                if (i != this.displayedFileIndex) {
                    this.displayedFileIndex = i;
                    this.loadDocument();
                }
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < entryNum) continue;
                    this.displayedEntryIndex = j;
                    break block0;
                }
                break;
            }
        }
        this.activateEntry(pos);
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void gotoEntry(String srcString, EntryKey key) {
        UIThreadsUtil.mustBeSwingThread();
        List<SourceTextEntry> entries = Core.getProject().getAllEntries();
        for (int i = 0; i < entries.size(); ++i) {
            TMXEntry trans;
            SourceTextEntry ste = entries.get(i);
            if (srcString != null && !ste.getSrcText().equals(srcString) || (key != null ? !ste.getKey().equals(key) : !(trans = Core.getProject().getTranslationInfo(entries.get(i))).isTranslated() || !trans.defaultTranslation)) continue;
            this.gotoEntry(i + 1);
            break;
        }
    }

    @Override
    public void gotoEntryAfterFix(int entryNum, String fixedSource) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryNum == this.getCurrentEntryNumber() || this.getCurrentEntry().getSrcText().equals(fixedSource)) {
            this.deactivateWithoutCommit();
        }
        this.gotoFile(this.displayedFileIndex);
        this.gotoEntry(entryNum);
    }

    @Override
    public void refreshViewAfterFix(List<Integer> fixedEntries) {
        boolean doCommit = fixedEntries != null && fixedEntries.contains(this.getCurrentEntryNumber());
        this.refreshView(doCommit);
    }

    @Override
    public void refreshView(boolean doCommit) {
        UIThreadsUtil.mustBeSwingThread();
        if (!doCommit) {
            this.deactivateWithoutCommit();
        }
        int currentEntry = this.getCurrentEntryNumber();
        int caretPosition = this.getCurrentPositionInEntryTranslation();
        this.gotoFile(this.displayedFileIndex);
        this.gotoEntry(currentEntry, new CaretPosition(caretPosition));
    }

    @Override
    public void changeCase(IEditor.CHANGE_CASE_TO toWhat) {
        UIThreadsUtil.mustBeSwingThread();
        int start = this.editor.getSelectionStart();
        int end = this.editor.getSelectionEnd();
        int caretPosition = this.editor.getCaretPosition();
        int translationStart = this.editor.getOmDocument().getTranslationStart();
        int translationEnd = this.editor.getOmDocument().getTranslationEnd();
        if (end < translationStart || start > translationEnd) {
            return;
        }
        if (start < translationStart && end <= translationEnd) {
            start = translationStart;
        }
        if (end > translationEnd && start >= translationStart) {
            end = translationEnd;
        }
        try {
            if (start == end) {
                start = EditorUtils.getWordStart(this.editor, start);
                end = EditorUtils.getWordEnd(this.editor, end);
                if (start < translationStart && end <= translationEnd) {
                    start = translationStart;
                }
                if (end > translationEnd && start >= translationStart) {
                    end = translationEnd;
                }
            }
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
            String selectionText = this.editor.getText(start, end - start);
            String result = EditorUtils.doChangeCase(selectionText, toWhat);
            if (selectionText.equals(result)) {
                return;
            }
            this.editor.replaceSelection(result);
            this.editor.setCaretPosition(caretPosition);
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
        }
        catch (BadLocationException ble) {
            Log.log("bad location exception when changing case");
            Log.log(ble);
        }
    }

    @Override
    public void replaceEditText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        int start = this.editor.getOmDocument().getTranslationStart();
        int end = this.editor.getOmDocument().getTranslationEnd();
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromTMMarker.class.getName())];
        ((ComesFromTMMarker)thread.marker).setMark(null, null);
        this.editor.select(start, end);
        this.editor.replaceSelection(text);
    }

    public void replacePartOfText(String text, int start, int end) {
        UIThreadsUtil.mustBeSwingThread();
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromTMMarker.class.getName())];
        ((ComesFromTMMarker)thread.marker).setMark(null, null);
        int off = this.editor.getOmDocument().getTranslationStart();
        this.editor.select(start + off, end + off);
        this.editor.replaceSelection(text);
    }

    @Override
    public void replaceEditTextAndMark(String text) {
        this.replaceEditText(text);
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromTMMarker.class.getName())];
        ((ComesFromTMMarker)thread.marker).setMark(sb.getSourceTextEntry(), text);
        this.markerController.reprocessImmediately(sb);
    }

    public void replacePartOfTextAndMark(String text, int start, int end) {
        this.replacePartOfText(text, start, end);
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        CalcMarkersThread thread = this.markerController.markerThreads[this.markerController.getMarkerIndex(ComesFromTMMarker.class.getName())];
        ((ComesFromTMMarker)thread.marker).setMark(sb.getSourceTextEntry(), text);
        this.markerController.reprocessImmediately(sb);
    }

    @Override
    public String getCurrentTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        return this.editor.getOmDocument().extractTranslation();
    }

    public int getCurrentPositionInEntryTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        return this.getPositionInEntryTranslation(this.editor.getCaretPosition());
    }

    public int getPositionInEntryTranslation(int pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!this.editor.getOmDocument().isEditMode()) {
            return -1;
        }
        int beg = this.editor.getOmDocument().getTranslationStart();
        int end = this.editor.getOmDocument().getTranslationEnd();
        if (pos < beg) {
            pos = beg;
        }
        if (pos > end) {
            pos = end;
        }
        return pos - beg;
    }

    public void setCaretPosition(CaretPosition pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (!this.editor.getOmDocument().isEditMode()) {
            return;
        }
        int off = this.editor.getOmDocument().getTranslationStart();
        try {
            if (pos.position != null) {
                this.editor.setCaretPosition(off + pos.position);
            } else if (pos.selectionStart != null && pos.selectionEnd != null) {
                this.editor.select(off + pos.selectionStart, off + pos.selectionEnd);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.editor.checkAndFixCaret();
    }

    @Override
    public void insertText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.checkAndFixCaret();
        this.editor.replaceSelection(text);
    }

    @Override
    public void gotoHistoryBack() {
        UIThreadsUtil.mustBeSwingThread();
        int prevValue = this.history.back();
        if (prevValue != -1) {
            this.gotoEntry(prevValue);
        }
    }

    @Override
    public void gotoHistoryForward() {
        UIThreadsUtil.mustBeSwingThread();
        int nextValue = this.history.forward();
        if (nextValue != -1) {
            this.gotoEntry(nextValue);
        }
    }

    @Override
    public EditorSettings getSettings() {
        return this.settings;
    }

    @Override
    public void undo() {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.undoManager.undo();
    }

    @Override
    public void redo() {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.undoManager.redo();
    }

    @Override
    public String getSelectedText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.dockableSelected ? this.editor.getSelectedText() : null;
    }

    private void createAdditionalPanes() {
        this.introPaneTitle = OStrings.getString("DOCKING_INSTANT_START_TITLE");
        try {
            String language = this.detectInstantStartLanguage();
            this.introPane = new JTextPane();
            this.introPane.setComponentOrientation(EditorUtils.isRTL(language) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
            this.introPane.setEditable(false);
            DragTargetOverlay.apply(this.introPane, this.dropInfo);
            this.introPane.setPage(HelpFrame.getHelpFileURL(language, "instantStartGuideNoTOC.html"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.emptyProjectPaneTitle = OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
        this.emptyProjectPane = new JTextPane();
        this.emptyProjectPane.setEditable(false);
        this.emptyProjectPane.setText(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
        this.emptyProjectPane.setFont(Core.getMainWindow().getApplicationFont());
        DragTargetOverlay.apply(this.emptyProjectPane, this.dropInfo);
    }

    private String detectInstantStartLanguage() {
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH);
        if (HelpFrame.getHelpFileURL(language + "_" + country, "instantStartGuideNoTOC.html") != null) {
            return language + "_" + country;
        }
        if (HelpFrame.getHelpFileURL(language, "instantStartGuideNoTOC.html") != null) {
            return language;
        }
        return "en";
    }

    @Override
    public void remarkOneMarker(String markerClassName) {
        int mi = this.markerController.getMarkerIndex(markerClassName);
        this.markerController.reprocess(this.m_docSegList, mi);
    }

    @Override
    public void markActiveEntrySource(SourceTextEntry requiredActiveEntry, List<Mark> marks, String markerClassName) {
        UIThreadsUtil.mustBeSwingThread();
        for (Mark m : marks) {
            if (m.entryPart == Mark.ENTRY_PART.SOURCE) continue;
            throw new RuntimeException("Mark must be for source only");
        }
        SourceTextEntry realActive = this.m_docSegList[this.displayedEntryIndex].ste;
        if (realActive != requiredActiveEntry) {
            return;
        }
        int mi = this.markerController.getMarkerIndex(markerClassName);
        EntryMarks ev = new EntryMarks(this.m_docSegList[this.displayedEntryIndex], this.m_docSegList[this.displayedEntryIndex].getDisplayVersion(), mi);
        ev.result = marks;
        this.markerController.queueMarksOutput(ev);
    }

    @Override
    public void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        this.editor.registerPopupMenuConstructors(priority, constructor);
    }

    @Override
    public IEditorFilter getFilter() {
        return this.entriesFilter;
    }

    @Override
    public void setFilter(IEditorFilter filter) {
        UIThreadsUtil.mustBeSwingThread();
        if (this.entriesFilterControlComponent != null) {
            this.pane.remove(this.entriesFilterControlComponent);
        }
        this.entriesFilter = filter;
        this.entriesFilterControlComponent = filter.getControlComponent();
        this.pane.add(this.entriesFilterControlComponent, "North");
        this.pane.revalidate();
        SourceTextEntry curEntry = this.getCurrentEntry();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && project.getProjectFiles() != null && curEntry != null) {
            int curEntryNum = curEntry.entryNum();
            this.loadDocument();
            if (this.entriesFilter == null || this.entriesFilter.allowed(curEntry)) {
                this.gotoEntry(curEntry.entryNum());
            } else {
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < curEntryNum) continue;
                    this.displayedEntryIndex = j - 1;
                    break;
                }
                this.nextEntry();
            }
        }
    }

    @Override
    public void removeFilter() {
        List<IProject.FileInfo> files;
        UIThreadsUtil.mustBeSwingThread();
        this.entriesFilter = null;
        if (this.entriesFilterControlComponent != null) {
            this.pane.remove(this.entriesFilterControlComponent);
            this.pane.revalidate();
            this.entriesFilterControlComponent = null;
        }
        int curEntryNum = this.getCurrentEntryNumber();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && project.isProjectLoaded() && (files = project.getProjectFiles()) != null && !files.isEmpty()) {
            this.loadDocument();
            this.gotoEntry(curEntryNum);
        }
    }

    @Override
    public void setAlternateTranslationForCurrentEntry(boolean alternate) {
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        if (!alternate) {
            SourceTextEntry ste = sb.getSourceTextEntry();
            PrepareTMXEntry en = new PrepareTMXEntry();
            en.source = ste.getSrcText();
            Core.getProject().setTranslation(ste, en, false, null);
            sb.setDefaultTranslation(true);
        } else {
            sb.setDefaultTranslation(false);
        }
        this.setMenuEnabled();
    }

    @Override
    public void registerUntranslated() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.UNTRANSLATED, null);
        this.activateEntry();
    }

    @Override
    public void registerEmptyTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.EMPTY, null);
        this.activateEntry();
    }

    @Override
    public void registerIdenticalTranslation() {
        UIThreadsUtil.mustBeSwingThread();
        this.commitAndDeactivate(ForceTranslation.EQUALS_TO_SOURCE, null);
        this.activateEntry();
    }

    @Override
    public void windowDeactivated() {
        this.editor.autoCompleter.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCommit(int timeoutSeconds) {
        if (this.dirtyTime == -1L) {
            return;
        }
        ForceCommitTimer timer = new ForceCommitTimer(timeoutSeconds);
        timer.start();
        try {
            EditorController editorController = this;
            synchronized (editorController) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            timer.cancel();
        }
    }

    public AlphabeticalMarkers getAlphabeticalMarkers() {
        return new AlphabeticalMarkers(this.scrollPane){

            @Override
            protected Map<Integer, Point> getViewableSegmentLocations() {
                int UPPER_GAP = 5;
                LinkedHashMap<Integer, Point> map = new LinkedHashMap<Integer, Point>();
                if (EditorController.this.m_docSegList == null) {
                    return map;
                }
                JViewport viewport = EditorController.this.scrollPane.getViewport();
                int x = EditorController.this.sourceLangIsRTL ? EditorController.this.editor.getWidth() - EditorController.this.editor.getInsets().right : EditorController.this.editor.getInsets().left;
                Rectangle viewRect = viewport.getViewRect();
                viewRect.setBounds(viewRect.x, viewRect.y - 5, viewRect.width, viewRect.height + 5);
                Point viewPosition = viewport.getViewPosition();
                for (SegmentBuilder sb : EditorController.this.m_docSegList) {
                    try {
                        Point location = EditorController.this.editor.modelToView(sb.getStartPosition()).getLocation();
                        if (!viewRect.contains(location)) continue;
                        int segmentNo = sb.segmentNumberInProject;
                        location.translate(0, -viewPosition.y);
                        location.x = x;
                        map.put(segmentNo, location);
                    }
                    catch (BadLocationException ex) {
                        // empty catch block
                    }
                }
                return map;
            }
        };
    }

    @Override
    public IAutoCompleter getAutoCompleter() {
        return this.editor.autoCompleter;
    }

    private class ForceCommitTimer
    extends Thread {
        private final long limit;
        private boolean isCanceled = false;

        public ForceCommitTimer(int limit) {
            this.limit = (long)limit * 1000000000L;
        }

        @Override
        public void run() {
            while (!this.isCanceled) {
                long t = System.nanoTime() - EditorController.this.dirtyTime;
                if (t >= this.limit) {
                    UIThreadsUtil.executeInSwingThread(new Runnable(){

                        @Override
                        public void run() {
                            EditorController.this.commitAndLeave();
                        }
                    });
                    Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                    break;
                }
                if (t >= this.limit - 5000000000L) {
                    Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE_COUNTDOWN", (this.limit - t) / 1000000000L);
                } else {
                    Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE_WAITING", new Object[0]);
                }
                try {
                    ForceCommitTimer.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void cancel() {
            this.isCanceled = true;
        }
    }

    public static class CaretPosition {
        Integer position;
        Integer selectionStart;
        Integer selectionEnd;

        public CaretPosition(int position) {
            this.position = position;
            this.selectionStart = null;
            this.selectionEnd = null;
        }

        public CaretPosition(int selectionStart, int selectionEnd) {
            this.position = null;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public static CaretPosition startOfEntry() {
            return new CaretPosition(0);
        }
    }

    protected static class HasMultipleTranslations
    implements IProject.MultipleTranslationsIterator {
        final String sourceEntryText;
        IProject project;
        boolean found;

        public HasMultipleTranslations(String sourceEntryText) {
            this.sourceEntryText = sourceEntryText;
            this.project = Core.getProject();
        }

        @Override
        public void iterate(EntryKey source, TMXEntry trans) {
            if (this.found) {
                return;
            }
            if (this.sourceEntryText.equals(source.sourceText)) {
                this.found = true;
            }
        }
    }

    private static enum SHOW_TYPE {
        INTRO,
        EMPTY_PROJECT,
        FIRST_ENTRY,
        NO_CHANGE;

    }

    static enum ForceTranslation {
        UNTRANSLATED,
        EMPTY,
        EQUALS_TO_SOURCE;

    }
}

