/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.List;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.omegat.core.Core;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class EditorUtils {
    public static boolean isRTL(String language) {
        return "ar".equalsIgnoreCase(language) || "iw".equalsIgnoreCase(language) || "he".equalsIgnoreCase(language) || "fa".equalsIgnoreCase(language) || "ur".equalsIgnoreCase(language) || "ug".equalsIgnoreCase(language) || "ji".equalsIgnoreCase(language) || "yi".equalsIgnoreCase(language);
    }

    public static boolean localeIsRTL() {
        String language = Locale.getDefault().getLanguage().toLowerCase();
        return EditorUtils.isRTL(language);
    }

    public static int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        int result = Utilities.getWordStart(c, offs);
        char ch = c.getDocument().getText(result, 1).charAt(0);
        if (EditorUtils.isDirectionChar(ch)) {
            ++result;
        }
        return result;
    }

    public static int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        char ch;
        int result = Utilities.getWordEnd(c, offs);
        if (result > 0 && EditorUtils.isDirectionChar(ch = c.getDocument().getText(result - 1, 1).charAt(0))) {
            --result;
        }
        return result;
    }

    private static boolean isDirectionChar(char ch) {
        return ch == '\u202a' || ch == '\u202b' || ch == '\u202c';
    }

    public static String removeDirectionChars(String text) {
        return text.replaceAll("[\u202a\u202b\u202c]", "");
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        ITokenizer tokenizer = Core.getProject().getTargetTokenizer();
        return EditorUtils.doChangeCase(input, toWhat, locale, tokenizer);
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat, Locale locale, ITokenizer tokenizer) {
        Token[] tokenList = tokenizer.tokenizeWords(input, ITokenizer.StemmingMode.NONE);
        if (toWhat == IEditor.CHANGE_CASE_TO.CYCLE) {
            int lower = 0;
            int upper = 0;
            int title = 0;
            int ambiguous = 0;
            int mixed = 0;
            for (Token token : tokenList) {
                String word = token.getTextFromString(input);
                if (StringUtil.isLowerCase(word)) {
                    ++lower;
                    continue;
                }
                boolean isTitle = StringUtil.isTitleCase(word);
                boolean isUpper = StringUtil.isUpperCase(word);
                if (isTitle && isUpper) {
                    ++ambiguous;
                    continue;
                }
                if (isTitle) {
                    ++title;
                    continue;
                }
                if (isUpper) {
                    ++upper;
                    continue;
                }
                if (!StringUtil.isMixedCase(word)) continue;
                ++mixed;
            }
            if (lower == 0 && title == 0 && upper == 0 && mixed == 0 && ambiguous == 0) {
                return input;
            }
            toWhat = EditorUtils.determineTargetCase(lower, upper, title, mixed, ambiguous);
        }
        if (toWhat == IEditor.CHANGE_CASE_TO.SENTENCE) {
            return StringUtil.toTitleCase(input, locale);
        }
        StringBuilder buffer = new StringBuilder(input);
        int lengthIncrement = 0;
        for (Token token : tokenList) {
            String tokText = token.getTextFromString(input);
            String result = toWhat == IEditor.CHANGE_CASE_TO.LOWER ? tokText.toLowerCase(locale) : (toWhat == IEditor.CHANGE_CASE_TO.UPPER ? tokText.toUpperCase(locale) : (toWhat == IEditor.CHANGE_CASE_TO.TITLE ? StringUtil.toTitleCase(tokText, locale) : tokText));
            buffer.replace(token.getOffset() + lengthIncrement, token.getLength() + token.getOffset() + lengthIncrement, result);
            lengthIncrement += result.length() - token.getLength();
        }
        return buffer.toString();
    }

    private static IEditor.CHANGE_CASE_TO determineTargetCase(int lower, int upper, int title, int mixed, int ambiguous) {
        int presentCaseTypes = 0;
        if (lower > 0) {
            ++presentCaseTypes;
        }
        if (upper > 0) {
            ++presentCaseTypes;
        }
        if (title > 0) {
            ++presentCaseTypes;
        }
        if (mixed > 0) {
            ++presentCaseTypes;
        }
        if ((title > 0 || ambiguous > 0) && lower > 0 && upper == 0 && mixed == 0) {
            return IEditor.CHANGE_CASE_TO.TITLE;
        }
        if (mixed > 0 || presentCaseTypes > 1) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (lower > 0) {
            return IEditor.CHANGE_CASE_TO.SENTENCE;
        }
        if (title > 0) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (upper > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        if (ambiguous > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        return IEditor.CHANGE_CASE_TO.UPPER;
    }

    public static String replaceGlossaryEntries(String text) {
        Locale locale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        return EditorUtils.replaceGlossaryEntries(text, Core.getGlossaryManager().getGlossaryEntries(text), locale, tokenizer);
    }

    public static String replaceGlossaryEntries(String text, List<GlossaryEntry> entries, Locale locale, ITokenizer tokenizer) {
        if (StringUtil.isEmpty(text) || entries == null || entries.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (String tok : tokenizer.tokenizeVerbatimToStrings(text)) {
            boolean replaced = false;
            for (GlossaryEntry e : entries) {
                if (!tok.equalsIgnoreCase(e.getSrcText())) continue;
                sb.append(StringUtil.matchCapitalization(e.getLocText(), tok, locale));
                replaced = true;
                break;
            }
            if (replaced) continue;
            sb.append(tok);
        }
        return sb.toString();
    }
}

