/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.util.Map;
import javax.swing.Icon;

public class MainMenuIcons {
    private static final int ICON_SIZE = 12;

    static Icon newBlankIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        };
    }

    static Icon newColorIcon(final Color color) {
        return new BaseIcon(){

            @Override
            void doPaint(Graphics2D g2, int x, int y) {
                if (color != null) {
                    g2.setColor(color);
                }
                g2.fillRect(x, y, 12, 12);
            }
        };
    }

    static Icon newTextIcon(Color color, char c) {
        return MainMenuIcons.newTextIcon(color, null, c);
    }

    static Icon newTextIcon(final Color color, final Font font, char c) {
        final char[] chars = new char[]{c};
        return new BaseIcon(){

            @Override
            void doPaint(Graphics2D g2, int x, int y) {
                if (color != null) {
                    g2.setColor(color);
                }
                Font originalFont = g2.getFont();
                if (font != null) {
                    g2.setFont(font);
                }
                GlyphVector gv = g2.getFont().layoutGlyphVector(g2.getFontRenderContext(), chars, 0, 1, 0);
                Rectangle r = gv.getPixelBounds(g2.getFontRenderContext(), 0.0f, 0.0f);
                int dx = x + r.x + (12 - r.width) / 2;
                int dy = y + 12 - (r.y + r.height) - (12 - r.height) / 2;
                g2.drawGlyphVector(gv, dx, dy);
                g2.setFont(originalFont);
            }
        };
    }

    private static abstract class BaseIcon
    implements Icon {
        private Map defaultHints;
        private Map originalHints = new RenderingHints(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BaseIcon() {
            try {
                this.defaultHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            }
            catch (AWTError aWTError) {
            }
            finally {
                if (this.defaultHints == null) {
                    this.defaultHints = new RenderingHints(null);
                }
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            this.getRenderingHints(g2, this.defaultHints, this.originalHints);
            g2.addRenderingHints(this.defaultHints);
            this.doPaint(g2, x, y);
            g2.addRenderingHints(this.originalHints);
        }

        abstract void doPaint(Graphics2D var1, int var2, int var3);

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        private Map getRenderingHints(Graphics2D g2d, Map hintsToSave, Map savedHints) {
            if (savedHints == null) {
                savedHints = new RenderingHints(null);
            } else {
                savedHints.clear();
            }
            if (hintsToSave.isEmpty()) {
                return savedHints;
            }
            for (Object o : hintsToSave.keySet()) {
                RenderingHints.Key key = (RenderingHints.Key)o;
                Object value = g2d.getRenderingHint(key);
                savedHints.put(key, value);
            }
            return savedHints;
        }
    }
}

