/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.Locale;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class Language
implements Comparable<Object> {
    private Locale locale = new Locale("");
    private String languageCode;
    private String countryCode;
    public static final Language[] LANGUAGES = new Language[]{new Language("AA"), new Language("AA-DJ"), new Language("AA-ER"), new Language("AB"), new Language("AE"), new Language("AF"), new Language("AF-NA"), new Language("AF-ZA"), new Language("AF-ZW"), new Language("AK"), new Language("AM"), new Language("AN"), new Language("AR"), new Language("AR-AE"), new Language("AR-BH"), new Language("AR-DZ"), new Language("AR-EG"), new Language("AR-IQ"), new Language("AR-JO"), new Language("AR-KW"), new Language("AR-LB"), new Language("AR-LY"), new Language("AR-MA"), new Language("AR-OM"), new Language("AR-QA"), new Language("AR-SA"), new Language("AR-SD"), new Language("AR-SY"), new Language("AR-TN"), new Language("AR-US"), new Language("AR-YE"), new Language("AS"), new Language("AV"), new Language("AY"), new Language("AZ"), new Language("BA"), new Language("BE"), new Language("BG"), new Language("BH"), new Language("BI"), new Language("BM"), new Language("BN"), new Language("BO"), new Language("BR"), new Language("BS"), new Language("CA"), new Language("CE"), new Language("CH"), new Language("CO"), new Language("CR"), new Language("CS"), new Language("CU"), new Language("CV"), new Language("CY"), new Language("DA"), new Language("DE"), new Language("DE-AT"), new Language("DE-CH"), new Language("DE-DE"), new Language("DE-LU"), new Language("DV"), new Language("DZ"), new Language("EE"), new Language("EL"), new Language("EN"), new Language("EN-AU"), new Language("EN-CA"), new Language("EN-GB"), new Language("EN-IE"), new Language("EN-IN"), new Language("EN-NZ"), new Language("EN-US"), new Language("EN-ZA"), new Language("EO"), new Language("ES"), new Language("ES-AR"), new Language("ES-BO"), new Language("ES-CL"), new Language("ES-CO"), new Language("ES-CR"), new Language("ES-DO"), new Language("ES-EC"), new Language("ES-ES"), new Language("ES-GT"), new Language("ES-HN"), new Language("ES-MX"), new Language("ES-NI"), new Language("ES-PA"), new Language("ES-PE"), new Language("ES-PR"), new Language("ES-PY"), new Language("ES-SV"), new Language("ES-US"), new Language("ES-UY"), new Language("ES-VE"), new Language("ET"), new Language("EU"), new Language("FA"), new Language("FA-AF"), new Language("FA-IR"), new Language("FF"), new Language("FI"), new Language("FJ"), new Language("FO"), new Language("FR"), new Language("FR-BE"), new Language("FR-CA"), new Language("FR-CH"), new Language("FR-FR"), new Language("FR-LU"), new Language("FY"), new Language("GA"), new Language("GD"), new Language("GL"), new Language("GN"), new Language("GU"), new Language("GV"), new Language("HA"), new Language("HE"), new Language("HI"), new Language("HO"), new Language("HR"), new Language("HT"), new Language("HU"), new Language("HY"), new Language("HZ"), new Language("IA"), new Language("ID"), new Language("IE"), new Language("IG"), new Language("II"), new Language("IK"), new Language("IO"), new Language("IS"), new Language("IT"), new Language("IT-CH"), new Language("IT-IT"), new Language("IU"), new Language("JA"), new Language("JV"), new Language("KA"), new Language("KG"), new Language("KI"), new Language("KJ"), new Language("KK"), new Language("KL"), new Language("KM"), new Language("KN"), new Language("KO"), new Language("KR"), new Language("KS"), new Language("KU"), new Language("KV"), new Language("KW"), new Language("KY"), new Language("LA"), new Language("LB"), new Language("LG"), new Language("LI"), new Language("LN"), new Language("LO"), new Language("LT"), new Language("LU"), new Language("LV"), new Language("MG"), new Language("MH"), new Language("MI"), new Language("MK"), new Language("ML"), new Language("MN"), new Language("MO"), new Language("MR"), new Language("MS"), new Language("MT"), new Language("MY"), new Language("NA"), new Language("NB"), new Language("ND"), new Language("NE"), new Language("NG"), new Language("NL"), new Language("NL-BE"), new Language("NL-NL"), new Language("NN"), new Language("NO"), new Language("NR"), new Language("NV"), new Language("NY"), new Language("OC"), new Language("OJ"), new Language("OM"), new Language("OR"), new Language("OS"), new Language("PA"), new Language("PA-IN"), new Language("PA-PK"), new Language("PI"), new Language("PL"), new Language("PS"), new Language("PT"), new Language("PT-BR"), new Language("PT-PT"), new Language("QU"), new Language("RM"), new Language("RN"), new Language("RO"), new Language("RU"), new Language("RU-BY"), new Language("RU-RU"), new Language("RW"), new Language("SA"), new Language("SC"), new Language("SD"), new Language("SD-IN"), new Language("SD-PK"), new Language("SE"), new Language("SG"), new Language("SH"), new Language("SI"), new Language("SK"), new Language("SL"), new Language("SM"), new Language("SM-AS"), new Language("SM-WS"), new Language("SN"), new Language("SO"), new Language("SQ"), new Language("SR"), new Language("SS"), new Language("ST"), new Language("SU"), new Language("SV"), new Language("SW"), new Language("TA"), new Language("TE"), new Language("TG"), new Language("TH"), new Language("TI"), new Language("TK"), new Language("TL"), new Language("TN"), new Language("TO"), new Language("TR"), new Language("TS"), new Language("TT"), new Language("TW"), new Language("TY"), new Language("UG"), new Language("UK"), new Language("UR"), new Language("UR-IN"), new Language("UR-PK"), new Language("UZ"), new Language("VE"), new Language("VI"), new Language("VO"), new Language("WA"), new Language("WO"), new Language("XH"), new Language("YI"), new Language("YO"), new Language("ZA"), new Language("ZH"), new Language("ZH-CN"), new Language("ZH-HK"), new Language("ZH-TW"), new Language("ZU")};

    public Language(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
        this.languageCode = this.locale.getLanguage();
        this.countryCode = this.locale.getCountry();
    }

    public Language(String str) {
        Matcher m;
        this.languageCode = "";
        this.countryCode = "";
        this.locale = new Locale("");
        if (str != null && (m = PatternConsts.LANG_AND_COUNTRY.matcher(str)).matches() && m.groupCount() >= 1) {
            this.languageCode = m.group(1);
            if (m.group(2) != null) {
                this.countryCode = m.group(2);
            }
            this.locale = new Locale(this.languageCode.toLowerCase(Locale.ENGLISH), this.countryCode.toUpperCase(Locale.ENGLISH));
        }
    }

    public String getDisplayName() {
        return this.locale.getDisplayName();
    }

    public String toString() {
        return this.getLanguage();
    }

    public String getLanguage() {
        String langstring = this.getLanguageCode();
        if (!langstring.isEmpty() && !this.getCountryCode().isEmpty()) {
            langstring = langstring + "-" + this.getCountryCode();
        }
        return langstring;
    }

    public String getLocaleCode() {
        if (this.locale == null) {
            return "";
        }
        String returnString = this.locale.toString();
        if (returnString.length() < 2) {
            return returnString;
        }
        if (returnString.substring(0, 2).equalsIgnoreCase("in")) {
            returnString = "id" + returnString.substring(2);
        } else if (returnString.substring(0, 2).equalsIgnoreCase("iw")) {
            returnString = "he" + returnString.substring(2);
        } else if (returnString.substring(0, 2).equalsIgnoreCase("ji")) {
            returnString = "yi" + returnString.substring(2);
        }
        return returnString;
    }

    public String getLocaleLCID() {
        return this.getLocaleCode().toLowerCase().replace("_", "-");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguageCode() {
        if (this.languageCode == null) {
            return "";
        }
        return this.languageCode;
    }

    public String getCountryCode() {
        if (this.countryCode == null) {
            return "";
        }
        return this.countryCode;
    }

    public boolean isSpaceDelimited() {
        return !"ZH".equalsIgnoreCase(this.languageCode) && !"JA".equalsIgnoreCase(this.languageCode);
    }

    public boolean equals(Object lang) {
        if (this == lang) {
            return true;
        }
        if (lang == null) {
            return false;
        }
        if (!(lang instanceof Language)) {
            return false;
        }
        Language that = (Language)lang;
        return this.getLocaleCode().equals(that.getLocaleCode());
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof Language) {
            return this.getLanguage().compareTo(((Language)o).getLanguage());
        }
        return this.getLanguage().compareTo(o.toString());
    }
}

