/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.omegat.util.StringUtil;

public class OStrings {
    private static String __VERSION_KEY = "version";
    private static String __UPDATE_KEY = "update";
    private static String __REVISION_KEY = "revision";
    public static String BRANDING = "";
    public static final String VERSION = ResourceBundle.getBundle("org/omegat/Version").getString(__VERSION_KEY);
    public static final String UPDATE = ResourceBundle.getBundle("org/omegat/Version").getString(__UPDATE_KEY);
    public static final String REVISION = ResourceBundle.getBundle("org/omegat/Version").getString(__REVISION_KEY);
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");

    public static ResourceBundle getResourceBundle() {
        return bundle;
    }

    public static void loadBundle(String filename) {
        boolean loaded = false;
        try {
            FileInputStream in = new FileInputStream(filename);
            bundle = new PropertyResourceBundle(in);
            loaded = true;
            in.close();
        }
        catch (FileNotFoundException exception) {
            System.err.println("Resource bundle file not found: " + filename);
        }
        catch (IOException exception) {
            System.err.println("Error while reading resource bundle file: " + filename);
        }
        if (!loaded) {
            System.err.println("Reverting to resource bundle for the default locale");
            bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        }
    }

    public static String getString(String key) {
        return bundle.getString(key);
    }

    public static String getApplicationDisplayName() {
        String name = bundle.getString("application-name");
        return BRANDING.isEmpty() ? name : name + " " + BRANDING;
    }

    public static String getApplicationName() {
        String name = bundle.getString("application-name");
        return BRANDING.isEmpty() ? name : name + "_" + BRANDING;
    }

    public static String getBrandingToken() {
        return BRANDING.isEmpty() ? "" : "-" + BRANDING;
    }

    public static String getDisplayNameAndVersion() {
        if (UPDATE != null && !UPDATE.equals("0")) {
            return StringUtil.format(OStrings.getString("app-version-template-pretty-update"), OStrings.getApplicationDisplayName(), VERSION, UPDATE);
        }
        return StringUtil.format(OStrings.getString("app-version-template-pretty"), OStrings.getApplicationDisplayName(), VERSION);
    }

    public static String getNameAndVersion() {
        return StringUtil.format(OStrings.getString("app-version-template"), OStrings.getApplicationName(), VERSION, UPDATE, REVISION);
    }

    public static String getVersion() {
        return StringUtil.format(OStrings.getString("version-template"), VERSION, UPDATE, REVISION);
    }

    public static String getProgressBarDefaultPrecentageText() {
        return StringUtil.format(OStrings.getString("MW_PROGRESS_DEFAULT_PERCENTAGE"), "--%", "--", "--%", "--", "--");
    }

    public static String getSegmentMarker() {
        return OStrings.getString("TF_CUR_SEGMENT_START");
    }
}

