/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.omegat.util.Base64;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class WikiGet {
    protected static final String CHARSET_MARK = "charset=";

    public static String joinString(String separator, String[] items) {
        if (items.length < 1) {
            return "";
        }
        StringBuilder joined = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            joined.append(items[i]);
            if (i == items.length - 1) continue;
            joined.append(separator);
        }
        return joined.toString();
    }

    public static void doWikiGet(String remote_url, String projectdir) {
        try {
            String[] splitted;
            String joined = null;
            String name = null;
            if (remote_url.indexOf("index.php?title=") > 0) {
                String s;
                splitted = remote_url.split("index.php\\?title=");
                name = s = splitted[splitted.length - 1];
                splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
                joined = WikiGet.joinString("index.php?title=", splitted);
                joined = joined + "&action=raw";
            } else {
                String s;
                splitted = remote_url.split("/");
                name = s = splitted[splitted.length - 1];
                splitted[splitted.length - 1] = s = s.replaceAll(" ", "_");
                joined = WikiGet.joinString("/", splitted);
                joined = joined + "?action=raw";
            }
            String page = WikiGet.getURL(joined);
            WikiGet.saveUTF8(projectdir, name + ".UTF8", page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printUTF8(String output) {
        try {
            BufferedWriter out = WikiGet.UTF8WriterBuilder(System.out);
            out.write(output);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedWriter UTF8WriterBuilder(OutputStream out) throws Exception {
        return new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
    }

    public static void saveUTF8(String dir, String filename, String output) {
        try {
            filename = filename.replaceAll("[\\\\/:\\*\\?\\\"\\|\\<\\>]", "_");
            File path = new File(dir, filename);
            FileOutputStream f = new FileOutputStream(path);
            BufferedWriter out = WikiGet.UTF8WriterBuilder(f);
            out.write(output);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getURL(String target) throws IOException {
        int n;
        StringBuilder page = new StringBuilder();
        URL url = new URL(target);
        InputStream in = url.openStream();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            page.append(new String(b, 0, n, "UTF-8"));
        }
        return page.toString();
    }

    public static String post(String address, Map<String, String> params) throws IOException {
        return WikiGet.post(address, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        String url;
        if (params == null || params.isEmpty()) {
            url = address;
        } else {
            StringBuilder s = new StringBuilder();
            s.append(address).append('?');
            boolean next = false;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (next) {
                    s.append('&');
                } else {
                    next = true;
                }
                s.append(p.getKey());
                s.append('=');
                s.append(URLEncoder.encode(p.getValue(), "UTF-8"));
            }
            url = s.toString();
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            String encodedUser;
            conn.setRequestMethod("GET");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            if (!StringUtil.isEmpty(encodedUser = Preferences.getPreference("proxy_user_name"))) {
                String encodedPassword = Preferences.getPreference("proxy_password");
                try {
                    String pass = new String(Base64.decode(encodedUser));
                    pass = pass + ":" + new String(Base64.decode(encodedPassword));
                    encodedPassword = Base64.encodeBytes(pass.getBytes());
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
                }
                catch (IOException ex) {
                    Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
                    Log.log(ex);
                }
            }
            conn.setDoOutput(true);
            String string = WikiGet.getStringContent(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        URL url = new URL(address);
        ByteArrayOutputStream pout = new ByteArrayOutputStream();
        for (Map.Entry<String, String> p : params.entrySet()) {
            if (pout.size() > 0) {
                pout.write(38);
            }
            pout.write(p.getKey().getBytes("UTF-8"));
            pout.write(61);
            pout.write(URLEncoder.encode(p.getValue(), "UTF-8").getBytes("UTF-8"));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String encodedUser;
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", Integer.toString(pout.size()));
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            if (!StringUtil.isEmpty(encodedUser = Preferences.getPreference("proxy_user_name"))) {
                String encodedPassword = Preferences.getPreference("proxy_password");
                try {
                    String pass = new String(Base64.decode(encodedUser));
                    pass = pass + ":" + new String(Base64.decode(encodedPassword));
                    encodedPassword = Base64.encodeBytes(pass.getBytes());
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
                }
                catch (IOException ex) {
                    Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
                    Log.log(ex);
                }
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream cout = conn.getOutputStream();
            cout.write(pout.toByteArray());
            cout.flush();
            String string = WikiGet.getStringContent(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringContent(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() != 200) {
            throw new ResponseError(conn);
        }
        String contentType = conn.getHeaderField("Content-Type");
        int cp = contentType != null ? contentType.indexOf(CHARSET_MARK) : -1;
        String charset = cp >= 0 ? contentType.substring(cp + CHARSET_MARK.length()) : "ISO8859-1";
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        InputStream in = conn.getInputStream();
        try {
            LFileCopy.copy(in, (OutputStream)res);
        }
        finally {
            in.close();
        }
        return new String(res.toByteArray(), charset);
    }

    public static class ResponseError
    extends IOException {
        public final int code;
        public final String message;

        public ResponseError(HttpURLConnection conn) throws IOException {
            super(conn.getResponseCode() + ": " + conn.getResponseMessage());
            this.code = conn.getResponseCode();
            this.message = conn.getResponseMessage();
        }
    }
}

