/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class OSXIntegration {
    private static volatile Class<?> appClass;
    private static volatile Object app;
    private static boolean guiLoaded;
    private static final List<Runnable> doAfterLoad;
    private static final IApplicationEventListener appListener;
    private static final IOpenFilesHandler openFilesHandler;
    private static final IProjectEventListener projectListener;

    public static void init() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OmegaT");
            Class<?> strategyClass = Class.forName("com.apple.eawt.QuitStrategy");
            Method setQuitStrategy = OSXIntegration.getAppClass().getDeclaredMethod("setQuitStrategy", strategyClass);
            setQuitStrategy.invoke(OSXIntegration.getApp(), strategyClass.getField("CLOSE_ALL_WINDOWS").get(null));
            Method disableTerm = OSXIntegration.getAppClass().getDeclaredMethod("disableSuddenTermination", new Class[0]);
            disableTerm.invoke(OSXIntegration.getApp(), new Object[0]);
            CoreEvents.registerApplicationEventListener(appListener);
            OSXIntegration.setOpenFilesHandler(openFilesHandler);
            CoreEvents.registerProjectChangeListener(projectListener);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setAboutHandler(final ActionListener al) {
        try {
            Class<?> aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
            InvocationHandler ih = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("handleAbout")) {
                        al.actionPerformed(null);
                    }
                    return null;
                }
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{aboutHandlerClass}, ih);
            Method setAboutHandler = OSXIntegration.getAppClass().getDeclaredMethod("setAboutHandler", aboutHandlerClass);
            setAboutHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setQuitHandler(final ActionListener al) {
        try {
            Class<?> quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler");
            InvocationHandler ih = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("handleQuitRequestWith")) {
                        Class<?> quitResponseClass = Class.forName("com.apple.eawt.QuitResponse");
                        if (args != null && args.length > 1 && quitResponseClass.isInstance(args[1]) && Preferences.isPreference("always_confirm_quit")) {
                            Method cancelQuit = quitResponseClass.getDeclaredMethod("cancelQuit", new Class[0]);
                            cancelQuit.invoke(args[1], new Object[0]);
                        }
                        al.actionPerformed(null);
                    }
                    return null;
                }
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{quitHandlerClass}, ih);
            Method setQuitHandler = OSXIntegration.getAppClass().getDeclaredMethod("setQuitHandler", quitHandlerClass);
            setQuitHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setOpenFilesHandler(final IOpenFilesHandler ofh) {
        try {
            Class<?> openFilesHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler");
            InvocationHandler ih = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        if (method.getName().equals("openFiles")) {
                            Class<?> filesEventClass = Class.forName("com.apple.eawt.AppEvent$FilesEvent");
                            if (args != null && args.length > 0 && filesEventClass.isInstance(args[0])) {
                                Object filesEvent = args[0];
                                Method getFilesMethod = filesEventClass.getDeclaredMethod("getFiles", new Class[0]);
                                Object filesList = getFilesMethod.invoke(filesEvent, new Object[0]);
                                ofh.openFiles((List)filesList);
                            }
                        }
                    }
                    catch (Throwable t) {
                        Log.log(t);
                    }
                    return null;
                }
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{openFilesHandlerClass}, ih);
            Method setOpenFileHandler = OSXIntegration.getAppClass().getDeclaredMethod("setOpenFileHandler", openFilesHandlerClass);
            setOpenFileHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void enableFullScreen(Window window) {
        try {
            Class<?> utilClass = Class.forName("com.apple.eawt.FullScreenUtilities");
            Method setWindowCanFullScreen = utilClass.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            setWindowCanFullScreen.invoke(utilClass, window, true);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setProxyIcon(JRootPane rootPane, File file) {
        rootPane.putClientProperty("Window.documentFile", file);
    }

    public static void setModifiedIndicator(JRootPane rootPane, boolean isModified) {
        rootPane.putClientProperty("Window.documentModified", isModified);
    }

    private static Class<?> getAppClass() throws Exception {
        if (appClass == null) {
            appClass = Class.forName("com.apple.eawt.Application");
        }
        return appClass;
    }

    private static Object getApp() throws Exception {
        if (app == null) {
            Method getApp = OSXIntegration.getAppClass().getDeclaredMethod("getApplication", new Class[0]);
            app = getApp.invoke(null, new Object[0]);
        }
        return app;
    }

    static {
        guiLoaded = false;
        doAfterLoad = new ArrayList<Runnable>();
        appListener = new IApplicationEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onApplicationStartup() {
                guiLoaded = true;
                List list = doAfterLoad;
                synchronized (list) {
                    for (Runnable r : doAfterLoad) {
                        r.run();
                    }
                    doAfterLoad.clear();
                }
                JFrame window = Core.getMainWindow().getApplicationFrame();
                OSXIntegration.enableFullScreen(window);
            }

            @Override
            public void onApplicationShutdown() {
                guiLoaded = false;
            }
        };
        openFilesHandler = new IOpenFilesHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openFiles(List<File> files) {
                if (files.isEmpty()) {
                    return;
                }
                File firstFile = files.get(0);
                if (firstFile.getName().equals("omegat.project")) {
                    firstFile = firstFile.getParentFile();
                }
                if (!StaticUtils.isProjectDir(firstFile)) {
                    return;
                }
                final File projDir = firstFile;
                Runnable openProject = new Runnable(){

                    @Override
                    public void run() {
                        ProjectUICommands.projectOpen(projDir, true);
                    }
                };
                if (guiLoaded) {
                    SwingUtilities.invokeLater(openProject);
                } else {
                    List list = doAfterLoad;
                    synchronized (list) {
                        doAfterLoad.add(openProject);
                    }
                }
            }
        };
        projectListener = new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                JRootPane rootPane = Core.getMainWindow().getApplicationFrame().getRootPane();
                switch (eventType) {
                    case CREATE: 
                    case LOAD: {
                        String projDir = Core.getProject().getProjectProperties().getProjectRoot();
                        OSXIntegration.setProxyIcon(rootPane, new File(projDir));
                        break;
                    }
                    case CLOSE: {
                        OSXIntegration.setProxyIcon(rootPane, null);
                        break;
                    }
                    case MODIFIED: {
                        OSXIntegration.setModifiedIndicator(rootPane, true);
                        break;
                    }
                    case SAVE: {
                        OSXIntegration.setModifiedIndicator(rootPane, false);
                    }
                }
            }
        };
    }

    public static interface IOpenFilesHandler {
        public void openFiles(List<File> var1);
    }
}

